/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTProcessRunner;

public class ExternalCodeFormatJob
extends Job {
    private String inputText;
    private String command;
    private String formattedText;

    public ExternalCodeFormatJob(String name, String inputText, String command) {
        super(name);
        this.inputText = inputText;
        this.command = command;
    }

    protected IStatus run(IProgressMonitor monitor) {
        File tempFile;
        monitor.beginTask(this.getName(), -1);
        try {
            tempFile = File.createTempFile("DvtFormatSource", null);
            tempFile.deleteOnExit();
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter out = new BufferedWriter(new FileWriter(tempFile));){
                out.write(this.inputText);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e1) {
            this.formattedText = String.valueOf(this.getName()) + ": " + e1.getMessage();
            return Status.OK_STATUS;
        }
        DVTProcessRunner processRunner = new DVTProcessRunner(this.command.replaceAll("%f", tempFile.getAbsolutePath()));
        try {
            processRunner.run(monitor);
        }
        catch (IOException iOException) {
            this.formattedText = "Could not execute: " + processRunner.getCommandLine();
            return Status.OK_STATUS;
        }
        if (processRunner.getExitValue() != 0) {
            this.formattedText = "External program terminated with error: " + processRunner.getErrorOutput();
            return Status.OK_STATUS;
        }
        this.formattedText = DVTFileUtils.getInstance().readFileContent(tempFile);
        return Status.OK_STATUS;
    }

    public String getFormattedText() {
        return this.formattedText;
    }
}

