/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.TextConsolePage;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.hover.AnnotationExpansionControl;
import ro.amiq.dvt.ui.editor.hover.ISingleClickListener;

public class ExternalToolsAnnotationClickListener
implements ISingleClickListener {
    @Override
    public void singleClick(MouseEvent e) {
        AnnotationExpansionControl.Item item = (AnnotationExpansionControl.Item)((Widget)e.getSource()).getData();
        if (e.button == 3 && item.fAnnotation instanceof MarkerAnnotation) {
            int hashCode = Integer.parseInt(((MarkerAnnotation)item.fAnnotation).getMarker().getAttribute("consoleHashCode", "-1"));
            int offset = Integer.parseInt(((MarkerAnnotation)item.fAnnotation).getMarker().getAttribute("consoleOffset", "-1"));
            String messageInConsole = ((MarkerAnnotation)item.fAnnotation).getMarker().getAttribute("attrConsoleMessage", "");
            IConsole[] iConsoleArray = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
            int n = iConsoleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole i = iConsoleArray[n2];
                if (i.hashCode() == hashCode) {
                    Job.getJobManager().addJobChangeListener((IJobChangeListener)new ShowConsoleViewJobListener(offset, messageInConsole));
                    ConsolePlugin.getDefault().getConsoleManager().showConsoleView(i);
                    return;
                }
                ++n2;
            }
            MessageDialog.openInformation((Shell)Utils.getActiveShell(), (String)"Unable to find the External Builder Console", (String)"The External Builder Console where this problem was reported is not opened any more.");
        }
    }

    private static class ShowConsoleViewJobListener
    extends JobChangeAdapter {
        private int fOffset;
        private String fMessageInConsole;

        public ShowConsoleViewJobListener(int offset, String messageInConsole) {
            this.fOffset = offset;
            this.fMessageInConsole = messageInConsole;
            Job removeListenerJob = new Job("Show Console View Watchdog"){

                protected IStatus run(IProgressMonitor monitor) {
                    Job.getJobManager().removeJobChangeListener((IJobChangeListener)this);
                    return Status.OK_STATUS;
                }
            };
            removeListenerJob.schedule(500L);
        }

        public void done(IJobChangeEvent event) {
            if (!event.getJob().getName().equals("Show Console View")) {
                return;
            }
            try {
                PageBookView consolePageBookView;
                IViewPart consoleView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.console.ConsoleView");
                if (consoleView instanceof PageBookView && (consolePageBookView = (PageBookView)consoleView).getCurrentPage() instanceof TextConsolePage) {
                    TextConsolePage consolePage = (TextConsolePage)consolePageBookView.getCurrentPage();
                    consolePage.getViewer().getFindReplaceTarget().findAndSelect(this.fOffset, this.fMessageInConsole, true, true, false);
                }
            }
            catch (PartInitException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)this);
        }
    }
}

