/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import ro.amiq.dvt.DVTPlugin;

public class FileAcessEditorDecorator
implements IPartListener2,
IWindowListener {
    private static final Set<String> EXCLUDED_EDITORS = new HashSet<String>();
    private static final Method SET_PART_NAME_METHOD;
    private static volatile FileAcessEditorDecorator fInstance;
    private static final Object fSyncInstance;

    static {
        Method method = null;
        try {
            method = EditorPart.class.getDeclaredMethod("setPartName", String.class);
            method.setAccessible(true);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        SET_PART_NAME_METHOD = method;
        fSyncInstance = new Object();
    }

    public static void excludeEditor(Class<?> clazz) {
        if (clazz != null) {
            EXCLUDED_EDITORS.add(clazz.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileAcessEditorDecorator getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new FileAcessEditorDecorator();
            }
        }
        return fInstance;
    }

    private FileAcessEditorDecorator() {
        IWorkbenchWindow[] windows;
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            window.getPartService().addPartListener((IPartListener2)this);
            ++n2;
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        this.handleRO(partRef);
    }

    public void handleRO(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part == null) {
            return;
        }
        if (!(part instanceof EditorPart)) {
            return;
        }
        if (EXCLUDED_EDITORS.contains(part.getClass().getName())) {
            return;
        }
        EditorPart editorPart = (EditorPart)part;
        IEditorInput input = editorPart.getEditorInput();
        if (!(input instanceof IPathEditorInput)) {
            return;
        }
        IResource resource = (IResource)input.getAdapter(IResource.class);
        if (resource == null || !resource.isAccessible() || resource.isVirtual()) {
            return;
        }
        String prefix = "";
        IPath location = resource.getLocation();
        if (location == null) {
            return;
        }
        if (DVTPlugin.getDefault().getPreferenceStore().getBoolean("showReadOnlyDecorators") && !location.toFile().canWrite()) {
            prefix = String.valueOf(DVTPlugin.getDefault().getPreferenceStore().getString("readOnlyDecorator")) + " ";
        }
        String currentName = resource.getName();
        try {
            SET_PART_NAME_METHOD.invoke((Object)editorPart, String.valueOf(prefix) + currentName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.getPartService().removePartListener((IPartListener2)this);
    }

    public void windowOpened(IWorkbenchWindow window) {
        window.getPartService().addPartListener((IPartListener2)this);
    }
}

