/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.ui.texteditor.ResourceAction;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTFileUtils;

public class JumpAroundBracketAction
extends ResourceAction {
    private boolean fForward;
    private static final Set<Character> OPEN_BRACKS = new HashSet<Character>(Arrays.asList(Character.valueOf('('), Character.valueOf('['), Character.valueOf('{')));
    private static final Set<Character> CLOSE_BRACKS = new HashSet<Character>(Arrays.asList(Character.valueOf(')'), Character.valueOf(']'), Character.valueOf('}')));
    private Set<Character> fOpenBracket;
    private Set<Character> fClosedBracket;
    private DVTEditor fDVTEditor;

    public JumpAroundBracketAction(DVTEditor dvtEditor, ResourceBundle bundle, String prefix, boolean forward) {
        super(bundle, prefix);
        this.fForward = forward;
        this.fDVTEditor = dvtEditor;
        this.fOpenBracket = this.fForward ? OPEN_BRACKS : CLOSE_BRACKS;
        this.fClosedBracket = this.fForward ? CLOSE_BRACKS : OPEN_BRACKS;
    }

    public void run() {
        IDocument document = this.fDVTEditor.getDocument();
        String partitioning = DVTFileUtils.getInstance().getPartitioning((IDocumentExtension3)document);
        int offset = this.fDVTEditor.getCursor();
        DVTCharacterScanner scanner = new DVTCharacterScanner(2000, document, offset + (this.fForward ? 0 : -1), this.fForward);
        int nestedLevel = 0;
        int searchLimit = 0;
        int c = scanner.read();
        while (c != -1) {
            if (searchLimit == 20000) break;
            try {
                if (scanner.getOffset() != 0 && !"__dftl_partition_content_type".equals(((IDocumentExtension3)document).getContentType(partitioning, scanner.getOffset() + (this.fForward ? 0 : -1), false))) {
                    c = scanner.read();
                    continue;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            ++searchLimit;
            char ch = (char)c;
            if (this.fOpenBracket.contains(Character.valueOf(ch))) {
                ++nestedLevel;
            }
            if (this.fClosedBracket.contains(Character.valueOf(ch))) {
                if (nestedLevel == 0) {
                    this.fDVTEditor.selectAndReveal(scanner.getOffset(), 0);
                    return;
                }
                --nestedLevel;
            }
            c = scanner.read();
        }
    }
}

