/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.DVTEditorAssociationOverride;
import ro.amiq.dvt.utils.DVTFileUtils;

public class LargeFileEditor
extends EditorPart {
    public static final String ID = "ro.amiq.dvt.ui.editor.LargeFileEditor";
    private static final String PREFERENCE_PAGE_ID = "ro.amiq.dvt.EditorsPreferencePage";
    private Composite controlParent;
    private IEditorDescriptor largeFileEditor;
    private IEditorInput largeFileInput;
    private Button openAnyway;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        super.setPartName(input.getName());
        this.largeFileInput = input;
        IEditorDescriptor editorDescriptor = IDE.getEditorDescriptor((String)((FileEditorInput)input).getFile().getName());
        this.largeFileEditor = DVTEditorAssociationOverride.getEditorDescriptor(((FileEditorInput)input).getFile(), editorDescriptor);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.controlParent = new Composite(parent, 0);
        this.controlParent.setLayout((Layout)new GridLayout());
        DVTUiUtils.setPlatformEditorColors((Control)this.controlParent);
        Label topSpacer = new Label(this.controlParent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)topSpacer);
        Composite contentComposite = new Composite(this.controlParent, 0);
        contentComposite.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(0x1000000, 1).grab(true, true).applyTo((Control)contentComposite);
        Label firstBottomSpacer = new Label(this.controlParent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)firstBottomSpacer);
        Label secondBottomSpacer = new Label(this.controlParent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)secondBottomSpacer);
        Label fileTooBigTitle = new Label(contentComposite, 0);
        fileTooBigTitle.setText("You are opening a large file");
        fileTooBigTitle.setFont(DVTUiUtils.getDoubleFont());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)fileTooBigTitle);
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        Link fileTooBigText = new Link(contentComposite, 0);
        fileTooBigText.setText(String.format("\nThe file you are trying to open is %.2f MB (<a href=\"configure\">configure threshold</a>).\nOpening large files may lead to excessive memory consumption and slowdowns.\n", Float.valueOf(DVTFileUtils.computeFileSizeMB(file.getLocationURI()))));
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)fileTooBigText);
        fileTooBigText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)DVTUiUtils.getActiveWorkbenchShell(), (String)LargeFileEditor.PREFERENCE_PAGE_ID, null, null).open();
            }
        });
        this.openAnyway = new Button(contentComposite, 0);
        this.openAnyway.setText("Open Anyway");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, true).applyTo((Control)this.openAnyway);
        this.openAnyway.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IEditorReference ref = (IEditorReference)activePage.getActivePartReference();
                    if (ref == null) {
                        return;
                    }
                    activePage.openEditor(LargeFileEditor.this.largeFileInput, LargeFileEditor.this.largeFileEditor.getId(), true, 0);
                    activePage.closeEditor(ref.getEditor(false), false);
                }
                catch (CoreException e1) {
                    DVTLogger.INSTANCE.logError((Throwable)e1);
                }
            }
        });
        this.controlParent.setFocus();
    }

    public void setFocus() {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench == null) {
                return;
            }
            IWorkbenchPage activePage = workbench.getActiveWorkbenchWindow().getActivePage();
            if (activePage == null) {
                return;
            }
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput == null) {
                return;
            }
            IFile file = (IFile)editorInput.getAdapter(IFile.class);
            if (file == null) {
                return;
            }
            if (!DVTFileUtils.isLargeFile(file.getLocationURI())) {
                activePage.closeEditor((IEditorPart)this, false);
                IEditorDescriptor editorDescriptor = IDE.getEditorDescriptor((String)((FileEditorInput)this.getEditorInput()).getFile().getName());
                activePage.openEditor(editorInput, DVTEditorAssociationOverride.getEditorDescriptor(((FileEditorInput)editorInput).getFile(), editorDescriptor).getId());
                return;
            }
        }
        catch (PartInitException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

