/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.ui.custompragma.CustomPragma;
import ro.amiq.dvt.ui.custompragma.CustomPragmaPosition;
import ro.amiq.dvt.ui.custompragma.ICustomPragmaStyleListener;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class LineBackgroundPainter
implements IPainter,
LineBackgroundListener,
IPropertyChangeListener,
SelectionListener,
ICustomPragmaStyleListener {
    private static final EnumSet<LineBackgroundKind> ALL = EnumSet.allOf(LineBackgroundKind.class);
    private Map<String, Color> fCustomPragmaColors = new HashMap<String, Color>();
    private EnumSet<LineBackgroundKind> painterConfig = EnumSet.noneOf(LineBackgroundKind.class);
    private ITextViewer fTextViewer;
    private IPreferenceStore fPreferenceStore;
    private Map<LineBackgroundKind, List<Position>> fPositions = new EnumMap<LineBackgroundKind, List<Position>>(LineBackgroundKind.class);
    private Map<LineBackgroundKind, Color> fColors = new EnumMap<LineBackgroundKind, Color>(LineBackgroundKind.class);
    private boolean fActive;

    public LineBackgroundPainter(ITextViewer textViewer, IPreferenceStore preferenceStore, IProject project) {
        this.fTextViewer = textViewer;
        this.fPreferenceStore = preferenceStore;
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        }
        if (this.fPreferenceStore == null) {
            this.fColors.put(LineBackgroundKind.INACTIVE, DVTColorUtil.INSTANCE.getColor(210, 210, 210));
            this.fColors.put(LineBackgroundKind.PROTECTED, DVTColorUtil.INSTANCE.getColor(253, 244, 228));
            this.fColors.put(LineBackgroundKind.INSPECT_FILE_INFO, DVTColorUtil.INSTANCE.getColor(192, 192, 192));
            this.fColors.put(LineBackgroundKind.INSPECT_INTEREST, DVTColorUtil.INSTANCE.getColor(255, 255, 255));
            this.fColors.put(LineBackgroundKind.INACTIVE_GENERATE_BRANCH, DVTColorUtil.INSTANCE.getColor(210, 210, 210));
            this.fColors.put(LineBackgroundKind.PVLOG_PREPROC, DVTColorUtil.INSTANCE.getColor(210, 210, 210));
            this.fColors.put(LineBackgroundKind.PVLOG_GENERATED, DVTColorUtil.INSTANCE.getColor(210, 210, 210));
        }
        this.fActive = false;
        this.setEnablementFromPrefStore();
        this.initializeColorsFromPrefStore();
        this.updateCustomPragmas(project);
    }

    private void initializeColorsFromPrefStore() {
        LineBackgroundKind[] lineBackgroundKindArray = LineBackgroundKind.values();
        int n = lineBackgroundKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            LineBackgroundKind kind = lineBackgroundKindArray[n2];
            this.setColorFromPrefStore(kind);
            ++n2;
        }
        if (!this.painterConfig.isEmpty()) {
            this.activate();
        }
    }

    public void setHighlightPositions(List<Position> positions, LineBackgroundKind kind) {
        if (kind == null) {
            return;
        }
        this.deactivate(true);
        this.fPositions.put(kind, positions);
        if (!this.painterConfig.isEmpty()) {
            this.activate();
        }
    }

    public void dispose() {
        this.deactivate(true);
        this.fTextViewer = null;
        this.fPositions = null;
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.painterConfig = null;
    }

    public void paint(int reason) {
        if (this.fTextViewer == null) {
            return;
        }
        for (LineBackgroundKind kind : this.painterConfig) {
            this.redrawPositions(kind);
        }
    }

    private void activate() {
        StyledText textWidget = this.fTextViewer.getTextWidget();
        if (textWidget == null) {
            return;
        }
        if (!this.fActive) {
            this.fActive = true;
            textWidget.addLineBackgroundListener((LineBackgroundListener)this);
            textWidget.addSelectionListener((SelectionListener)this);
        }
        for (LineBackgroundKind kind : this.painterConfig) {
            this.redrawPositions(kind);
        }
    }

    private void redrawPositions(LineBackgroundKind kind) {
        if (this.fTextViewer.getDocument() == null) {
            return;
        }
        StyledText textWidget = this.fTextViewer.getTextWidget();
        if (textWidget == null) {
            return;
        }
        try {
            int minOffset = this.getTopIndexStartOffset();
            int maxOffset = this.fTextViewer.getBottomIndexEndOffset() + 3;
            Rectangle clientArea = textWidget.getClientArea();
            int width = clientArea.width + textWidget.getHorizontalPixel();
            int lineHeight = textWidget.getLineHeight();
            List<Position> positions = this.fPositions.get((Object)kind);
            if (positions == null || positions.isEmpty()) {
                return;
            }
            for (Position position : positions) {
                int height;
                int widgetOffset;
                if (position.isDeleted() || !position.overlapsWith(minOffset, maxOffset - minOffset + 1) || (widgetOffset = this.getWidgetOffset(position.offset)) < 0 || widgetOffset > textWidget.getCharCount()) continue;
                Point upperLeft = textWidget.getLocationAtOffset(widgetOffset);
                int upperY = Math.max(Math.min(upperLeft.y, clientArea.height), 0);
                if (position.length == 0) {
                    height = lineHeight;
                } else {
                    int widgetEndOffset = Math.min(widgetOffset + position.length, textWidget.getCharCount());
                    Point lowerRight = textWidget.getLocationAtOffset(widgetEndOffset);
                    int lowerY = Math.min(lowerRight.y + lineHeight, clientArea.height);
                    height = lowerY - upperY;
                }
                if (height <= 0) continue;
                textWidget.redraw(0, upperY, width, height, false);
            }
        }
        catch (Exception exception) {}
    }

    private int getTopIndexStartOffset() {
        StyledText textWidget = this.fTextViewer.getTextWidget();
        if (textWidget == null) {
            return -1;
        }
        int top = textWidget.getTopIndex();
        top = textWidget.getOffsetAtLine(Math.min(textWidget.getLineCount() - 1, top));
        if (top >= 0) {
            return this.getDocumentOffset(top);
        }
        return -1;
    }

    public void deactivate(boolean redraw) {
        StyledText textWidget = this.fTextViewer.getTextWidget();
        if (textWidget == null) {
            return;
        }
        textWidget.removeLineBackgroundListener((LineBackgroundListener)this);
        if (redraw) {
            for (LineBackgroundKind kind : this.painterConfig) {
                this.redrawPositions(kind);
            }
        }
        textWidget.removeSelectionListener((SelectionListener)this);
        this.fActive = false;
    }

    public void setPositionManager(IPaintPositionManager manager) {
    }

    private int getWidgetOffset(int documentOffset) {
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fTextViewer;
            return extension.modelOffset2WidgetOffset(documentOffset);
        }
        IRegion visible = this.fTextViewer.getVisibleRegion();
        int widgetOffset = documentOffset - visible.getOffset();
        if (widgetOffset > visible.getLength()) {
            return -1;
        }
        return widgetOffset;
    }

    private int getDocumentOffset(int widgetOffset) {
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fTextViewer;
            return extension.widgetOffset2ModelOffset(widgetOffset);
        }
        IRegion visible = this.fTextViewer.getVisibleRegion();
        if (widgetOffset > visible.getLength()) {
            return -1;
        }
        return widgetOffset + visible.getOffset();
    }

    public void lineGetBackground(LineBackgroundEvent event) {
        StyledText textWidget = this.fTextViewer.getTextWidget();
        if (textWidget == null) {
            return;
        }
        if (event.lineBackground == null || textWidget.getBackground().equals((Object)event.lineBackground)) {
            Position match;
            if (this.computeLineBackground(event, LineBackgroundKind.PVLOG_PREPROC)) {
                return;
            }
            if (this.computeLineBackground(event, LineBackgroundKind.PVLOG_GENERATED)) {
                return;
            }
            if (this.computeLineBackground(event, LineBackgroundKind.INACTIVE)) {
                return;
            }
            if (this.painterConfig.contains((Object)LineBackgroundKind.CUSTOM) && (match = this.findIncludingPosition(this.getDocumentOffset(event.lineOffset), LineBackgroundKind.CUSTOM)) instanceof CustomPragmaPosition && ((CustomPragmaPosition)match).getPragmaName() != null) {
                event.lineBackground = this.fCustomPragmaColors.get(((CustomPragmaPosition)match).getPragmaName());
                return;
            }
            for (LineBackgroundKind kind : this.painterConfig) {
                Position match2 = this.findIncludingPosition(this.getDocumentOffset(event.lineOffset), kind);
                if (match2 == null) continue;
                event.lineBackground = this.fColors.get((Object)kind);
                return;
            }
        }
    }

    private boolean computeLineBackground(LineBackgroundEvent event, LineBackgroundKind kind) {
        if (!this.painterConfig.contains((Object)kind)) {
            return false;
        }
        Position match = this.findIncludingPosition(this.getDocumentOffset(event.lineOffset), kind);
        if (match == null) {
            return false;
        }
        event.lineBackground = this.fColors.get((Object)kind);
        return true;
    }

    private Position findIncludingPosition(int offset, LineBackgroundKind kind) {
        List<Position> positions = this.fPositions.get((Object)kind);
        if (positions == null || positions.isEmpty()) {
            return null;
        }
        Position potentialPosition = null;
        for (Position position : positions) {
            if (position.offset == offset || position.includes(offset)) {
                potentialPosition = position;
                continue;
            }
            if (potentialPosition == null || potentialPosition.offset + potentialPosition.length >= offset) continue;
            return potentialPosition;
        }
        return potentialPosition;
    }

    public void propertyChange(PropertyChangeEvent event) {
        LineBackgroundKind[] lineBackgroundKindArray = LineBackgroundKind.values();
        int n = lineBackgroundKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            LineBackgroundKind kind = lineBackgroundKindArray[n2];
            if (event.getProperty().equals(kind.COLOR_PREF_KEY)) {
                this.setColorFromPrefStore(kind);
                if (!this.isEnabledInPrefStore(kind)) break;
                this.redrawPositions(kind);
                break;
            }
            if (event.getProperty().equals(kind.ENABLE_PREF_KEY)) {
                if (this.isEnabledInPrefStore(kind)) {
                    this.painterConfig.add(kind);
                    this.activate();
                    break;
                }
                this.painterConfig.remove((Object)kind);
                if (this.painterConfig.isEmpty()) {
                    this.deactivate(true);
                    break;
                }
                this.activate();
                break;
            }
            ++n2;
        }
    }

    private void setEnablementFromPrefStore() {
        if (this.fPreferenceStore == null) {
            return;
        }
        this.painterConfig = EnumSet.noneOf(LineBackgroundKind.class);
        LineBackgroundKind[] lineBackgroundKindArray = LineBackgroundKind.values();
        int n = lineBackgroundKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            LineBackgroundKind kind = lineBackgroundKindArray[n2];
            if (this.isEnabledInPrefStore(kind)) {
                this.painterConfig.add(kind);
            }
            ++n2;
        }
        if (!this.painterConfig.isEmpty()) {
            this.activate();
        }
    }

    private void setColorFromPrefStore(LineBackgroundKind kind) {
        if (this.fPreferenceStore == null) {
            return;
        }
        RGB highlightColor = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)kind.COLOR_PREF_KEY);
        this.fColors.put(kind, DVTColorUtil.INSTANCE.getColor(highlightColor));
    }

    private boolean isEnabledInPrefStore(LineBackgroundKind kind) {
        if (this.fPreferenceStore == null) {
            return false;
        }
        return this.fPreferenceStore.getBoolean(kind.ENABLE_PREF_KEY);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        StyledText textWidget = this.fTextViewer.getTextWidget();
        if (textWidget == null) {
            return;
        }
        textWidget.removeLineBackgroundListener((LineBackgroundListener)this);
        textWidget.addLineBackgroundListener((LineBackgroundListener)this);
    }

    public Color testGetLineColor(int offset) {
        for (LineBackgroundKind kind : this.painterConfig) {
            Position match = this.findIncludingPosition(this.getDocumentOffset(offset), kind);
            if (match == null) continue;
            if (match instanceof CustomPragmaPosition) {
                return this.fCustomPragmaColors.get(((CustomPragmaPosition)match).getPragmaName());
            }
            return this.fColors.get((Object)kind);
        }
        return null;
    }

    @Override
    public void updateCustomPragmas(IProject project) {
        if (project == null) {
            return;
        }
        List<CustomPragma> customPragmas = BuildConfigManager.getCustomPragmas(project);
        if (customPragmas == null) {
            return;
        }
        this.fCustomPragmaColors.clear();
        if (customPragmas.isEmpty()) {
            this.painterConfig.remove((Object)LineBackgroundKind.CUSTOM);
        } else {
            this.painterConfig.add(LineBackgroundKind.CUSTOM);
        }
        Display.getDefault().asyncExec(() -> {
            if (this.painterConfig == null) {
                return;
            }
            if (this.painterConfig.isEmpty()) {
                this.deactivate(true);
            } else {
                this.activate();
            }
        });
        for (CustomPragma customPragma : customPragmas) {
            if (!customPragma.isEnabled() || customPragma.isOverriden() || !customPragma.isColorEnabled()) continue;
            this.fCustomPragmaColors.put(customPragma.getName(), customPragma.getColor());
        }
    }

    public static enum LineBackgroundKind {
        INACTIVE("inactiveCodeHighlightEnable", "inactiveCodeHighlightColor"),
        PROTECTED("protectedCodeHighlightEnable", "protectedCodeHighlightColor"),
        INSPECT_FILE_INFO("inspect.file_info_enable", "inspect.file_info_color"),
        INSPECT_INTEREST("inspect.context_enable", "inspect.context_color"),
        INACTIVE_GENERATE_BRANCH("inactiveGenerateBranchHighlightEnable", "inactiveGenerateBranchHighlightColor"),
        PVLOG_PREPROC("pvlogPreprocCodeHighlightEnable", "pvlogPreprocCodeHighlightColor"),
        PVLOG_GENERATED("pvlogGeneratedCodeHighlightEnable", "pvlogGeneratedCodeHighlightColor"),
        CUSTOM("", "");

        private String ENABLE_PREF_KEY;
        private String COLOR_PREF_KEY;

        private LineBackgroundKind(String enablementPrefKey, String colorPrefKey) {
            this.ENABLE_PREF_KEY = enablementPrefKey;
            this.COLOR_PREF_KEY = colorPrefKey;
        }
    }
}

