/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.DVTEditorAssociationOverride;

public class MissingPrecompiledFileEditor
extends EditorPart {
    public static final String ID = "ro.amiq.dvt.ui.editor.MissingPrecompiledFileEditor";
    private Composite controlParent;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        super.setPartName(input.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.controlParent = new Composite(parent, 0);
        this.controlParent.setLayout((Layout)new GridLayout());
        DVTUiUtils.setPlatformEditorColors((Control)this.controlParent);
        Label topSpacer = new Label(this.controlParent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)topSpacer);
        Composite contentComposite = new Composite(this.controlParent, 0);
        contentComposite.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(0x1000000, 1).grab(true, true).applyTo((Control)contentComposite);
        Label firstBottomSpacer = new Label(this.controlParent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)firstBottomSpacer);
        Label secondBottomSpacer = new Label(this.controlParent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)secondBottomSpacer);
        Label missingPrecompiledFileTitle = new Label(contentComposite, 0);
        missingPrecompiledFileTitle.setText("This precompiled file was moved or deleted.");
        missingPrecompiledFileTitle.setFont(DVTUiUtils.getDoubleFont());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)missingPrecompiledFileTitle);
        Link missingFileText = new Link(contentComposite, 0);
        missingFileText.setText("If the file comes from an external library, use the +dvt_precompiled_db_src_map directive to map the missing file to a locally stored one.");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)missingFileText);
        this.controlParent.setFocus();
    }

    public void setFocus() {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench == null) {
                return;
            }
            IWorkbenchPage activePage = workbench.getActiveWorkbenchWindow().getActivePage();
            if (activePage == null) {
                return;
            }
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput == null) {
                return;
            }
            IFile file = (IFile)editorInput.getAdapter(IFile.class);
            if (file == null) {
                return;
            }
            if (PrecompiledDBUtils.isPrecompiledFile(file.getProject(), file.getLocationURI().getPath()) && new File(file.getLocationURI().getPath()).exists()) {
                activePage.closeEditor((IEditorPart)this, false);
                IEditorDescriptor editorDescriptor = IDE.getEditorDescriptor((String)((FileEditorInput)this.getEditorInput()).getFile().getName());
                activePage.openEditor(editorInput, DVTEditorAssociationOverride.getEditorDescriptor(((FileEditorInput)editorInput).getFile(), editorDescriptor).getId());
                return;
            }
        }
        catch (PartInitException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

