/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.DVTPFParsedFiles;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.BuildConfigHyperlinkDetector;
import ro.amiq.dvt.utils.DVTFileUtils;

public class PfHyperlinkDetector
extends BuildConfigHyperlinkDetector {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        LinkedList<IHyperlink> result = new LinkedList<IHyperlink>();
        try {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            IDocument document = textViewer.getDocument();
            ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(document);
            if (textFileBuffer == null) {
                return null;
            }
            IPath location = textFileBuffer.getLocation();
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(location);
            if (!file.exists()) {
                return null;
            }
            location = file.getLocation();
            String sessionProperty = PropertiesManager.getSessionProperty((IResource)file, PropertyTypes.QN_IMPORTED_FILE);
            if (sessionProperty == null || !"ro.amiq.dvt.tcl.ui.editor.DVTTclEditor".equals(sessionProperty)) {
                return null;
            }
            IProject[] projects = null;
            projects = file.exists() && file.getProject() != null && file.getProject().isAccessible() ? new IProject[]{file.getProject()} : ResourcesPlugin.getWorkspace().getRoot().getProjects();
            HashSet<String> uniquePaths = new HashSet<String>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                RfMixedLangProject mixedLangProject;
                IProject project = iProjectArray[n2];
                if (project.isAccessible() && (mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false)) != null) {
                    DVTPFModel pfModel = mixedLangProject.getPFModel();
                    if (pfModel == null) {
                        return null;
                    }
                    List<DVTPFParsedFiles> allPfFiles = pfModel.getAllParsedPfFiles();
                    if (allPfFiles == null) {
                        return null;
                    }
                    for (DVTPFParsedFiles pfInclude : allPfFiles) {
                        IFile iFile;
                        String cannonicPath;
                        Region upfFileRegion;
                        String including = pfInclude.including;
                        if (including == null || !(including = new File(including).getCanonicalPath()).equals(file.getLocation().toOSString()) || (upfFileRegion = new Region(pfInclude.offset, pfInclude.includeCommand.length())).getOffset() > region.getOffset() || upfFileRegion.getOffset() + upfFileRegion.getLength() < region.getOffset() || (cannonicPath = (iFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, pfInclude.included)) != null && iFile.getLocation() != null ? iFile.getLocation().toFile().getCanonicalPath() : new File(pfInclude.included).getCanonicalPath()) == null || uniquePaths.contains(cannonicPath)) continue;
                        uniquePaths.add(cannonicPath);
                        IHyperlink hyperlink = this.getHyperlink(upfFileRegion, pfInclude.included, project);
                        if (hyperlink == null) continue;
                        result.add(hyperlink);
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() == 1) {
            return new IHyperlink[]{(IHyperlink)result.get(0)};
        }
        return new IHyperlink[]{this.getDummyHyperlinkForMultipleTargets(result)};
    }

    private IHyperlink getHyperlink(final Region region, final String included, final IProject project) {
        return new IHyperlink(){

            public void open() {
                IFile iFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, included);
                if (iFile != null) {
                    DVTFileUtils.getInstance().openEditor(iFile, 0, null);
                } else {
                    DVTFileUtils.getInstance().openEditor(new File(included), 0);
                }
            }

            public String getTypeLabel() {
                return null;
            }

            public String getHyperlinkText() {
                return included;
            }

            public IRegion getHyperlinkRegion() {
                return new Region(region.getOffset(), region.getLength());
            }
        };
    }
}

