/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentPartitioningChangedEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.IDocumentPartitioningListenerExtension;
import org.eclipse.jface.text.IDocumentPartitioningListenerExtension2;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TypedPosition;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.PresentationReconcilerCommon;

public class PresentationReconciler
extends PresentationReconcilerCommon {
    private InternalListener fInternalListener = new InternalListener();
    protected ITextViewer fViewer;

    public void install(ITextViewer viewer) {
        Assert.isNotNull((Object)viewer);
        this.fViewer = viewer;
        this.fViewer.addTextInputListener((ITextInputListener)this.fInternalListener);
        IDocument document = viewer.getDocument();
        if (document != null) {
            this.fInternalListener.inputDocumentChanged(null, document);
        }
    }

    public void uninstall() {
        this.fViewer.removeTextInputListener((ITextInputListener)this.fInternalListener);
        this.fInternalListener.inputDocumentAboutToBeChanged(this.fViewer.getDocument(), null);
    }

    @Override
    public void processDamage(IRegion damage, IDocument document) {
        TextPresentation p;
        if (damage != null && damage.getLength() > 0 && (p = this.createPresentation(damage, document)) != null) {
            this.applyTextRegionCollection(p);
        }
    }

    @Override
    protected void applyTextRegionCollection(TextPresentation presentation) {
        this.fViewer.changeTextPresentation(presentation, false);
    }

    class InternalListener
    implements ITextInputListener,
    IDocumentListener,
    ITextListener,
    IDocumentPartitioningListener,
    IDocumentPartitioningListenerExtension,
    IDocumentPartitioningListenerExtension2 {
        private boolean fDocumentChanging = false;
        private boolean fCachedRedrawState = true;

        InternalListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldDocument, IDocument newDocument) {
            if (oldDocument != null) {
                try {
                    PresentationReconciler.this.fViewer.removeTextListener((ITextListener)this);
                    oldDocument.removeDocumentListener((IDocumentListener)this);
                    oldDocument.removeDocumentPartitioningListener((IDocumentPartitioningListener)this);
                    oldDocument.removePositionUpdater(PresentationReconciler.this.fPositionUpdater);
                    oldDocument.removePositionCategory(PresentationReconciler.this.fPositionCategory);
                }
                catch (BadPositionCategoryException x) {
                    DVTLogger.INSTANCE.logError((Throwable)x);
                }
            }
        }

        public void inputDocumentChanged(IDocument oldDocument, IDocument newDocument) {
            this.fDocumentChanging = false;
            this.fCachedRedrawState = true;
            if (newDocument != null) {
                newDocument.addPositionCategory(PresentationReconciler.this.fPositionCategory);
                newDocument.addPositionUpdater(PresentationReconciler.this.fPositionUpdater);
                newDocument.addDocumentPartitioningListener((IDocumentPartitioningListener)this);
                newDocument.addDocumentListener((IDocumentListener)this);
                PresentationReconciler.this.fViewer.addTextListener((ITextListener)this);
                PresentationReconciler.this.setDocumentToDamagers(newDocument);
                PresentationReconciler.this.setDocumentToRepairers(newDocument);
                PresentationReconciler.this.processDamage((IRegion)new Region(0, TestHelper.isTestMode() ? newDocument.getLength() : 0), newDocument);
            }
        }

        public void documentPartitioningChanged(IDocument document) {
            if (!this.fDocumentChanging && this.fCachedRedrawState) {
                PresentationReconciler.this.processDamage((IRegion)new Region(0, document.getLength()), document);
            } else {
                PresentationReconciler.this.fDocumentPartitioningChanged = true;
            }
        }

        public void documentPartitioningChanged(IDocument document, IRegion changedRegion) {
            if (!this.fDocumentChanging && this.fCachedRedrawState) {
                PresentationReconciler.this.processDamage((IRegion)new Region(changedRegion.getOffset(), changedRegion.getLength()), document);
            } else {
                PresentationReconciler.this.fDocumentPartitioningChanged = true;
                PresentationReconciler.this.fChangedDocumentPartitions = changedRegion;
            }
        }

        public void documentPartitioningChanged(DocumentPartitioningChangedEvent event) {
            IRegion changedRegion = event.getChangedRegion(PresentationReconciler.this.getDocumentPartitioning());
            if (changedRegion != null) {
                this.documentPartitioningChanged(event.getDocument(), changedRegion);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
            this.fDocumentChanging = true;
            if (this.fCachedRedrawState) {
                try {
                    int offset = e.getOffset() + e.getLength();
                    ITypedRegion region = PresentationReconciler.this.getPartition(e.getDocument(), offset);
                    PresentationReconciler.this.fRememberedPosition = new TypedPosition(region);
                    e.getDocument().addPosition(PresentationReconciler.this.fPositionCategory, (Position)PresentationReconciler.this.fRememberedPosition);
                }
                catch (BadLocationException | BadPositionCategoryException x) {
                    DVTLogger.INSTANCE.logError(x);
                }
            }
        }

        public void documentChanged(DocumentEvent e) {
            if (this.fCachedRedrawState) {
                try {
                    e.getDocument().removePosition(PresentationReconciler.this.fPositionCategory, (Position)PresentationReconciler.this.fRememberedPosition);
                }
                catch (BadPositionCategoryException x) {
                    DVTLogger.INSTANCE.logError((Throwable)x);
                }
            }
            this.fDocumentChanging = false;
        }

        public void textChanged(TextEvent e) {
            this.fCachedRedrawState = e.getViewerRedrawState();
            if (!this.fCachedRedrawState) {
                return;
            }
            IRegion damage = null;
            IDocument document = null;
            if (e.getDocumentEvent() == null) {
                document = PresentationReconciler.this.fViewer.getDocument();
                if (document != null) {
                    if (e.getOffset() == 0 && e.getLength() == 0 && e.getText() == null) {
                        damage = new Region(0, document.getLength());
                    } else {
                        IRegion region = this.widgetRegion2ModelRegion(e);
                        if (region != null) {
                            try {
                                String text = document.get(region.getOffset(), region.getLength());
                                DocumentEvent de = new DocumentEvent(document, region.getOffset(), region.getLength(), text);
                                damage = PresentationReconciler.this.getDamage(de, false);
                            }
                            catch (BadLocationException x) {
                                DVTLogger.INSTANCE.logError((Throwable)x);
                            }
                        }
                    }
                }
            } else {
                DocumentEvent de = e.getDocumentEvent();
                document = de.getDocument();
                damage = PresentationReconciler.this.getDamage(de, true);
            }
            if (damage != null && document != null) {
                PresentationReconciler.this.processDamage(damage, document);
            }
            PresentationReconciler.this.fDocumentPartitioningChanged = false;
            PresentationReconciler.this.fChangedDocumentPartitions = null;
        }

        protected IRegion widgetRegion2ModelRegion(TextEvent e) {
            int length;
            String text = e.getText();
            int n = length = text == null ? 0 : text.length();
            if (PresentationReconciler.this.fViewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)PresentationReconciler.this.fViewer;
                return extension.widgetRange2ModelRange((IRegion)new Region(e.getOffset(), length));
            }
            IRegion visible = PresentationReconciler.this.fViewer.getVisibleRegion();
            Region region = new Region(e.getOffset() + visible.getOffset(), length);
            return region;
        }
    }
}

