/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationReconcilerExtension;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.swt.custom.StyleRange;
import ro.amiq.dvt.startup.core.DVTLogger;

public abstract class PresentationReconcilerCommon
implements IPresentationReconciler,
IPresentationReconcilerExtension {
    protected static final String TRACKED_PARTITION = "__reconciler_tracked_partition";
    protected Map<String, IPresentationDamager> fDamagers;
    protected Map<String, IPresentationRepairer> fRepairers;
    protected String fPositionCategory = "__reconciler_tracked_partition" + this.hashCode();
    protected IPositionUpdater fPositionUpdater = new DefaultPositionUpdater(this.fPositionCategory);
    protected TypedPosition fRememberedPosition;
    protected boolean fDocumentPartitioningChanged = false;
    protected IRegion fChangedDocumentPartitions = null;
    protected String fPartitioning = "__dftl_partitioning";

    public void setDocumentPartitioning(String partitioning) {
        Assert.isNotNull((Object)partitioning);
        this.fPartitioning = partitioning;
    }

    public String getDocumentPartitioning() {
        return this.fPartitioning;
    }

    public void setDamager(IPresentationDamager damager, String contentType) {
        Assert.isNotNull((Object)contentType);
        if (this.fDamagers == null) {
            this.fDamagers = new HashMap<String, IPresentationDamager>();
        }
        if (damager == null) {
            this.fDamagers.remove(contentType);
        } else {
            this.fDamagers.put(contentType, damager);
        }
    }

    public void setRepairer(IPresentationRepairer repairer, String contentType) {
        Assert.isNotNull((Object)contentType);
        if (this.fRepairers == null) {
            this.fRepairers = new HashMap<String, IPresentationRepairer>();
        }
        if (repairer == null) {
            this.fRepairers.remove(contentType);
        } else {
            this.fRepairers.put(contentType, repairer);
        }
    }

    public IPresentationDamager getDamager(String contentType) {
        if (this.fDamagers == null) {
            return null;
        }
        return this.fDamagers.get(contentType);
    }

    public IPresentationRepairer getRepairer(String contentType) {
        if (this.fRepairers == null) {
            return null;
        }
        return this.fRepairers.get(contentType);
    }

    public void setDocumentToDamagers(IDocument document) {
        if (this.fDamagers != null) {
            for (IPresentationDamager damager : this.fDamagers.values()) {
                damager.setDocument(document);
            }
        }
    }

    public void setDocumentToRepairers(IDocument document) {
        if (this.fRepairers != null) {
            for (IPresentationRepairer repairer : this.fRepairers.values()) {
                repairer.setDocument(document);
            }
        }
    }

    protected IRegion getDamage(DocumentEvent e, boolean optimize) {
        ITypedRegion partition;
        IPresentationDamager damager;
        IRegion damage;
        boolean isDeletion;
        block8: {
            int length;
            int n = length = e.getText() == null ? 0 : e.getText().length();
            if (this.fDamagers == null || this.fDamagers.isEmpty()) {
                length = Math.max(e.getLength(), length);
                length = Math.min(e.getDocument().getLength() - e.getOffset(), length);
                return new Region(e.getOffset(), length);
            }
            isDeletion = length == 0;
            damage = null;
            int offset = e.getOffset();
            if (isDeletion) {
                offset = Math.max(0, offset - 1);
            }
            if ((damager = this.getDamager((partition = this.getPartition(e.getDocument(), offset)).getType())) != null) break block8;
            return null;
        }
        try {
            IRegion r = damager.getDamageRegion(partition, e, this.fDocumentPartitioningChanged);
            if (!this.fDocumentPartitioningChanged && optimize && !isDeletion) {
                damage = r;
            } else {
                int damageStart = r.getOffset();
                int damageEnd = this.getDamageEndOffset(e);
                if (this.fChangedDocumentPartitions != null) {
                    damageStart = Math.min(damageStart, this.fChangedDocumentPartitions.getOffset());
                    damageEnd = Math.max(damageEnd, this.fChangedDocumentPartitions.getOffset() + this.fChangedDocumentPartitions.getLength());
                }
                damage = damageEnd == -1 ? r : new Region(damageStart, damageEnd - damageStart);
            }
        }
        catch (BadLocationException x) {
            DVTLogger.INSTANCE.logError((Throwable)x);
        }
        return damage;
    }

    protected int getDamageEndOffset(DocumentEvent e) throws BadLocationException {
        IPresentationDamager damager;
        int end;
        ITypedRegion partition;
        int endOffset;
        IDocument d = e.getDocument();
        int length = 0;
        if (e.getText() != null && (length = e.getText().length()) > 0) {
            --length;
        }
        if ((endOffset = (partition = this.getPartition(d, e.getOffset() + length)).getOffset() + partition.getLength()) == e.getOffset()) {
            return -1;
        }
        int n = end = this.fRememberedPosition == null ? -1 : this.fRememberedPosition.getOffset() + this.fRememberedPosition.getLength();
        if (endOffset < end && end < d.getLength()) {
            partition = this.getPartition(d, end);
        }
        if ((damager = this.getDamager(partition.getType())) == null) {
            return -1;
        }
        IRegion r = damager.getDamageRegion(partition, e, this.fDocumentPartitioningChanged);
        return r.getOffset() + r.getLength();
    }

    protected ITypedRegion getPartition(IDocument document, int offset) throws BadLocationException {
        return TextUtilities.getPartition((IDocument)document, (String)this.getDocumentPartitioning(), (int)offset, (boolean)false);
    }

    protected TextPresentation createPresentation(IRegion damage, IDocument document) {
        try {
            ITypedRegion[] partitioning;
            if (this.fRepairers == null || this.fRepairers.isEmpty()) {
                TextPresentation presentation = new TextPresentation(damage, 100);
                presentation.setDefaultStyleRange(new StyleRange(damage.getOffset(), damage.getLength(), null, null));
                return presentation;
            }
            TextPresentation presentation = new TextPresentation(damage, 1000);
            ITypedRegion[] iTypedRegionArray = partitioning = TextUtilities.computePartitioning((IDocument)document, (String)this.getDocumentPartitioning(), (int)damage.getOffset(), (int)damage.getLength(), (boolean)false);
            int n = partitioning.length;
            int n2 = 0;
            while (n2 < n) {
                ITypedRegion r = iTypedRegionArray[n2];
                IPresentationRepairer repairer = this.getRepairer(r.getType());
                if (repairer != null) {
                    repairer.createPresentation(presentation, r);
                }
                ++n2;
            }
            return presentation;
        }
        catch (BadLocationException x) {
            DVTLogger.INSTANCE.logError((Throwable)x);
            return null;
        }
    }

    protected abstract void applyTextRegionCollection(TextPresentation var1);

    protected abstract void processDamage(IRegion var1, IDocument var2);
}

