/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.ui.refactoring.IStatusContextViewer;
import org.eclipse.ltk.ui.refactoring.TextStatusContextViewer;
import org.eclipse.swt.widgets.Composite;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTFileStatusContext;
import ro.amiq.dvt.ui.editor.FileRegionPair;
import ro.amiq.dvt.ui.preferences.DVTPreviewSourceViewer;

public class RenameFileStatusContextViewer
extends TextStatusContextViewer
implements IStatusContextViewer {
    private DVTPreviewSourceViewer fSourceViewer;

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    public void setInput(RefactoringStatusContext context) {
        if (!(context instanceof DVTFileStatusContext)) {
            return;
        }
        DVTFileStatusContext dvtFileContext = (DVTFileStatusContext)context;
        List<FileRegionPair> highlightedFileRegions = dvtFileContext.getFileRegions();
        if (highlightedFileRegions == null || highlightedFileRegions.isEmpty()) {
            return;
        }
        this.fSourceViewer.unconfigure();
        IFile file = highlightedFileRegions.get(0).getFile();
        IDocument document = this.getDocument(file);
        this.fSourceViewer.configure((SourceViewerConfiguration)dvtFileContext.getSourceViewerConfiguration());
        this.fSourceViewer.setDocument(document);
        this.fSourceViewer.setInput(document);
        dvtFileContext.getDocumentSetupParticipant().setup(this.fSourceViewer.getDocument());
        this.updateTitle((IAdaptable)file);
        for (FileRegionPair fileRegionPair : highlightedFileRegions) {
            IRegion region = fileRegionPair.getRegion();
            if (region != null && document.getLength() >= region.getOffset() + region.getLength()) {
                this.setInput(document, region);
                continue;
            }
            this.setInput(document, (IRegion)new Region(0, 0));
        }
    }

    protected SourceViewer createSourceViewer(Composite parent) {
        this.fSourceViewer = new DVTPreviewSourceViewer(parent, 66306);
        this.fSourceViewer.setPreferenceStore(DVTPlugin.getDefault().getCombinedPreferenceStore());
        return this.fSourceViewer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IDocument getDocument(IFile file) {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = file.getFullPath();
        try {
            try {
                manager.connect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.IFILE);
                if (buffer == null) return new Document("Error reading " + path.toOSString());
                IDocument iDocument = buffer.getDocument();
                return iDocument;
            }
            finally {
                manager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new Document("Error reading " + path.toOSString());
    }
}

