/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.texteditor.TextEditorPlugin;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.ResourceAction;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;

public class SelectAndFindNextAction
extends ResourceAction
implements IUpdate {
    private IFindReplaceTarget fTarget;
    private IWorkbenchPart fWorkbenchPart;
    private IWorkbenchWindow fWorkbenchWindow;
    private IDialogSettings fDialogSettings;
    private List fFindHistory = new ArrayList();
    private String fFindString;
    private boolean fForward;
    private boolean fWrapInit;
    private boolean fCaseInit;
    private boolean fWholeWordInit;
    private boolean fRegExSearch;
    private String fSelection;
    private DVTEditor fDVTEditor;

    public SelectAndFindNextAction(DVTEditor dvtEditor, ResourceBundle bundle, String prefix, IWorkbenchPart workbenchPart, boolean forward) {
        super(bundle, prefix);
        this.fWorkbenchPart = workbenchPart;
        this.fForward = forward;
        this.update();
        this.fDVTEditor = dvtEditor;
    }

    public SelectAndFindNextAction(ResourceBundle bundle, String prefix, IWorkbenchWindow workbenchWindow, boolean forward) {
        super(bundle, prefix);
        this.fWorkbenchWindow = workbenchWindow;
        this.fForward = forward;
        this.update();
    }

    private IStatusLineManager getStatusLineManager() {
        IEditorPart editor = this.fWorkbenchPart.getSite().getPage().getActiveEditor();
        if (editor == null) {
            return null;
        }
        return editor.getEditorSite().getActionBars().getStatusLineManager();
    }

    private void statusNotFound() {
        this.fWorkbenchPart.getSite().getShell().getDisplay().beep();
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager == null) {
            return;
        }
        manager.setMessage("String Not Found");
    }

    private void statusClear() {
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager == null) {
            return;
        }
        manager.setErrorMessage("");
        manager.setMessage("");
    }

    public void run() {
        if (this.fTarget != null) {
            this.readConfiguration();
            this.fFindString = this.fTarget.getSelectionText();
            if (this.fFindString == null || this.fFindString.isEmpty()) {
                IDocumentProvider documentProvider = this.fDVTEditor.getDocumentProvider();
                if (documentProvider != null) {
                    IDocument document = documentProvider.getDocument((Object)this.fDVTEditor.getEditorInput());
                    int offset = this.fDVTEditor.getCursor();
                    IRegion word = this.fDVTEditor.getWordFinder().getWordAtOffset(document, offset);
                    try {
                        this.fFindString = documentProvider.getDocument((Object)this.fDVTEditor.getEditorInput()).get(word.getOffset(), word.getLength());
                    }
                    catch (BadLocationException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
                if (this.fFindString == null || this.fFindString.isEmpty()) {
                    this.statusNotFound();
                    return;
                }
            }
            boolean wholeWord = this.fWholeWordInit && !this.fRegExSearch && this.isWord(this.fFindString);
            this.statusClear();
            if (!this.findNext(this.fFindString, this.fForward, this.fCaseInit, this.fWrapInit, wholeWord, this.fRegExSearch)) {
                this.statusNotFound();
            }
            this.writeConfiguration();
        }
    }

    private boolean isWord(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < str.length()) {
            if (!Character.isJavaIdentifierPart(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void update() {
        if (this.fWorkbenchPart == null && this.fWorkbenchWindow != null) {
            this.fWorkbenchPart = this.fWorkbenchWindow.getPartService().getActivePart();
        }
        this.fTarget = this.fWorkbenchPart != null ? (IFindReplaceTarget)this.fWorkbenchPart.getAdapter(IFindReplaceTarget.class) : null;
        this.setEnabled(this.fTarget != null && this.fTarget.canPerformFind());
    }

    private int findIndex(String findString, int startPosition, boolean forwardSearch, boolean caseSensitive, boolean wrapSearch, boolean wholeWord, boolean regExSearch) {
        if (forwardSearch) {
            if (wrapSearch) {
                int index = this.findAndSelect(startPosition, findString, true, caseSensitive, wholeWord, regExSearch);
                if (index == -1) {
                    this.beep();
                    index = this.findAndSelect(-1, findString, true, caseSensitive, wholeWord, regExSearch);
                }
                return index;
            }
            return this.findAndSelect(startPosition, findString, true, caseSensitive, wholeWord, regExSearch);
        }
        if (wrapSearch) {
            int index = this.findAndSelect(startPosition - 1, findString, false, caseSensitive, wholeWord, regExSearch);
            if (index == -1) {
                this.beep();
                index = this.findAndSelect(-1, findString, false, caseSensitive, wholeWord, regExSearch);
            }
            return index;
        }
        return this.findAndSelect(startPosition - 1, findString, false, caseSensitive, wholeWord, regExSearch);
    }

    private boolean findNext(String findString, boolean forwardSearch, boolean caseSensitive, boolean wrapSearch, boolean wholeWord, boolean regExSearch) {
        int index;
        Point r = this.fTarget.getSelection();
        int findReplacePosition = r.x;
        if (forwardSearch) {
            findReplacePosition += r.y;
        }
        return (index = this.findIndex(findString, findReplacePosition, forwardSearch, caseSensitive, wrapSearch, wholeWord, regExSearch)) != -1;
    }

    private void beep() {
        Shell shell = null;
        if (this.fWorkbenchPart != null) {
            shell = this.fWorkbenchPart.getSite().getShell();
        } else if (this.fWorkbenchWindow != null) {
            shell = this.fWorkbenchWindow.getShell();
        }
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().beep();
        }
    }

    private int findAndSelect(int offset, String findString, boolean forwardSearch, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
        if (this.fTarget instanceof IFindReplaceTargetExtension3) {
            try {
                return ((IFindReplaceTargetExtension3)this.fTarget).findAndSelect(offset, findString, forwardSearch, caseSensitive, wholeWord, regExSearch);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return -1;
            }
        }
        return this.fTarget.findAndSelect(offset, findString, forwardSearch, caseSensitive, wholeWord);
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = TextEditorPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection("org.eclipse.ui.texteditor.FindReplaceDialog");
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection("org.eclipse.ui.texteditor.FindReplaceDialog");
        }
        return this.fDialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        this.fWrapInit = s.get("wrap") == null || s.getBoolean("wrap");
        this.fCaseInit = s.getBoolean("casesensitive");
        this.fWholeWordInit = s.getBoolean("wholeword");
        this.fRegExSearch = s.getBoolean("isRegEx");
        this.fSelection = s.get("selection");
        String[] findHistory = s.getArray("findhistory");
        if (findHistory != null) {
            this.fFindHistory.clear();
            int i = 0;
            while (i < findHistory.length) {
                this.fFindHistory.add(findHistory[i]);
                ++i;
            }
        }
    }

    private void writeConfiguration() {
        if (this.fFindString == null) {
            return;
        }
        IDialogSettings s = this.getDialogSettings();
        s.put("selection", this.fTarget.getSelectionText());
        if (!this.fFindHistory.isEmpty() && this.fFindString.equals(this.fFindHistory.get(0))) {
            return;
        }
        int index = this.fFindHistory.indexOf(this.fFindString);
        if (index != -1) {
            this.fFindHistory.remove(index);
        }
        this.fFindHistory.add(0, this.fFindString);
        while (this.fFindHistory.size() > 8) {
            this.fFindHistory.remove(8);
        }
        String[] names = new String[this.fFindHistory.size()];
        this.fFindHistory.toArray(names);
        s.put("findhistory", names);
    }

    private String getFirstLine(String selection) {
        if (selection.length() > 0) {
            int[] info = TextUtilities.indexOf((String[])TextUtilities.DELIMITERS, (String)selection, (int)0);
            if (info[0] > 0) {
                return selection.substring(0, info[0]);
            }
            if (info[0] == -1) {
                return selection;
            }
        }
        return selection;
    }
}

