/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.util.ArrayDeque;
import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.BracketDetails;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;

public abstract class SelectEnclosingElementCommon
extends TextEditorAction {
    protected SelectEnclosingElementCommon(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    private EnclosingElementRange selectWholeFile(IRegion cursorLine, IDocument document, Point initialSelection) {
        Position[] foldPositions;
        if (initialSelection.y != cursorLine.getLength()) {
            return null;
        }
        if (this.getCursorLineNumber() != document.getNumberOfLines() && this.getCursorLineNumber() != 1) {
            return null;
        }
        Position[] positionArray = foldPositions = this.getFoldingPositions();
        int n = foldPositions.length;
        int n2 = 0;
        while (n2 < n) {
            Position position = positionArray[n2];
            if (position.getOffset() == 0 && position.getLength() == document.getLength()) {
                return new EnclosingElementRange(0, position.getLength());
            }
            ++n2;
        }
        return null;
    }

    private EnclosingElementRange selectLiteral(IDocument document, Point selection) {
        String literalType;
        String partitioning;
        block9: {
            String endContentType;
            String startContentType;
            block8: {
                int selectionLength;
                block7: {
                    partitioning = DVTFileUtils.getInstance().getPartitioning((IDocumentExtension3)document);
                    String string = "__vlog_partitioning".equals(partitioning) ? "__vlog_literal" : ("__vhdl_partitioning".contains(partitioning) ? "__vhdl_literal" : ("__e_partitioning".equals(partitioning) ? "__e_string" : ("__pss_partitioning".equals(partitioning) ? "__pss_literal" : (literalType = "__msdl_partitioning".equals(partitioning) ? "__msdl_literal" : null))));
                    if (literalType != null) break block7;
                    return null;
                }
                int selectionOffset = selection.x;
                if (selectionOffset != 0) {
                    --selectionOffset;
                }
                if (selectionOffset + (selectionLength = selection.y) < document.getLength()) {
                    ++selectionLength;
                }
                startContentType = ((IDocumentExtension3)document).getContentType(partitioning, selectionOffset, false);
                endContentType = ((IDocumentExtension3)document).getContentType(partitioning, selectionOffset + selectionLength, false);
                if (startContentType != null && endContentType != null) break block8;
                return null;
            }
            if (startContentType.equals(literalType) || endContentType.equals(literalType)) break block9;
            return null;
        }
        try {
            return this.selectLiteralByLanguage(document, partitioning, literalType);
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EnclosingElementRange selectLiteralByLanguage(IDocument document, String partitioning, String literalType) {
        try {
            String contentType;
            int forwardCursor = this.getCursor();
            int backwardCursor = this.getCursor() - 1;
            while (forwardCursor <= document.getLength()) {
                contentType = ((IDocumentExtension3)document).getContentType(partitioning, forwardCursor, false);
                if (contentType == null) {
                    return null;
                }
                if (!contentType.equals(literalType)) break;
                ++forwardCursor;
            }
            while (backwardCursor >= 0) {
                contentType = ((IDocumentExtension3)document).getContentType(partitioning, backwardCursor, false);
                if (contentType == null) {
                    return null;
                }
                if (!contentType.equals(literalType)) break;
                --backwardCursor;
            }
            if (forwardCursor - backwardCursor == 1) {
                return null;
            }
            return new EnclosingElementRange(backwardCursor + 1, forwardCursor - backwardCursor - 1);
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
            return null;
        }
    }

    private EnclosingElementRange selectAnnotation(Point initialSelection, IRegion cursorLine) {
        Position[] foldPositions = null;
        foldPositions = this.getFoldingPositions();
        if (foldPositions == null) {
            return null;
        }
        Position targetPosition = null;
        Position[] positionArray = foldPositions;
        int n = foldPositions.length;
        int n2 = 0;
        while (n2 < n) {
            Position position = positionArray[n2];
            if (initialSelection.y == cursorLine.getLength() && position.getOffset() == initialSelection.x && position.getLength() > initialSelection.y) {
                targetPosition = position;
                break;
            }
            if (position.getOffset() < initialSelection.x && initialSelection.x + initialSelection.y <= position.getOffset() + position.getLength() && (targetPosition == null || position.getOffset() > targetPosition.getOffset())) {
                targetPosition = position;
            }
            ++n2;
        }
        if (targetPosition != null) {
            return new EnclosingElementRange(targetPosition.getOffset(), targetPosition.getLength());
        }
        return null;
    }

    private EnclosingElementRange selectLine(IRegion cursorLine, IDocument document) {
        try {
            Point inspectSelection = this.getPeekSelection();
            int selectionBeginLine = document.getLineOfOffset(inspectSelection.x);
            int selecitonEndLine = document.getLineOfOffset(inspectSelection.x + inspectSelection.y - 1);
            if (selectionBeginLine == selecitonEndLine && inspectSelection.y != cursorLine.getLength()) {
                return new EnclosingElementRange(cursorLine.getOffset(), cursorLine.getLength());
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        return null;
    }

    private EnclosingElementRange selectBracket(IRegion cursorLine, Point initialSelection) {
        boolean case4;
        BracketDetails selectionBracket = this.bracketOffsetsAndLength(initialSelection.x);
        if (selectionBracket == null || !selectionBracket.exists()) {
            return null;
        }
        boolean case1 = selectionBracket.getBeginOffset() > cursorLine.getOffset() && selectionBracket.getEndOffset() < cursorLine.getOffset() + cursorLine.getLength() - 1;
        boolean case2 = selectionBracket.getEndOffset() > cursorLine.getOffset() && selectionBracket.getEndOffset() < cursorLine.getOffset() + cursorLine.getLength() - 1;
        boolean case3 = selectionBracket.getBeginOffset() > cursorLine.getOffset() && selectionBracket.getBeginOffset() < cursorLine.getOffset() + cursorLine.getLength() - 1;
        boolean bl = case4 = selectionBracket.getBeginOffset() < cursorLine.getOffset() && selectionBracket.getEndOffset() > initialSelection.x + initialSelection.y - 1;
        if (!(case1 || case2 || case3 || case4)) {
            return null;
        }
        int selectionStartOffset = selectionBracket.getBeginOffset() + 1;
        int selectionLength = selectionBracket.getLength() - 2;
        if (selectionLength <= 0) {
            return null;
        }
        if (initialSelection.x == selectionStartOffset && initialSelection.y == selectionLength) {
            return this.selectBracket(cursorLine, new Point(initialSelection.x - 1, initialSelection.y + 2));
        }
        return new EnclosingElementRange(selectionStartOffset, selectionLength);
    }

    private EnclosingElementRange selectWord(IRegion word, Point initialSelection) {
        if (initialSelection.y != 0) {
            return null;
        }
        if (word.getLength() <= 0) {
            return null;
        }
        return new EnclosingElementRange(word.getOffset(), word.getLength());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BracketDetails bracketOffsetsAndLength(int cursor) {
        try {
            IDocument document = this.getDocument();
            if (document == null) {
                return null;
            }
            int whereIsCursorNow = cursor - 1;
            int endOffset = -1;
            ArrayDeque<Character> brackets = new ArrayDeque<Character>();
            String partitioning = DVTFileUtils.getInstance().getPartitioning((IDocumentExtension3)document);
            if (partitioning == null) {
                return null;
            }
            while (whereIsCursorNow < document.getLength() - 1) {
                String codeType;
                if (!"__dftl_partition_content_type".equals(codeType = ((IDocumentExtension3)document).getContentType(partitioning, ++whereIsCursorNow, false))) continue;
                char currentChar = document.getChar(whereIsCursorNow);
                if (DVTDocumentUtils.isOpenBracket(Character.valueOf(currentChar))) {
                    brackets.push(Character.valueOf(currentChar));
                    continue;
                }
                if (!DVTDocumentUtils.isClosedBracket(Character.valueOf(currentChar))) continue;
                if (brackets.isEmpty()) {
                    endOffset = whereIsCursorNow;
                    break;
                }
                brackets.pop();
            }
            if (endOffset < 0) {
                return null;
            }
            int beginOffset = this.getBeginOffset(endOffset, document);
            if (beginOffset < 0) {
                return null;
            }
            return new BracketDetails(beginOffset, endOffset);
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
            return null;
        }
    }

    public EnclosingElementRange getEnclosingElementRange(IRegion word, Point initialSelection) throws BadLocationException {
        IDocument document = this.getDocument();
        if (document == null) {
            return null;
        }
        IRegion cursorLine = document.getLineInformationOfOffset(this.getCursor());
        if (cursorLine == null) {
            return null;
        }
        EnclosingElementRange didSelectWholeFile = this.selectWholeFile(cursorLine, document, initialSelection);
        if (didSelectWholeFile != null) {
            return didSelectWholeFile;
        }
        EnclosingElementRange didSelectWord = this.selectWord(word, initialSelection);
        if (didSelectWord != null) {
            return didSelectWord;
        }
        EnclosingElementRange didSelectLiteral = this.selectLiteral(document, initialSelection);
        if (didSelectLiteral != null) {
            return didSelectLiteral;
        }
        EnclosingElementRange didSelectBracket = this.selectBracket(cursorLine, initialSelection);
        if (didSelectBracket != null) {
            return didSelectBracket;
        }
        EnclosingElementRange didSelectLine = this.selectLine(cursorLine, document);
        if (didSelectLine != null) {
            return didSelectLine;
        }
        EnclosingElementRange didSelectAnnotation = this.selectAnnotation(initialSelection, cursorLine);
        if (didSelectAnnotation != null) {
            return didSelectAnnotation;
        }
        return null;
    }

    protected abstract int getCursor();

    protected abstract int getCursorLineNumber();

    protected abstract int getBeginOffset(int var1, IDocument var2) throws BadLocationException, BadPartitioningException;

    protected abstract IDocument getDocument();

    protected abstract Position[] getFoldingPositions();

    protected abstract Point getPeekSelection();

    public static class EnclosingElementRange {
        private int offset;
        private int length;

        public EnclosingElementRange(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }
    }
}

