/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;

public class TextUtils {
    public static final char EOF = '\uffff';

    public static String replaceTabsWithSpaces(String text, int tabSize) {
        if (text == null) {
            return text;
        }
        if (text.length() == 0 || tabSize < 0) {
            return text;
        }
        return text.replaceAll("\\t", TextUtils.getIndentTab(true, tabSize));
    }

    public static String replaceSpacesWithTabs(String text, int tabSize) {
        StringBuilder str = new StringBuilder();
        text = text.replaceAll("\\t", TextUtils.getIndentTab(true, tabSize));
        int length = text.length();
        char WS = ' ';
        char TAB = '\t';
        int tabs = length / tabSize;
        int spaces = length % tabSize;
        int i = 0;
        while (i < tabs) {
            str.append(TAB);
            ++i;
        }
        i = 0;
        while (i < spaces) {
            str.append(WS);
            ++i;
        }
        return str.toString();
    }

    public static String replaceTabsWithSpacesVisual(String content, int tabWidth) {
        try {
            StringBuilder buffer = new StringBuilder();
            int offset = 0;
            int length = content.length();
            int i = 0;
            while (i < length) {
                char ch = content.charAt(i);
                if (ch == '\t') {
                    int tabUpdate = tabWidth - offset % tabWidth;
                    String replacement = TextUtils.getIndentTab(true, tabUpdate);
                    offset += tabUpdate;
                    buffer.append(replacement);
                } else if (ch == '\r' || ch == '\n') {
                    offset = 0;
                    buffer.append(ch);
                } else {
                    ++offset;
                    buffer.append(ch);
                }
                ++i;
            }
            return buffer.toString();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return content;
        }
    }

    public static String getIndentTab(boolean useSpacesNotTabs, int tabSize) {
        if (!useSpacesNotTabs) {
            return "\t";
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < tabSize) {
            result.append(" ");
            ++i;
        }
        return result.toString();
    }

    public static int getLength(String text, int tabSize) {
        int length = 0;
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (ch == ' ') {
                ++length;
            } else if (ch == '\t') {
                int reminder = (int)Math.IEEEremainder(length, tabSize);
                length += tabSize - reminder;
            }
            ++i;
        }
        return length;
    }

    public static boolean getEditorSpacesForTabs(IPreferenceStore store) {
        if (store == null) {
            return false;
        }
        return store.getBoolean("spacesForTabs");
    }

    public static boolean emptyTabLineIndent(IDocument d, int offset, String prevIndent, String currentIndent, int tabSize) {
        if (d == null || prevIndent == null || currentIndent == null) {
            return false;
        }
        int prevCount = TextUtils.getLength(prevIndent, tabSize);
        int currentCount = TextUtils.getLength(currentIndent, tabSize);
        return TextUtils.isFollowedByWhitespaces(d, offset) && currentCount >= prevCount;
    }

    public static String trimNumberOfWhitespacesFromBeginningOfString(String string, int trimLength) {
        if (trimLength == 0) {
            return string;
        }
        if (string.isEmpty()) {
            return string;
        }
        char[] text = string.toCharArray();
        int i = 0;
        while (i < text.length) {
            char chr = text[i];
            if (Character.isWhitespace(chr) && i < trimLength) {
                ++i;
                continue;
            }
            if (!Character.isWhitespace(chr) || i >= trimLength) break;
            ++i;
        }
        return string.substring(i, string.length());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isFollowedByWhitespaces(IDocument document, int offset) {
        if (document == null || offset < 0 || offset > document.getLength()) {
            return false;
        }
        if (offset == document.getLength()) {
            return true;
        }
        try {
            int line = document.getLineOfOffset(offset);
            int start = document.getLineOffset(line);
            int end = Math.max(start + document.getLineLength(line), offset);
            int i = offset;
            while (true) {
                if (i >= end) {
                    return true;
                }
                char c = document.getChar(i);
                if (c == '\n' || c == '\r') {
                    return true;
                }
                if (!Character.isWhitespace(c)) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPrecededByWhitespaces(IDocument document, int offset) {
        if (document == null || offset < 0 || offset - 1 >= document.getLength()) {
            return false;
        }
        if (offset == 0) {
            return true;
        }
        try {
            int line = document.getLineOfOffset(offset);
            int start = document.getLineOffset(line);
            if (start == offset) {
                return true;
            }
            int i = offset - 1;
            while (true) {
                if (i < start) {
                    return true;
                }
                char c = document.getChar(i);
                if (c == '\n' || c == '\r') {
                    return true;
                }
                if (!Character.isWhitespace(c)) {
                    return false;
                }
                --i;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    public static char getChar(IDocument doc, int offset) {
        if (doc == null) {
            return '\uffff';
        }
        if (offset < 0 || offset >= doc.getLength()) {
            return '\uffff';
        }
        try {
            return doc.getChar(offset);
        }
        catch (Exception exception) {
            return '\uffff';
        }
    }
}

