/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.actions.CopyHierarchyPathActionCommon;
import ro.amiq.dvt.utils.Utils;

public class CopyHierarchyPathAction
extends CopyHierarchyPathActionCommon {
    public CopyHierarchyPathAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    @Override
    public void run() {
        String result = this.computeResult();
        if (result == null) {
            return;
        }
        Utils.copyToClipboard(result, 3);
    }

    @Override
    protected void notAvailableDialog() {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Operation not Available", null, "The operation is not available on the current selection.\nPlease select a design element to use Copy Hierarchy Path.", 2, new String[]{"OK"}, 0);
            dialog.open();
        });
    }

    @Override
    protected void notElaboratedDialog() {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Operation not Available", null, "The operation is not available on the current selection.\nThe selected element is not elaborated.", 2, new String[]{"OK"}, 0);
            dialog.open();
        });
    }

    @Override
    protected int getCursor() {
        if (!(this.getTextEditor() instanceof DVTEditor)) {
            return -1;
        }
        return ((DVTEditor)this.getTextEditor()).getCursor();
    }
}

