/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProviderCommon;

public abstract class CopyHierarchyPathActionCommon
extends TextEditorAction {
    protected CopyHierarchyPathActionCommon(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public abstract void run();

    public String computeResult() {
        ITextEditor editor = this.getTextEditor();
        if (!(editor instanceof DVTEditor)) {
            return null;
        }
        DVTEditor dvtEditor = (DVTEditor)editor;
        int cursor = this.getCursor();
        if (cursor < 0) {
            return null;
        }
        IRfNamedElementAndScope elementAndScope = dvtEditor.getElementFromOffset(cursor);
        if (elementAndScope == null) {
            this.notAvailableDialog();
            return null;
        }
        IRfNamedElement selection = elementAndScope.getIRfNamedElement();
        if (selection == null) {
            this.notAvailableDialog();
            return null;
        }
        if (!(selection instanceof IRfDesignElement || selection instanceof IRfInstanceElement || selection instanceof IRfFieldElement)) {
            this.notAvailableDialog();
            return null;
        }
        IRfScopeElement enclosingScope = this.getEnclosingScope(selection);
        if (enclosingScope == null) {
            this.notAvailableDialog();
            return null;
        }
        return this.computeHierarchyPath(elementAndScope, enclosingScope, dvtEditor);
    }

    protected abstract int getCursor();

    private String computeHierarchyPath(IRfNamedElementAndScope elementAndScope, IRfScopeElement enclosingScope, DVTEditor editor) {
        IRfNamedElement elementToSearch;
        if (elementAndScope == null || editor == null) {
            this.notAvailableDialog();
            return null;
        }
        IELMemory memory = RfMixedLangManager.getInstance().getELMemory(editor.getProject());
        if (memory == null) {
            this.notAvailableDialog();
            return null;
        }
        String segmentSeparator = this.getCopyHierarchyPathSegmentSeparator();
        IRfNamedElement selection = elementAndScope.getIRfNamedElement();
        IRfScopeElement scope = elementAndScope.getScope();
        if (DesignUtils.getDesignKind(selection) == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
            selection = ((IRfBlockElement)selection).getEntity();
        }
        if ((elementToSearch = this.getElemToSearch(selection, elementAndScope, enclosingScope)) == null) {
            this.notAvailableDialog();
            return null;
        }
        ElementPath path = DesignPathManager.getInstance().getPathFor(editor, this.getCursor(), selection, scope, false, false);
        if (path == null || path == DesignPathManager.FROZEN_MANAGER_EL_PATH) {
            this.notElaboratedDialog();
            return null;
        }
        ElementPath finalPath = IDesignPathProviderCommon.getPathPrefixedBy(memory, path, elementToSearch, false);
        if (finalPath == null || finalPath.isEmpty()) {
            this.notAvailableDialog();
            return null;
        }
        StringBuilder hierarchyPathSb = new StringBuilder();
        hierarchyPathSb.append(finalPath.toString(segmentSeparator));
        if (elementToSearch != selection) {
            hierarchyPathSb.append(segmentSeparator).append(selection.getName());
        }
        return hierarchyPathSb.toString();
    }

    private IRfNamedElement getElemToSearch(IRfNamedElement selection, IRfNamedElementAndScope elementAndScope, IRfScopeElement enclosingScope) {
        if (!(selection instanceof IRfFieldElement)) {
            return selection;
        }
        if (DesignUtils.getDesignKind(enclosingScope) == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
            enclosingScope = ((IRfBlockElement)enclosingScope).getEntity();
        }
        IRfScopeElement scopeElement = elementAndScope.getScope();
        if (!(selection instanceof IRfInstanceElement) && this.isSourcePort(scopeElement, selection)) {
            return enclosingScope instanceof IRfNamedElement ? (IRfNamedElement)enclosingScope : null;
        }
        if (scopeElement instanceof IRfDefElement) {
            scopeElement = ((IRfDefElement)((Object)scopeElement)).getNamedElement();
        }
        return scopeElement instanceof IRfNamedElement ? (IRfNamedElement)scopeElement : null;
    }

    private boolean isSourcePort(IRfScopeElement scopeElement, IRfNamedElement selection) {
        if (scopeElement == null || selection == null) {
            return false;
        }
        if (scopeElement instanceof IRfDefElement) {
            scopeElement = ((IRfDefElement)((Object)scopeElement)).getNamedElement();
        }
        if (!(scopeElement instanceof IRfNamedElement)) {
            return false;
        }
        IRfNamedElement element = (IRfNamedElement)scopeElement;
        IRfNamedElement member = element.getMember(selection.getName(), null, null, true, false, false, false, false);
        return member == selection;
    }

    private IRfScopeElement getEnclosingScope(IRfScopeElement elem) {
        if (elem == null) {
            return null;
        }
        if (elem instanceof IRfInstanceElement) {
            return ((IRfInstanceElement)elem).isInstanceToBind() ? ((IRfInstanceElement)elem).getBindInstanceScope() : elem.getEnclosingScope();
        }
        return elem.getEnclosingScope();
    }

    protected abstract void notAvailableDialog();

    protected abstract void notElaboratedDialog();

    public String getCopyHierarchyPathSegmentSeparator() {
        return DVTPlugin.getDefault().getPreferenceStore().getString("copyHierarchyPathSegmentSeparator");
    }
}

