/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.ITextEditor;

public class DVTEditorActionDelegate
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;
    private ITextEditor fTextEditor;

    public void dispose() {
        this.fWindow = null;
        this.fTextEditor = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
        IEditorPart editor = this.fWindow.getActivePage().getActiveEditor();
        if (editor instanceof ITextEditor) {
            this.fTextEditor = (ITextEditor)editor;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof TextSelection) {
            IWorkbenchPage activePage = this.fWindow.getActivePage();
            if (activePage == null) {
                return;
            }
            IEditorPart editor = activePage.getActiveEditor();
            if (editor instanceof ITextEditor) {
                this.fTextEditor = (ITextEditor)editor;
            }
        } else {
            this.fTextEditor = null;
        }
    }

    protected ITextEditor getActiveTextEditor() {
        if (this.fTextEditor == null) {
            this.init(this.fWindow);
        }
        return this.fTextEditor;
    }

    public void run(IAction action) {
    }

    public IWorkbenchWindow getWindow() {
        return this.fWindow;
    }

    public IResource getResource() {
        if (this.getActiveTextEditor() == null) {
            return null;
        }
        IEditorInput editorInput = this.getActiveTextEditor().getEditorInput();
        if (editorInput == null) {
            return null;
        }
        return (IFile)editorInput.getAdapter(IFile.class);
    }
}

