/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.actions;

import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTWordFinder;

public class DVTHippieCompleteAction
extends TextEditorAction {
    private DVTEditor editor;
    private SearchState searchState;
    private DVTWordFinder wordFinder;

    public DVTHippieCompleteAction(ResourceBundle bundle, String prefix, DVTEditor editor) {
        super(bundle, prefix, (ITextEditor)editor);
        this.editor = editor;
        this.wordFinder = editor.getWordFinder();
        this.searchState = new SearchState();
    }

    public void run() {
        if (!this.validateEditorInputState()) {
            return;
        }
        try {
            this.searchState.init(this.editor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
        this.internalRun();
    }

    private void internalRun() {
        try {
            IDocument document = this.searchState.document;
            if (document == null) {
                return;
            }
            int cursorOffset = this.editor.getCursor();
            int startOfWord = this.wordFinder.goToStartOfWord(document, cursorOffset);
            if (startOfWord == 0) {
                return;
            }
            Region prefixRegion = new Region(startOfWord, cursorOffset - startOfWord);
            if (this.searchState.prefix == null || this.searchState.prefix.isEmpty()) {
                this.searchState.prefix = document.get(prefixRegion.getOffset(), prefixRegion.getLength());
            }
            Region editingRegion = new Region(this.searchState.insertOffset, this.searchState.prevProposalLength);
            IRegion proposalRegion = this.wordFinder.getRegionOfWordWithPrefix(document, this.searchState.prefix, this.searchState.prevProposalOffset + this.searchState.prevProposalLength, this.searchState.previousWords, (IRegion)editingRegion);
            String proposalText = "";
            if (proposalRegion == null) {
                if (this.searchState.previousWords.isEmpty()) {
                    this.searchState.reset();
                    return;
                }
                this.searchState.reset();
                proposalText = this.searchState.prefix;
            } else {
                proposalText = document.get(proposalRegion.getOffset(), proposalRegion.getLength());
                this.searchState.update(proposalRegion, prefixRegion.getOffset());
                this.searchState.previousWords.add(proposalText);
            }
            document.replace(prefixRegion.getOffset(), prefixRegion.getLength(), proposalText);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private static class SearchState {
        int insertOffset;
        int prevProposalLength;
        int prevProposalOffset;
        String prefix;
        IDocument document;
        Set<String> previousWords = new HashSet<String>();

        private SearchState() {
        }

        public void init(DVTEditor editor) throws Exception {
            String currentWord;
            IDocument editorDocument = editor.getDocument();
            if (this.document == null || !this.document.equals(editorDocument)) {
                this.document = editorDocument;
                this.prefix = null;
                this.reset();
                return;
            }
            if (this.insertOffset + this.prevProposalLength == editor.getCursor() && (currentWord = this.document.get(this.insertOffset, this.prevProposalLength)).startsWith(this.prefix)) {
                return;
            }
            this.prefix = null;
            this.reset();
        }

        private void reset() {
            this.insertOffset = -1;
            this.prevProposalOffset = 0;
            this.prevProposalLength = 0;
            this.previousWords.clear();
        }

        public void update(IRegion currentProposalPosition, int replaceStartOffset) {
            this.insertOffset = replaceStartOffset;
            this.prevProposalOffset = currentProposalPosition.getOffset();
            this.prevProposalLength = currentProposalPosition.getLength();
        }
    }
}

