/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistExtractVariableProposal;
import ro.amiq.dvt.ui.editor.quickassist.util.DVTExtractToVariableDialog;

public abstract class DVTRefactorExtractToVariableAction
extends TextEditorAction {
    protected ITextViewer fViewer;

    public DVTRefactorExtractToVariableAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public void run() {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null || !(textEditor instanceof DVTEditor)) {
            return;
        }
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
        if (document == null) {
            return;
        }
        this.fViewer = ((DVTEditor)textEditor).getTextViewer();
        ISelection selection = this.fViewer.getSelectionProvider().getSelection();
        if (!(selection instanceof ITextSelection)) {
            this.popEmptySelection();
            return;
        }
        String selectionText = ((ITextSelection)selection).getText();
        if (selectionText == null || selectionText.isEmpty()) {
            this.popEmptySelection();
            return;
        }
        ICompletionProposal[] proposals = this.getProposals();
        if (proposals == null || proposals.length == 0) {
            this.popUnsupportedElement(selectionText);
            return;
        }
        DVTExtractToVariableDialog dialog = new DVTExtractToVariableDialog(DVTUiUtils.getActiveWorkbenchShell(), selectionText, "Extract to local variable");
        if (dialog.open() == 1) {
            return;
        }
        boolean isReplaceAll = dialog.isReplaceAll();
        String varName = dialog.getVarName();
        DVTAbstractQuickAssistExtractVariableProposal extractToVarProposal = null;
        DVTAbstractQuickAssistExtractVariableProposal extractToVarReplaceAllProposal = null;
        ICompletionProposal[] iCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal currProposal = iCompletionProposalArray[n2];
            if (currProposal instanceof DVTAbstractQuickAssistExtractVariableProposal) {
                if (currProposal.getDisplayString().equalsIgnoreCase("Extract to local variable (replace all occurrences)")) {
                    extractToVarReplaceAllProposal = (DVTAbstractQuickAssistExtractVariableProposal)currProposal;
                }
                if (currProposal.getDisplayString().equalsIgnoreCase("Extract to local variable")) {
                    extractToVarProposal = (DVTAbstractQuickAssistExtractVariableProposal)currProposal;
                }
            }
            ++n2;
        }
        if (isReplaceAll && extractToVarReplaceAllProposal != null) {
            this.applyProposal(extractToVarReplaceAllProposal, varName, document);
            return;
        }
        if (extractToVarProposal != null) {
            this.applyProposal(extractToVarProposal, varName, document);
        }
    }

    protected void popUnsupportedElement(final String selectionText) {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Extract to local variable", null, "The operation is unavailable on the current selection: '" + selectionText.replaceAll("\\R", " ") + "'\nPlease select a valid " + DVTRefactorExtractToVariableAction.this.getLanguageString() + " expression.", 2, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }

    protected void popEmptySelection() {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Extract to local variable", null, "Cannot perform extract to local variable on empty selection.\nPlease select a valid " + DVTRefactorExtractToVariableAction.this.getLanguageString() + " expression.", 2, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }

    protected void applyProposal(DVTAbstractQuickAssistExtractVariableProposal proposal, String varName, IDocument document) {
        if (!varName.isEmpty()) {
            proposal.setSpecifiedVarName(true);
            proposal.setSpecifiedVarName(varName);
        }
        proposal.apply(document);
    }

    protected abstract ICompletionProposal[] getProposals();

    protected abstract String getLanguageString();
}

