/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.actions;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.PaintManager;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.Bundle;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;

public class IndentGuideToggleHandler
extends AbstractHandler {
    private static final String NET_CERTIV_TOOLS_INDENTGUIDE_INDENT_GUIDE_PAINTER = "net.certiv.tools.indentguide.IndentGuidePainter";
    private static final String INDENT_GUIDE_ENABLED_ID = "indentguide.enabled";
    private static final String INDENT_GUIDE_PLUGIN_ID = "net.certiv.tools.indentguide";
    private static final String COMMAND_ID = "ro.amiq.dvt.actions.ToggleIndentGuide";
    private boolean shouldToggleState = true;
    private IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener;

    public IndentGuideToggleHandler() {
        Bundle indentGuidePlugin = Platform.getBundle((String)INDENT_GUIDE_PLUGIN_ID);
        if (indentGuidePlugin == null) {
            return;
        }
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(INDENT_GUIDE_PLUGIN_ID);
        if (node == null) {
            return;
        }
        String prefValue = node.get(INDENT_GUIDE_ENABLED_ID, "true");
        boolean prefState = "true".equals(prefValue);
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (service == null) {
            return;
        }
        final Command command = service.getCommand(COMMAND_ID);
        if (command == null) {
            return;
        }
        try {
            boolean oldState = HandlerUtil.toggleCommandState((Command)command);
            if (oldState == prefState) {
                HandlerUtil.toggleCommandState((Command)command);
            }
        }
        catch (ExecutionException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.preferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                try {
                    if (!IndentGuideToggleHandler.INDENT_GUIDE_ENABLED_ID.equals(event.getKey())) {
                        return;
                    }
                    if (!IndentGuideToggleHandler.this.shouldToggleState) {
                        IndentGuideToggleHandler.this.shouldToggleState = true;
                        return;
                    }
                    HandlerUtil.toggleCommandState((Command)command);
                }
                catch (ExecutionException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        };
        IWorkbenchPage[] pages = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPages();
        int i = 0;
        while (i < pages.length) {
            pages[i].addPartListener(new IPartListener2(){

                public void partActivated(IWorkbenchPartReference partRef) {
                }

                public void partBroughtToTop(IWorkbenchPartReference partRef) {
                }

                public void partClosed(IWorkbenchPartReference partRef) {
                    try {
                        DVTProjectionViewer sourceViewer = IndentGuideToggleHandler.this.getSourceViewer(partRef);
                        if (sourceViewer == null) {
                            return;
                        }
                        List<?> painters = IndentGuideToggleHandler.this.getPainters(sourceViewer);
                        if (painters == null || painters.isEmpty()) {
                            return;
                        }
                        for (Object painter : painters) {
                            if (!(painter instanceof IPainter) || !IndentGuideToggleHandler.NET_CERTIV_TOOLS_INDENTGUIDE_INDENT_GUIDE_PAINTER.equals(painter.getClass().getCanonicalName())) continue;
                            sourceViewer.removePainter((IPainter)painter);
                            ((IPainter)painter).dispose();
                            break;
                        }
                    }
                    catch (Exception exception) {}
                }

                public void partDeactivated(IWorkbenchPartReference partRef) {
                }

                public void partOpened(IWorkbenchPartReference partRef) {
                }

                public void partHidden(IWorkbenchPartReference partRef) {
                }

                public void partVisible(IWorkbenchPartReference partRef) {
                }

                public void partInputChanged(IWorkbenchPartReference partRef) {
                }
            });
            ++i;
        }
        node.addPreferenceChangeListener(this.preferenceChangeListener);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEclipsePreferences node;
        Bundle indentGuidePlugin;
        block10: {
            block9: {
                block8: {
                    indentGuidePlugin = Platform.getBundle((String)INDENT_GUIDE_PLUGIN_ID);
                    if (indentGuidePlugin != null) break block8;
                    return null;
                }
                node = InstanceScope.INSTANCE.getNode(INDENT_GUIDE_PLUGIN_ID);
                if (node != null) break block9;
                return null;
            }
            Command command = event.getCommand();
            boolean oldValue = HandlerUtil.toggleCommandState((Command)command);
            if (oldValue == "true".equals(node.get(INDENT_GUIDE_ENABLED_ID, "true"))) break block10;
            return null;
        }
        try {
            this.shouldToggleState = false;
            boolean removePainter = this.togglePreference(node);
            for (IEditorReference editorReference : Utils.getCurrentlyOpenEditorReferences()) {
                List<?> painters;
                DVTProjectionViewer sourceViewer = this.getSourceViewer((IWorkbenchPartReference)editorReference);
                if (sourceViewer == null || (painters = this.getPainters(sourceViewer)) == null || painters.isEmpty()) continue;
                boolean hasPainter = false;
                for (Object painter : painters) {
                    if (!(painter instanceof IPainter) || !NET_CERTIV_TOOLS_INDENTGUIDE_INDENT_GUIDE_PAINTER.equals(painter.getClass().getCanonicalName())) continue;
                    if (removePainter) {
                        sourceViewer.removePainter((IPainter)painter);
                        ((IPainter)painter).dispose();
                    }
                    hasPainter = true;
                    break;
                }
                if (removePainter || hasPainter) continue;
                this.addPainter(sourceViewer, indentGuidePlugin);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    private DVTProjectionViewer getSourceViewer(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (!(part instanceof DVTEditor)) {
            return null;
        }
        DVTEditor dvtEditor = (DVTEditor)part;
        ITextViewer sourceViewer = dvtEditor.getTextViewer();
        if (!(sourceViewer instanceof DVTProjectionViewer)) {
            return null;
        }
        return (DVTProjectionViewer)sourceViewer;
    }

    private void addPainter(DVTProjectionViewer sourceViewer, Bundle indentGuidePlugin) throws Exception {
        Class cIndentGuidePainter = indentGuidePlugin.loadClass(NET_CERTIV_TOOLS_INDENTGUIDE_INDENT_GUIDE_PAINTER);
        if (cIndentGuidePainter == null) {
            return;
        }
        Constructor ctor = cIndentGuidePainter.getConstructor(ITextViewer.class);
        if (ctor == null) {
            return;
        }
        Object newPainterInstance = ctor.newInstance(new Object[]{sourceViewer});
        if (!(newPainterInstance instanceof IPainter)) {
            return;
        }
        IPainter newIGPainter = (IPainter)newPainterInstance;
        sourceViewer.addPainter(newIGPainter);
    }

    private List<?> getPainters(DVTProjectionViewer sourceViewer) throws Exception {
        PaintManager paintManager = sourceViewer.getPaintManager();
        if (paintManager == null) {
            return null;
        }
        Field fPaintersField = PaintManager.class.getDeclaredField("fPainters");
        if (fPaintersField == null) {
            return null;
        }
        fPaintersField.setAccessible(true);
        Object fPaintersRaw = fPaintersField.get(paintManager);
        if (!(fPaintersRaw instanceof List)) {
            return null;
        }
        List painters = (List)fPaintersRaw;
        if (painters == null || painters.isEmpty()) {
            return null;
        }
        return painters;
    }

    private boolean togglePreference(IEclipsePreferences node) {
        String is = node.get(INDENT_GUIDE_ENABLED_ID, "true");
        boolean oldValue = is.equals("true");
        try {
            if (!oldValue) {
                node.remove(INDENT_GUIDE_ENABLED_ID);
            } else {
                node.put(INDENT_GUIDE_ENABLED_ID, "false");
            }
            node.flush();
            return oldValue;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return oldValue;
        }
    }

    public void dispose() {
        Bundle indentGuidePlugin = Platform.getBundle((String)INDENT_GUIDE_PLUGIN_ID);
        if (indentGuidePlugin == null) {
            return;
        }
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(INDENT_GUIDE_PLUGIN_ID);
        if (node == null) {
            return;
        }
        node.removePreferenceChangeListener(this.preferenceChangeListener);
        super.dispose();
    }
}

