/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.BuildConfigToken;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.actions.ShowIncludingFileActionCommon;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.StringMatcher;

public class ShowIncludingFileAction
extends ShowIncludingFileActionCommon {
    public ShowIncludingFileAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public void run() {
        if (!(this.getTextEditor() instanceof DVTEditor)) {
            return;
        }
        DVTEditor dvtEditor = (DVTEditor)this.getTextEditor();
        IProject project = dvtEditor.getProject();
        if (project == null) {
            return;
        }
        ParserPath parserPath = dvtEditor.getParserPath();
        if (parserPath == null) {
            return;
        }
        Map<String, BuildConfigProperty> hashFiles = this.getUniqueProposals(project, parserPath);
        if (hashFiles == null || hashFiles.isEmpty()) {
            return;
        }
        ArrayList<Object> chosenFiles = new ArrayList<BuildConfigProperty>();
        if (hashFiles.size() == 1 || TestHelper.isTestMode()) {
            chosenFiles.add(hashFiles.values().iterator().next());
        } else {
            chosenFiles = this.getSelectedFilesFromDialog(hashFiles.values(), Path.fromOSString((String)parserPath.path).lastSegment());
            if (chosenFiles == null || chosenFiles.isEmpty()) {
                return;
            }
        }
        for (BuildConfigProperty buildConfigProperty : chosenFiles) {
            IFile buildFile;
            String filePath;
            BuildConfigToken tokenConfigFile = (BuildConfigToken)buildConfigProperty.getAttributes().get("ATTRIBUTE_TOKEN");
            if (tokenConfigFile == null || (filePath = tokenConfigFile.getFilename()) == null || (buildFile = this.getBuildFile(project, filePath)) == null) continue;
            this.gotoTopFile(buildFile, tokenConfigFile.getOffset(), tokenConfigFile.getLength());
        }
    }

    @Override
    protected String computeFileKey(BuildConfigToken tokenConfigFile, String pathFile) {
        return String.valueOf(pathFile) + tokenConfigFile.getOffset();
    }

    private ArrayList<BuildConfigProperty> getSelectedFilesFromDialog(Collection<BuildConfigProperty> includingFiles, String fileBaseName) {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                BuildConfigToken token = (BuildConfigToken)((BuildConfigProperty)element).getAttributes().get("ATTRIBUTE_TOKEN");
                if (token == null) {
                    return "N/A";
                }
                return String.valueOf(Path.fromOSString((String)token.getFilename()).lastSegment()) + " @ line " + token.getLine() + " in " + token.getFilename();
            }

            public Image getImage(Object element) {
                return DVTImages.imageCache.getImage(DVTImages.DESC_BC_MODULE);
            }
        };
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)labelProvider, (ILabelProvider)labelProvider){
            private final /* synthetic */ ILabelProvider val$labelProvider;
            {
                this.val$labelProvider = iLabelProvider;
                super($anonymous0, $anonymous1);
            }

            protected FilteredList createFilteredList(Composite parent) {
                FilteredList list = super.createFilteredList(parent);
                list.setLabelProvider(this.val$labelProvider);
                list.setFilterMatcher(new FilteredList.FilterMatcher(){
                    private StringMatcher fMatcher;

                    public void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
                        this.fMatcher = ViewsUtils.createCamelCaseOrRegexMatcher(pattern, ignoreCase, ignoreWildCards);
                    }

                    public boolean match(Object element) {
                        return ViewsUtils.matchCamelCaseOrRegex(this.fMatcher, fFilteredList.getLabelProvider().getText(element));
                    }
                });
                return list;
            }
        };
        dialog.setTitle("Go To Include");
        dialog.setMessage("Select the locations you want to open ('" + fileBaseName + "' is included multiple times):");
        dialog.setElements(includingFiles.toArray());
        dialog.setMultipleSelection(true);
        ArrayList<BuildConfigProperty> selectedFiles = new ArrayList<BuildConfigProperty>();
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result == null) {
                return null;
            }
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object != null) {
                    BuildConfigProperty selection = (BuildConfigProperty)object;
                    selectedFiles.add(selection);
                }
                ++n2;
            }
        }
        return selectedFiles;
    }
}

