/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.actions;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.BuildConfigToken;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTFileUtils;

public abstract class ShowIncludingFileActionCommon
extends TextEditorAction {
    protected ShowIncludingFileActionCommon(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public Map<String, BuildConfigProperty> getUniqueProposals(IProject project, ParserPath parserPath) {
        List includeProps = BuildConfigManager.getIncludeProperties(project).stream().filter(property -> property.getValue().equals(parserPath.path)).collect(Collectors.toList());
        if (includeProps == null || includeProps.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, BuildConfigProperty> hashFiles = new LinkedHashMap<String, BuildConfigProperty>();
        for (BuildConfigProperty property2 : includeProps) {
            String pathFile;
            BuildConfigToken tokenConfigFile = (BuildConfigToken)property2.getAttributes().get("ATTRIBUTE_TOKEN");
            if (tokenConfigFile == null || (pathFile = tokenConfigFile.getFilename()) == null) continue;
            String key = this.computeFileKey(tokenConfigFile, pathFile);
            hashFiles.put(key, property2);
        }
        return hashFiles;
    }

    protected abstract String computeFileKey(BuildConfigToken var1, String var2);

    protected IFile getBuildFile(IProject project, String includedTopFile) {
        return DVTFileUtils.getInstance().getProjectFile(project, includedTopFile);
    }

    protected void gotoTopFile(IFile buildFile, int offset, int length) {
        DVTFileUtils.getInstance().openEditor(buildFile, (IRegion)new Region(offset, length));
    }
}

