/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.editor.DVTEditor;

public class ToggleMarkOccurrencesAction
extends TextEditorAction
implements IPropertyChangeListener {
    private IPreferenceStore fStore;

    public ToggleMarkOccurrencesAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, null, 2);
        this.setEditor(editor);
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        if (editor != null) {
            if (this.fStore == null) {
                this.fStore = DVTPlugin.getDefault().getPreferenceStore();
                this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
                boolean checked = this.fStore.getBoolean("markOccurrences");
                this.valueChanged(checked);
            }
        } else if (this.fStore != null) {
            this.setChecked(false);
            this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fStore = null;
        }
        this.update();
    }

    public void run() {
        boolean checked = this.getCheckedStatus();
        this.fStore.setValue("markOccurrences", !checked);
    }

    public void update() {
        this.setEnabled(this.getTextEditor() != null);
    }

    private void valueChanged(boolean on) {
        DVTEditor editor = (DVTEditor)this.getTextEditor();
        editor.enableOccurrenceAnnotations(on);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("markOccurrences")) {
            this.valueChanged(Boolean.parseBoolean(event.getNewValue().toString()));
        }
    }

    private boolean getCheckedStatus() {
        if (this.fStore != null) {
            return this.fStore.getBoolean("markOccurrences");
        }
        return false;
    }
}

