/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.breadcrumb;

import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItemDetails;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItemDropDown;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.BCInputLabelProvider;
import ro.amiq.dvt.ui.editor.breadcrumb.ThickBreadcrumbItemDetails;

public abstract class AbstractBreadcrumbItem
extends Item {
    protected BCInputLabelProvider fLabelProvider;
    protected ITreeContentProvider fContentProvider;
    protected ILabelProvider fToolTipLabelProvider;
    private final AbstractBreadcrumbViewer fParent;
    protected Composite fContainer;
    protected AbstractBreadcrumbItemDetails fDetailsBlock;
    protected AbstractBreadcrumbItemDropDown fExpandBlock;
    private boolean fIsLast;
    private boolean fIsGrayedOut;

    protected AbstractBreadcrumbItem(AbstractBreadcrumbViewer viewer, Composite parent) {
        super((Widget)parent, 0);
        this.fParent = viewer;
        this.fContainer = new Composite(parent, 0);
        this.fContainer.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginBottom = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        this.fContainer.setLayout((Layout)layout);
        this.fContainer.setData("org.eclipse.e4.ui.css.disabled", (Object)true);
        this.fContainer.setTabList(new Control[0]);
        this.init();
    }

    public List<?> getDropDownElements() {
        if (this.fParent == null) {
            return null;
        }
        return this.fParent.getDropDownElements();
    }

    public AbstractBreadcrumbViewer getViewer() {
        return this.fParent;
    }

    public void setContentProvider(ITreeContentProvider contentProvider) {
        this.fContentProvider = contentProvider;
    }

    public void setLabelProvider(BCInputLabelProvider labelProvider) {
        this.fLabelProvider = labelProvider;
    }

    public void setToolTipLabelProvider(ILabelProvider toolTipLabelProvider) {
        this.fToolTipLabelProvider = toolTipLabelProvider;
    }

    public void dispose() {
        if (this.fContainer != null) {
            this.fContainer.dispose();
        }
        this.fContainer = null;
        if (this.fDetailsBlock != null) {
            this.fDetailsBlock.dispose();
        }
        this.fDetailsBlock = null;
        if (this.fExpandBlock != null) {
            this.fExpandBlock.dispose();
        }
        this.fExpandBlock = null;
        super.dispose();
    }

    public void setShowText(boolean enabled) {
        this.fDetailsBlock.setTextVisible(enabled);
    }

    boolean isShowText() {
        return this.fDetailsBlock.isTextVisible();
    }

    public void setSelected(boolean selected) {
        this.fDetailsBlock.setSelected(selected);
    }

    void setFocus(boolean state) {
        this.fDetailsBlock.setFocus(state);
    }

    boolean hasFocus() {
        return this.fDetailsBlock.hasFocus();
    }

    void refresh() {
        Object data = this.getData();
        if (data == null) {
            return;
        }
        String text = this.fLabelProvider.getText(data);
        String toolTip = this.fToolTipLabelProvider.getText(data);
        Color backgroundColor = this.fLabelProvider.getBackground(data);
        Color foregroundColor = this.fLabelProvider.getForeground(data);
        this.fDetailsBlock.setText(text);
        this.fDetailsBlock.setToolTip(toolTip);
        if ("false".equals(System.getProperty("org.eclipse.swt.internal.gtk.cairoGraphics")) || "false".equals(System.getProperty("Dorg.eclipse.swt.internal.gtk.useCairo"))) {
            this.fDetailsBlock.setBackground(new Color((Device)this.getDisplay(), new RGB(255, 255, 255)));
        }
        this.fDetailsBlock.setBackground(backgroundColor);
        this.fDetailsBlock.setForeground(foregroundColor);
        this.refreshArrow();
    }

    protected void refreshArrow() {
        if (this.fExpandBlock == null || this.fContentProvider == null) {
            return;
        }
        this.fExpandBlock.setEnabled(this.fContentProvider.hasChildren(this.getData()));
    }

    void setIsLastItem(boolean isLast) {
        this.fIsLast = isLast;
        GridData data = (GridData)this.fContainer.getLayoutData();
        data.grabExcessHorizontalSpace = isLast;
    }

    void setDetailsVisible(boolean visible) {
        this.fDetailsBlock.setVisible(visible);
    }

    public void openDropDownMenu() {
        if (this.fParent == null || this.fExpandBlock == null) {
            return;
        }
        this.fExpandBlock.showMenu();
    }

    public void closeDropDownMenu() {
        this.fExpandBlock.hideMenu();
    }

    public boolean isMenuShown() {
        return this.fExpandBlock.isMenuShown();
    }

    Shell getDropDownShell() {
        return this.fExpandBlock.getDropDownShell();
    }

    ISelectionProvider getDropDownSelectionProvider() {
        return this.fExpandBlock.getDropDownSelectionProvider();
    }

    public Rectangle getBounds() {
        return this.fContainer.getBounds();
    }

    public void setToolTip(String text) {
        this.fDetailsBlock.setToolTip(text);
    }

    public void setText(String string) {
        if (string == null) {
            return;
        }
        super.setText(string);
        this.fDetailsBlock.setText(string);
        if (this.fIsLast) {
            this.fContainer.layout(true, true);
        }
    }

    public void setImage(Image image) {
        super.setImage(image);
        if (this.fDetailsBlock instanceof ThickBreadcrumbItemDetails) {
            ((ThickBreadcrumbItemDetails)this.fDetailsBlock).setImage(image);
        }
    }

    public void setGrayedOut(boolean isGrayedOut) {
        this.fIsGrayedOut = isGrayedOut;
    }

    public boolean isGrayedOut() {
        return this.fIsGrayedOut;
    }

    public void setDetailsEnabled(boolean enabled) {
        if (this.fDetailsBlock == null) {
            return;
        }
        this.fDetailsBlock.setEnabled(enabled);
    }

    public void setEnabled(boolean enabled) {
        if (this.fDetailsBlock == null) {
            return;
        }
        this.fDetailsBlock.setEnabled(enabled);
    }

    public boolean isEnabled() {
        if (this.fDetailsBlock == null) {
            return false;
        }
        return this.fDetailsBlock.isEnabled();
    }

    public void init() {
        IBaseLabelProvider labelProvider = this.fParent.getLabelProvider();
        if (!(labelProvider instanceof BCInputLabelProvider)) {
            return;
        }
        this.setLabelProvider((BCInputLabelProvider)labelProvider);
        ILabelProvider toolTipProvider = this.fParent.getToolTipProvider();
        if (toolTipProvider != null) {
            this.setToolTipLabelProvider(toolTipProvider);
        } else {
            this.setToolTipLabelProvider((ILabelProvider)labelProvider);
        }
        this.setContentProvider((ITreeContentProvider)this.fParent.getContentProvider());
    }

    int getWidth() {
        int result = 2;
        if (this.fDetailsBlock != null) {
            result += this.fDetailsBlock.getWidth();
        }
        if (this.fExpandBlock != null) {
            result += this.fExpandBlock.getWidth();
        }
        return result;
    }

    public AbstractBreadcrumbItemDropDown testGetDropDown() {
        return this.fExpandBlock;
    }

    public void testOpenDropdownMenu() {
        if (this.fParent == null || this.fExpandBlock == null) {
            return;
        }
        Object data = this.getData();
        this.fParent.computeDropdownElements(data);
        this.fExpandBlock.showMenu();
        this.fExpandBlock.setFocus();
    }
}

