/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.breadcrumb;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItem;
import ro.amiq.dvt.ui.views.IFilterableView;
import ro.amiq.dvt.ui.views.TextFilterObject;

public abstract class AbstractBreadcrumbItemDropDown {
    protected static final boolean IS_MAC_WORKAROUND = "carbon".equals(SWT.getPlatform());
    private static final String ID = "BC_DROP_DOWN_ID";
    private static final String TREE_ID = "BC_DROP_DOWN_TREE_ID";
    protected static final int DROP_DOWN_MIN_WIDTH = 250;
    protected static final int DROP_DOWN_MAX_WIDTH = 500;
    protected static final int DROP_DOWN_DEFAULT_MIN_HEIGHT = 200;
    protected static final int DROP_DOWN_DEFAULT_MAX_HEIGHT = 300;
    private static final String DIALOG_SETTINGS = "BreadcrumbItemDropDown";
    protected static final String DIALOG_HEIGHT = "height";
    protected static final String DROPDOWN_JOB = "Computing dropdown elements for ";
    protected AbstractBreadcrumbItem fParent;
    protected Composite fParentComposite;
    private boolean fMenuIsShown;
    protected boolean fEnabled;
    protected ColumnViewer fDropDownViewer;
    protected Shell fShell;
    protected boolean fIsResizingProgrammatically;
    private Text fSearchText;
    protected Job fDropdownJob;
    protected IPropertyChangeListener fThemeListener;
    private ControlAdapter fControlListener;
    private IOpenListener fOpenListener;
    private MouseListener fMouseListener;
    private CustomKeyAdapter fDropdownKeyListener;
    private KeyListener fTextFilterKeyListener;
    private Text fTextFilter;

    protected AbstractBreadcrumbItemDropDown(AbstractBreadcrumbItem parent, Composite composite) {
        this.fParent = parent;
        this.fParentComposite = composite;
        this.fMenuIsShown = false;
        this.fEnabled = true;
    }

    public void hideMenu() {
        this.fMenuIsShown = false;
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.setVisible(false);
        }
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public boolean isMenuShown() {
        return this.fMenuIsShown;
    }

    public Shell getDropDownShell() {
        if (!this.isMenuShown()) {
            return null;
        }
        return this.fShell;
    }

    public ISelectionProvider getDropDownSelectionProvider() {
        if (!this.fMenuIsShown) {
            return null;
        }
        return this.fDropDownViewer;
    }

    public void setDropDownViewerData(Composite dropDownViewer) {
        dropDownViewer.setLayoutData((Object)new GridData(4, 4, true, true));
        Object input = this.fParent.getData();
        if (input == null) {
            return;
        }
        this.fParent.getViewer().configureDropDownViewer(this.fDropDownViewer, input);
    }

    public void addListenersAndFilter(final Composite dropDownViewerComposite) {
        Composite menuComposite = dropDownViewerComposite.getParent().getParent();
        TextFilterObject textFilterObject = new TextFilterObject((IFilterableView)this.fDropDownViewer, ID, menuComposite, TREE_ID, true);
        textFilterObject.getControl().moveAbove(menuComposite.getChildren()[0]);
        this.fTextFilter = textFilterObject.getTextFilter();
        this.fTextFilter.setMessage("Filter by: name (* = any string, ? = any character)");
        this.fControlListener = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (AbstractBreadcrumbItemDropDown.this.fIsResizingProgrammatically) {
                    return;
                }
                Point size = AbstractBreadcrumbItemDropDown.this.fShell.getSize();
                AbstractBreadcrumbItemDropDown.this.getDialogSettings().put(AbstractBreadcrumbItemDropDown.DIALOG_HEIGHT, size.y);
            }
        };
        this.fOpenListener = e -> {
            ISelection selection = e.getSelection();
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element == null) {
                return;
            }
            this.openElement(element);
        };
        this.fMouseListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                if ((OpenStrategy.getOpenMethod() & 1) != 0) {
                    return;
                }
                Object item = dropDownViewerComposite instanceof Table ? ((Table)dropDownViewerComposite).getItem(new Point(e.x, e.y)) : ((Tree)dropDownViewerComposite).getItem(new Point(e.x, e.y));
                if (item == null) {
                    return;
                }
                AbstractBreadcrumbItemDropDown.this.openElement(item.getData());
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        this.fTextFilterKeyListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                    AbstractBreadcrumbItemDropDown.this.fDropDownViewer.getControl().setFocus();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        };
        this.fDropdownKeyListener = new CustomKeyAdapter(textFilterObject);
        this.fShell.addControlListener((ControlListener)this.fControlListener);
        this.fDropDownViewer.addOpenListener(this.fOpenListener);
        dropDownViewerComposite.addMouseListener(this.fMouseListener);
        dropDownViewerComposite.addKeyListener((KeyListener)this.fDropdownKeyListener);
        this.fTextFilter.addKeyListener(this.fTextFilterKeyListener);
    }

    public Composite createMenuComposite() {
        if (!this.fEnabled || this.fMenuIsShown || this.fParent == null || this.fParent.isDisposed() || this.fParent.getData() == null) {
            return null;
        }
        this.fMenuIsShown = true;
        this.fShell = new Shell(this.getShell(), 16404);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fShell.setLayout((Layout)layout);
        Composite composite = new Composite((Composite)this.fShell, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        return composite;
    }

    protected abstract Shell getShell();

    public String getInstanceName(Item item) {
        String trimmedName = item.getText().trim();
        int indexOfDelimiter = trimmedName.indexOf(":");
        if (indexOfDelimiter <= 0) {
            return trimmedName;
        }
        return trimmedName.substring(0, indexOfDelimiter - 1);
    }

    public void openElement(Object data) {
        boolean hasFocus;
        if (data == null) {
            return;
        }
        this.fParent.getViewer().fireMenuSelection(data);
        Composite dropDownViewerComposite = this.getDropDownViewerComposite();
        boolean treeHasFocus = this.fShell != null && !this.fShell.isDisposed() && dropDownViewerComposite.isFocusControl();
        boolean searchHasFocus = this.fShell != null && !this.fShell.isDisposed() && this.fSearchText != null && this.fSearchText.isFocusControl();
        boolean bl = hasFocus = treeHasFocus || searchHasFocus;
        if (this.fShell == null || this.fShell.isDisposed()) {
            return;
        }
        if (!hasFocus) {
            this.fShell.close();
            return;
        }
    }

    public void installCloser(final Shell shell) {
        Listener focusListener = e -> {
            Widget focusElement = e.widget;
            boolean isFocusBreadcrumbTreeFocusWidget = focusElement == shell || focusElement instanceof Text && ((Text)focusElement).getShell() == shell || focusElement instanceof Tree && ((Tree)focusElement).getShell() == shell || focusElement instanceof Table && ((Table)focusElement).getShell() == shell;
            boolean isFocusWidgetParentShell = focusElement instanceof Control && ((Control)focusElement).getShell().getParent() == shell;
            switch (e.type) {
                case 15: {
                    if (isFocusBreadcrumbTreeFocusWidget || isFocusWidgetParentShell) break;
                    shell.close();
                    break;
                }
                case 16: {
                    if (e.display.getActiveShell() != null) break;
                    shell.close();
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false);
                }
            }
        };
        Display display = shell.getDisplay();
        display.addFilter(15, focusListener);
        display.addFilter(16, focusListener);
        ControlListener controlListener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
                shell.close();
            }

            public void controlResized(ControlEvent e) {
                shell.close();
            }
        };
        this.getShell().addControlListener(controlListener);
        ShellListener shellListener = new ShellListener(){

            public void shellActivated(ShellEvent e) {
            }

            public void shellClosed(ShellEvent e) {
                if (!AbstractBreadcrumbItemDropDown.this.fMenuIsShown) {
                    return;
                }
                AbstractBreadcrumbItemDropDown.this.fMenuIsShown = false;
                AbstractBreadcrumbItemDropDown.this.fDropDownViewer = null;
            }

            public void shellDeactivated(ShellEvent e) {
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellIconified(ShellEvent e) {
            }
        };
        shell.addShellListener(shellListener);
        shell.addDisposeListener(e -> {
            display.removeFilter(15, focusListener);
            display.removeFilter(16, focusListener);
            if (!this.isDisposed()) {
                this.getShell().removeControlListener(controlListener);
                shell.removeShellListener(shellListener);
            }
        });
    }

    protected abstract boolean isDisposed();

    private IDialogSettings getDialogSettings() {
        IDialogSettings javaSettings = DVTPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = javaSettings.getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = javaSettings.addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected int getMaxHeight() {
        try {
            return this.getDialogSettings().getInt(DIALOG_HEIGHT);
        }
        catch (NumberFormatException numberFormatException) {
            return 300;
        }
    }

    protected static Monitor getClosestMonitor(Display display, Point point) {
        int closest = Integer.MAX_VALUE;
        Monitor[] monitors = display.getMonitors();
        Monitor result = monitors[0];
        int i = 0;
        while (i < monitors.length) {
            Monitor current = monitors[i];
            Rectangle clientArea = current.getClientArea();
            if (clientArea.contains(point)) {
                return current;
            }
            int distance = Geometry.distanceSquared((Point)Geometry.centerPoint((Rectangle)clientArea), (Point)point);
            if (distance < closest) {
                closest = distance;
                result = current;
            }
            ++i;
        }
        return result;
    }

    protected void resizeShell(Shell shell) {
        Point size = shell.getSize();
        int currentWidth = size.x;
        int currentHeight = size.y;
        int maxHeight = this.getMaxHeight();
        if (currentHeight >= maxHeight && currentWidth >= 500) {
            return;
        }
        Point preferedSize = shell.computeSize(-1, -1, true);
        int newWidth = currentWidth >= 500 ? currentWidth : Math.min(Math.max(preferedSize.x, currentWidth), 500);
        int newHeight = currentHeight >= maxHeight ? currentHeight : Math.min(Math.max(preferedSize.y, currentHeight), maxHeight);
        if (newHeight != currentHeight || newWidth != currentWidth) {
            shell.setRedraw(false);
            try {
                this.fIsResizingProgrammatically = true;
                shell.setSize(newWidth, newHeight);
                if (!this.isLTR()) {
                    Point location = shell.getLocation();
                    shell.setLocation(location.x - (newWidth - currentWidth), location.y);
                }
            }
            finally {
                this.fIsResizingProgrammatically = false;
                shell.setRedraw(true);
            }
        }
    }

    protected boolean isLTR() {
        return (this.fParentComposite.getStyle() & 0x4000000) == 0;
    }

    public void addTableListeners(final Table table) {
        table.addMouseMoveListener(new MouseMoveListener(){
            TableItem fLastItem;

            public void mouseMove(MouseEvent e) {
                if (table.equals(e.getSource())) {
                    TableItem o = table.getItem(new Point(e.x, e.y));
                    if (o != null && !o.equals(this.fLastItem) || this.fLastItem != null && o == null) {
                        table.setCursor(null);
                    }
                    if (o instanceof TableItem) {
                        Rectangle clientArea = table.getClientArea();
                        if (!o.equals(this.fLastItem)) {
                            this.fLastItem = o;
                            table.setSelection(new TableItem[]{this.fLastItem});
                        } else if (e.y - clientArea.y < table.getItemHeight() / 4) {
                            int index = table.indexOf(o);
                            if (index < 1) {
                                return;
                            }
                            this.fLastItem = table.getItem(index - 1);
                            table.setSelection(new TableItem[]{this.fLastItem});
                        } else if (clientArea.y + clientArea.height - e.y < table.getItemHeight() / 4) {
                            int index = table.indexOf(o);
                            if (index >= table.getItemCount() - 1) {
                                return;
                            }
                            this.fLastItem = table.getItem(index + 1);
                            table.setSelection(new TableItem[]{this.fLastItem});
                        }
                    } else if (o == null) {
                        this.fLastItem = null;
                    }
                }
            }
        });
    }

    public void setFocus() {
        if (this.fShell == null || this.fShell.isDisposed()) {
            return;
        }
        this.fShell.setFocus();
    }

    public void showMenu() {
        if (this.fParent == null) {
            return;
        }
        final Object data = this.fParent.getData();
        if (this.fDropdownJob != null) {
            this.fDropdownJob.cancel();
        }
        this.fDropdownJob = new Job(DROPDOWN_JOB + this.fParent.getText()){

            protected IStatus run(IProgressMonitor monitor) {
                AbstractBreadcrumbItemDropDown.this.fParent.getViewer().computeDropdownElements(data);
                Display.getDefault().asyncExec(() -> {
                    AbstractBreadcrumbItemDropDown.this.internalShowMenu();
                    AbstractBreadcrumbItemDropDown.this.setFocus();
                    AbstractBreadcrumbItemDropDown.this.clearObjection();
                });
                return Status.OK_STATUS;
            }
        };
        this.fDropdownJob.setSystem(true);
        this.fDropdownJob.schedule();
    }

    private void removeListeners() {
        if (this.fThemeListener != null) {
            PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.fThemeListener);
        }
        this.fThemeListener = null;
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.removeControlListener((ControlListener)this.fControlListener);
        }
        if (this.fDropDownViewer != null) {
            this.fDropDownViewer.removeOpenListener(this.fOpenListener);
        }
        if (this.fTextFilter != null && !this.fTextFilter.isDisposed()) {
            this.fTextFilter.removeKeyListener(this.fTextFilterKeyListener);
        }
        this.fControlListener = null;
        this.fOpenListener = null;
        this.fTextFilterKeyListener = null;
        Composite dropDownViewerComposite = this.getDropDownViewerComposite();
        if (dropDownViewerComposite == null || dropDownViewerComposite.isDisposed()) {
            this.fMouseListener = null;
            this.fDropdownKeyListener = null;
            return;
        }
        dropDownViewerComposite.removeMouseListener(this.fMouseListener);
        dropDownViewerComposite.removeKeyListener((KeyListener)this.fDropdownKeyListener);
        this.fMouseListener = null;
        this.fDropdownKeyListener = null;
    }

    public void dispose() {
        if (this.fDropdownJob != null) {
            this.fDropdownJob.cancel();
        }
        this.removeListeners();
        if (this.fParentComposite != null) {
            this.fParentComposite.dispose();
        }
        if (this.fSearchText != null) {
            this.fSearchText.dispose();
        }
        if (this.fTextFilter != null) {
            this.fTextFilter.dispose();
        }
        this.fDropdownJob = null;
        this.fParentComposite = null;
        this.fParent = null;
        this.fShell = null;
        this.fSearchText = null;
        this.fDropDownViewer = null;
        this.fTextFilter = null;
    }

    protected abstract void internalShowMenu();

    public abstract void updateDropDownViewer(String var1);

    public abstract Composite getDropDownViewerComposite();

    public abstract void setShellBounds(Shell var1);

    public abstract int getWidth();

    public abstract void setEnabled(boolean var1);

    protected abstract void clearObjection();

    public List<?> testGetElements() {
        this.fParent.getViewer().computeDropdownElements(this.fParent.getData());
        return this.fParent.getDropDownElements();
    }

    static class CustomKeyAdapter
    extends KeyAdapter {
        private final TextFilterObject textFilterObject;

        public CustomKeyAdapter(TextFilterObject textFilterObject) {
            this.textFilterObject = textFilterObject;
        }

        public void keyPressed(KeyEvent event) {
            if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                return;
            }
            if (event.keyCode == 8) {
                if (this.textFilterObject == null) {
                    return;
                }
                Text filterText = this.textFilterObject.getTextFilter();
                if (filterText == null) {
                    return;
                }
                String currentText = filterText.getText();
                filterText.setFocus();
                filterText.setText(currentText.substring(0, Math.max(0, currentText.length() - 1)));
                filterText.setSelection(filterText.getCharCount(), filterText.getCharCount());
            } else if (event.character != '\u0000' && (Character.isJavaIdentifierPart(event.character) && event.keyCode != 27 && event.keyCode != 127 || event.character == '*' || event.character == '.' || event.character == '?')) {
                if (event.character != (char)event.keyCode) {
                    return;
                }
                if (this.textFilterObject == null) {
                    return;
                }
                Text filterText = this.textFilterObject.getTextFilter();
                if (filterText == null) {
                    return;
                }
                filterText.setText(String.valueOf(filterText.getText()) + event.character);
                filterText.setFocus();
                filterText.setSelection(filterText.getCharCount(), filterText.getCharCount());
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

