/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.breadcrumb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.ch.ICHDiagram;
import ro.amiq.dvt.diagrams.design.DPFDiagram;
import ro.amiq.dvt.diagrams.design.DTopPathDiagram;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.IBreadcrumbSerializer;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;

public interface AbstractBreadcrumbUtilsCommon {
    public static Collection<? extends IRfNamedElement> sort(Collection<? extends IRfNamedElement> collection) {
        Comparator alphabeticComparator = (o1, o2) -> o1.getName().compareTo(o2.getName());
        Comparator parserPathComparator = (o1, o2) -> {
            ParserPath parserPath2;
            ParserPath parserPath1 = o1.getDeclaration() != null ? o1.getDeclaration().getParserPath() : null;
            ParserPath parserPath = parserPath2 = o2.getDeclaration() != null ? o2.getDeclaration().getParserPath() : null;
            if (parserPath1 == null && parserPath2 != null) {
                return 1;
            }
            if (parserPath1 != null && parserPath2 == null) {
                return -1;
            }
            if (parserPath1 == null) {
                return 0;
            }
            return parserPath1.compareTo(parserPath2);
        };
        Comparator offsetComparator = (o1, o2) -> o1.getOffset() - o2.getOffset();
        ArrayList<? extends IRfNamedElement> list = new ArrayList<IRfNamedElement>(collection);
        list.sort(alphabeticComparator.thenComparing(parserPathComparator).thenComparing(offsetComparator));
        return list;
    }

    public static boolean isDiagramWithBreadcrumb(DDiagram diagram) {
        return diagram instanceof DTopPathDiagram || diagram instanceof DPFDiagram || diagram instanceof ICHDiagram;
    }

    public static boolean editorHasVerificationContext(DVTEditor editor) {
        if (editor == null) {
            return false;
        }
        AbstractBreadcrumbUtils verificationBreadcrumbUtils = editor.getBreadcrumbUtils(VHBreadcrumbViewer.class);
        if (!(verificationBreadcrumbUtils instanceof VHBreadcrumbUtils)) {
            return false;
        }
        return ((VHBreadcrumbUtils)verificationBreadcrumbUtils).checkClassesInFile(editor);
    }

    public static boolean editorHasDesignContext(DVTEditor editor) {
        if (editor == null || AbstractBreadcrumbUtilsCommon.editorHasVerificationContext(editor)) {
            return false;
        }
        return DesignPathManager.getInstance().isRegistered(editor);
    }

    default public IBreadcrumbSerializer getBreadcrumbSerializer() {
        return null;
    }

    public boolean validateScopeForBreadcrumb(IRfBreadcrumbElement var1);

    public String getBCType();

    public BreadcrumbInput computeBreadcrumbInput(IDVTBreadcrumbHost var1, AbstractBreadcrumbConfiguration var2, boolean var3);
}

