/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.breadcrumb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.WorkbenchPart;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItem;
import ro.amiq.dvt.ui.editor.breadcrumb.BCDropDownContentProvider;
import ro.amiq.dvt.ui.editor.breadcrumb.BCDropDownLabelProvider;
import ro.amiq.dvt.ui.editor.breadcrumb.BCInputContentProvider;
import ro.amiq.dvt.ui.editor.breadcrumb.BCInputLabelProvider;
import ro.amiq.dvt.ui.editor.breadcrumb.BCToolTipProvider;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbImageDescriptor;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbViewerRow;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public abstract class AbstractBreadcrumbViewer
extends StructuredViewer {
    private static final boolean IS_GTK = "gtk".equals(SWT.getPlatform());
    private ListenerList<MenuDetectListener> fMenuListeners;
    private BCFontListener fFontListener;
    protected Composite fBreadcrumbContainer;
    protected ArrayList<AbstractBreadcrumbItem> fBreadcrumbItems;
    protected List<?> fDropdownElements;
    protected AbstractBreadcrumbItem fSelectedItem;
    protected BCInputContentProvider fInputContentProvider;
    protected BCInputLabelProvider fInputLabelProvider;
    protected BCToolTipProvider fInputTooltipProvider;
    protected ILabelProvider fToolTipLabelProvider;
    protected IDVTBreadcrumbHost fActiveEditor;
    protected IContentProvider fDropDownContentProvider;
    protected BCDropDownLabelProvider fDropDownLabelProvider;
    protected BreadcrumbInput fBreadcrumbInput;
    protected Composite fTopContainer;
    protected Composite fTopComposite;
    protected Composite fBreadcrumbHostComposite;
    protected IDoubleClickListener fElementClickListener;
    protected IOpenListener fOpenFromDropDownListener;
    protected MenuDetectListener fContextMenuListener;
    protected IPropertyChangeListener fThemeListener;
    private Listener fResizeListener;
    private static final String DVT_BREADCRUMB_IMG_DESCRIPTOR_PREFIX = "DVT_BREADCRUMB_IMG_DESCRIPTOR_PREFIX_";
    protected boolean forceUpdate;
    protected Job fUpdateJob;

    protected AbstractBreadcrumbViewer(IDVTBreadcrumbHost editor, Composite topContainer) {
        this.fActiveEditor = editor;
        this.fTopContainer = topContainer;
    }

    public IDVTBreadcrumbHost getEditor() {
        return this.fActiveEditor;
    }

    protected void addBreadcrumbListeners() {
        if (this.fThemeListener != null) {
            PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.fThemeListener);
        }
        this.createListeners();
        if (this.fFontListener != null && this.fBreadcrumbHostComposite != null) {
            this.fBreadcrumbHostComposite.addListener(11, (Listener)this.fFontListener);
        }
        if (this.fElementClickListener != null) {
            this.addDoubleClickListener(this.fElementClickListener);
        }
        if (this.fContextMenuListener != null) {
            this.addMenuDetectListener(this.fContextMenuListener);
        }
        if (this.fOpenFromDropDownListener != null) {
            this.addOpenListener(this.fOpenFromDropDownListener);
        }
        if (this.fThemeListener != null) {
            PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.fThemeListener);
        }
    }

    public void createListeners() {
        this.fThemeListener = e -> {
            if (!e.getProperty().equals("ro.amiq.dvt.ui.editor.breadcrumb.backgroundColor")) {
                return;
            }
            Color backgroundColor = DVTColorUtil.INSTANCE.getColor((RGB)e.getNewValue());
            int height = this.fBreadcrumbHostComposite.getClientArea().height;
            Image image = height == 0 ? null : AbstractBreadcrumbViewer.createGradientImage(height, Display.getCurrent(), backgroundColor);
            this.fBreadcrumbHostComposite.setBackgroundImage(image);
            this.setBackgroundImageForErrorComposites(image);
        };
        this.fFontListener = new BCFontListener();
    }

    public void hideBreadcrumb() {
        if (this.isDisposed()) {
            return;
        }
        if (this.fTopComposite == null) {
            return;
        }
        Composite topControl = this.fTopComposite.getParent();
        this.fTopComposite.dispose();
        if (topControl == null) {
            return;
        }
        topControl.layout();
    }

    public BreadcrumbInput getInput() {
        return this.fBreadcrumbInput;
    }

    public void dispose() {
        this.fActiveEditor = null;
        this.fDropDownContentProvider = null;
        this.fDropDownLabelProvider = null;
        this.fInputContentProvider = null;
        this.fInputLabelProvider = null;
        this.fInputTooltipProvider = null;
        this.fToolTipLabelProvider = null;
        if (this.fUpdateJob != null) {
            this.fUpdateJob.cancel();
        }
        this.fUpdateJob = null;
        if (this.fBreadcrumbHostComposite != null && !this.fBreadcrumbHostComposite.isDisposed() && this.fFontListener != null) {
            this.fBreadcrumbHostComposite.removeListener(11, (Listener)this.fFontListener);
        }
        if (this.fFontListener != null) {
            this.fFontListener.dispose();
        }
        if (this.fBreadcrumbContainer != null && !this.fBreadcrumbContainer.isDisposed() && this.fResizeListener != null) {
            this.fBreadcrumbContainer.removeListener(11, this.fResizeListener);
        }
        if (this.fContextMenuListener != null) {
            this.removeMenuDetectListener(this.fContextMenuListener);
        }
        if (this.fElementClickListener != null) {
            this.removeDoubleClickListener(this.fElementClickListener);
        }
        if (this.fOpenFromDropDownListener != null) {
            this.removeOpenListener(this.fOpenFromDropDownListener);
        }
        if (this.fThemeListener != null) {
            PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.fThemeListener);
        }
        if (this.fBreadcrumbContainer != null) {
            this.fBreadcrumbContainer.dispose();
        }
        if (this.fTopComposite != null) {
            this.fTopComposite.dispose();
        }
        if (this.fBreadcrumbHostComposite != null) {
            this.fBreadcrumbHostComposite.dispose();
        }
        this.fFontListener = null;
        this.fResizeListener = null;
        this.fContextMenuListener = null;
        this.fElementClickListener = null;
        this.fOpenFromDropDownListener = null;
        this.fThemeListener = null;
        this.fBreadcrumbContainer = null;
        this.fTopComposite = null;
        this.fBreadcrumbHostComposite = null;
        this.fBreadcrumbInput = null;
        this.fBreadcrumbItems = null;
    }

    public boolean isDisposed() {
        return this.fTopComposite == null || this.fTopComposite.isDisposed();
    }

    public BCDropDownLabelProvider getDropDownLabelProvider() {
        return this.fDropDownLabelProvider;
    }

    protected String getActiveEditorName() {
        if (this.fActiveEditor instanceof WorkbenchPart) {
            return ((WorkbenchPart)this.fActiveEditor).getTitle();
        }
        return "";
    }

    protected IProject getProject() {
        return this.fActiveEditor.getProject();
    }

    public void createBreadcrumbViewerComponents(Composite parent, int style) {
        this.fBreadcrumbItems = new ArrayList();
        this.fMenuListeners = new ListenerList();
        this.fBreadcrumbContainer = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        this.fBreadcrumbContainer.setLayoutData((Object)layoutData);
        this.fBreadcrumbContainer.setBackgroundMode(1);
        this.hookControl((Control)this.fBreadcrumbContainer);
        GridLayout gridLayout = new GridLayout(1000, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.fBreadcrumbContainer.setLayout((Layout)gridLayout);
        this.fResizeListener = e -> this.refresh();
        this.fBreadcrumbContainer.addListener(11, this.fResizeListener);
    }

    public void setToolTipLabelProvider(ILabelProvider toolTipLabelProvider) {
        this.fToolTipLabelProvider = toolTipLabelProvider;
    }

    public ILabelProvider getToolTipProvider() {
        return this.fToolTipLabelProvider;
    }

    public Control getControl() {
        return this.fBreadcrumbContainer;
    }

    protected Object getRoot() {
        if (this.fBreadcrumbItems == null || this.fBreadcrumbItems.isEmpty() || this.fBreadcrumbItems.get(0).isDisposed()) {
            return null;
        }
        return this.fBreadcrumbItems.get(0).getData();
    }

    public void reveal(Object element) {
    }

    public void setFocus() {
        if (this.fBreadcrumbContainer.isDisposed()) {
            return;
        }
        this.fBreadcrumbContainer.setFocus();
        if (this.fBreadcrumbItems.isEmpty()) {
            return;
        }
        if (this.fSelectedItem == null) {
            this.fSelectedItem = this.getItem(this.getItemCount() - 1);
        }
        this.fSelectedItem.setFocus(true);
        for (AbstractBreadcrumbItem item : this.fBreadcrumbItems) {
            if (item == this.fSelectedItem) continue;
            item.setSelected(false);
            item.setFocus(false);
        }
    }

    public boolean hasFocus() {
        return this.fSelectedItem != null && this.fSelectedItem.hasFocus();
    }

    public void loseFocus() {
        if (this.fSelectedItem != null) {
            this.fSelectedItem.setFocus(false);
        }
    }

    public void deselectItem() {
        this.fSelectedItem = null;
    }

    public boolean isDropDownOpen() {
        int i = 0;
        int size = this.fBreadcrumbItems.size();
        while (i < size) {
            AbstractBreadcrumbItem item = this.fBreadcrumbItems.get(i);
            if (item.isMenuShown()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Shell getDropDownShell() {
        int i = 0;
        int size = this.fBreadcrumbItems.size();
        while (i < size) {
            AbstractBreadcrumbItem item = this.fBreadcrumbItems.get(i);
            if (item.isMenuShown()) {
                return item.getDropDownShell();
            }
            ++i;
        }
        return null;
    }

    public ISelectionProvider getDropDownSelectionProvider() {
        int i = 0;
        int size = this.fBreadcrumbItems.size();
        while (i < size) {
            AbstractBreadcrumbItem item = this.fBreadcrumbItems.get(i);
            if (item.isMenuShown()) {
                return item.getDropDownSelectionProvider();
            }
            ++i;
        }
        return null;
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.fMenuListeners.add((Object)listener);
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.fMenuListeners.remove((Object)listener);
    }

    protected void assertContentProviderType(IContentProvider provider) {
        super.assertContentProviderType(provider);
        Assert.isTrue((boolean)(provider instanceof ITreeContentProvider));
    }

    protected void inputChanged(Object fInput, Object oldInput) {
        if (this.fBreadcrumbContainer.isDisposed()) {
            return;
        }
        this.disableRedraw();
        try {
            int lastIndex;
            if (!this.fBreadcrumbItems.isEmpty()) {
                AbstractBreadcrumbItem last = this.fBreadcrumbItems.get(this.fBreadcrumbItems.size() - 1);
                last.setIsLastItem(false);
            }
            if ((lastIndex = this.buildItemChain(fInput)) > 0) {
                AbstractBreadcrumbItem last = this.fBreadcrumbItems.get(lastIndex - 1);
                last.setIsLastItem(true);
            }
            while (lastIndex < this.fBreadcrumbItems.size()) {
                AbstractBreadcrumbItem item = this.fBreadcrumbItems.remove(this.fBreadcrumbItems.size() - 1);
                if (item == this.fSelectedItem) {
                    this.selectItem(null, false);
                }
                if (item.getData() != null) {
                    this.unmapElement(item.getData());
                }
                item.dispose();
            }
            this.updateSize();
            this.fBreadcrumbContainer.layout(true, true);
        }
        finally {
            this.enableRedraw();
        }
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        if (widget instanceof AbstractBreadcrumbItem) {
            AbstractBreadcrumbItem item = (AbstractBreadcrumbItem)widget;
            if (fullMap) {
                this.associate(element, item);
            } else {
                Object data = item.getData();
                if (data != null) {
                    this.unmapElement(data, (Widget)item);
                }
                item.setData(element);
                this.mapElement(element, (Widget)item);
            }
            BreadcrumbViewerRow row = new BreadcrumbViewerRow(this, item);
            ViewerCell cell = row.getCell(0);
            IBaseLabelProvider labelProvider = this.getLabelProvider();
            if (labelProvider instanceof LabelProvider) {
                cell.setText(((LabelProvider)labelProvider).getText(element));
                cell.setImage(((LabelProvider)labelProvider).getImage(element));
            } else if (labelProvider instanceof CellLabelProvider) {
                ((CellLabelProvider)labelProvider).update(cell);
            }
            item.refreshArrow();
            if (this.fToolTipLabelProvider != null) {
                item.setToolTip(this.fToolTipLabelProvider.getText(item.getData()));
            } else {
                item.setToolTip(cell.getText());
            }
        }
    }

    protected List<Object> getSelectionFromWidget() {
        if (this.fSelectedItem == null || this.fSelectedItem.isDisposed()) {
            return Collections.emptyList();
        }
        if (this.fSelectedItem.getData() == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this.fSelectedItem.getData());
        return result;
    }

    protected void internalRefresh(Object element) {
        Composite container = this.getContainer();
        if (container == null || container.isDisposed()) {
            return;
        }
        this.disableRedraw();
        try {
            int i = 0;
            int size = this.fBreadcrumbItems.size();
            while (i < size) {
                AbstractBreadcrumbItem item = this.fBreadcrumbItems.get(i);
                if (item.isDisposed()) {
                    return;
                }
                item.refresh();
                ++i;
            }
            if (this.updateSize()) {
                this.fBreadcrumbContainer.layout(true, true);
            }
        }
        finally {
            this.enableRedraw();
        }
    }

    public void selectItem(AbstractBreadcrumbItem item, boolean keepFocus) {
        if (this.fSelectedItem != null && !this.fSelectedItem.isDisposed()) {
            this.fSelectedItem.setSelected(false);
            this.fSelectedItem.setFocus(false);
            this.fSelectedItem.refresh();
        }
        this.fSelectedItem = item;
        if (item != null && keepFocus) {
            this.setFocus();
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
            return;
        }
        int i = 0;
        int size = this.fBreadcrumbItems.size();
        while (i < size) {
            AbstractBreadcrumbItem listItem = this.fBreadcrumbItems.get(i);
            listItem.setFocus(false);
            ++i;
        }
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    public int getItemCount() {
        return this.fBreadcrumbItems.size();
    }

    public List<AbstractBreadcrumbItem> getItems() {
        return this.fBreadcrumbItems;
    }

    public AbstractBreadcrumbItem getItem(int index) {
        return this.fBreadcrumbItems.get(index);
    }

    public int getIndexOfItem(AbstractBreadcrumbItem item) {
        int i = 0;
        int size = this.fBreadcrumbItems.size();
        while (i < size) {
            AbstractBreadcrumbItem pItem = this.fBreadcrumbItems.get(i);
            if (pItem == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void fireDoubleClick() {
        this.fireDoubleClick(new DoubleClickEvent((Viewer)this, this.getSelection()));
    }

    void fireOpen() {
        this.fireOpen(new OpenEvent((Viewer)this, this.getSelection()));
    }

    public void fireMenuSelection(Object element) {
        this.fireOpen(new OpenEvent((Viewer)this, (ISelection)new StructuredSelection(element)));
    }

    void fireMenuDetect(MenuDetectEvent event) {
        Object[] listeners = this.fMenuListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((MenuDetectListener)listeners[i]).menuDetected(event);
            ++i;
        }
    }

    private int buildItemChain(Object element) {
        AbstractBreadcrumbItem item;
        if (element == null) {
            return 0;
        }
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.getContentProvider();
        Object parent = contentProvider.getParent(element);
        int index = this.buildItemChain(parent);
        if (index < this.fBreadcrumbItems.size()) {
            item = this.fBreadcrumbItems.get(index);
            if (item.getData() != null) {
                this.unmapElement(item.getData());
            }
        } else {
            item = this.createItem();
            this.fBreadcrumbItems.add(item);
        }
        if (this.equals(element, item.getData())) {
            this.update(element, null);
        } else {
            item.setData(element);
        }
        this.filterItem(item, element);
        item.refresh();
        this.mapElement(element, (Widget)item);
        return index + 1;
    }

    private boolean updateSize() {
        boolean requiresLayout;
        block8: {
            int currentWidth;
            int width;
            block7: {
                if (this.fBreadcrumbContainer.isDisposed()) {
                    return false;
                }
                width = this.fBreadcrumbContainer.getClientArea().width - this.getWidthOfExtraWidgets();
                currentWidth = this.getCurrentWidth();
                requiresLayout = false;
                if (currentWidth <= width) break block7;
                int index = 0;
                while (currentWidth > width && index < this.fBreadcrumbItems.size() - 1) {
                    AbstractBreadcrumbItem viewer = this.fBreadcrumbItems.get(index);
                    if (viewer.isShowText()) {
                        viewer.setShowText(false);
                        currentWidth = this.getCurrentWidth();
                        requiresLayout = true;
                    }
                    ++index;
                }
                break block8;
            }
            if (currentWidth >= width) break block8;
            int index = this.fBreadcrumbItems.size() - 1;
            while (currentWidth < width && index >= 0) {
                AbstractBreadcrumbItem viewer = this.fBreadcrumbItems.get(index);
                if (!viewer.isShowText()) {
                    viewer.setShowText(true);
                    currentWidth = this.getCurrentWidth();
                    if (currentWidth > width) {
                        viewer.setShowText(false);
                        index = 0;
                    } else {
                        requiresLayout = true;
                    }
                }
                this.filterItem(viewer, viewer.getData());
                --index;
            }
        }
        return requiresLayout;
    }

    private int getCurrentWidth() {
        int result = 0;
        int i = 0;
        int size = this.fBreadcrumbItems.size();
        while (i < size) {
            AbstractBreadcrumbItem viewer = this.fBreadcrumbItems.get(i);
            result += viewer.getWidth();
            ++i;
        }
        return result;
    }

    private void enableRedraw() {
        if (IS_GTK) {
            return;
        }
        this.fBreadcrumbContainer.setRedraw(true);
    }

    private void disableRedraw() {
        if (IS_GTK) {
            return;
        }
        this.fBreadcrumbContainer.setRedraw(false);
    }

    public static Image createGradientImage(int height, Display display, Color backgroundColor) {
        BreadcrumbImageDescriptor imageDescriptor = new BreadcrumbImageDescriptor(height, 50, backgroundColor, display);
        return DVTImages.imageCache.getImage(imageDescriptor);
    }

    public static void drawLine(int width, int position, Color color, GC gc) {
        gc.setForeground(color);
        gc.drawLine(0, position, width, position);
    }

    public static Color createColor(int color1, int color2, int ratio, Display display) {
        RGB rgb1 = display.getSystemColor(color1).getRGB();
        RGB rgb2 = display.getSystemColor(color2).getRGB();
        RGB blend = AbstractBreadcrumbViewer.blend(rgb2, rgb1, ratio);
        return DVTColorUtil.INSTANCE.getColor(blend);
    }

    public static RGB blend(RGB c1, RGB c2, int ratio) {
        int r = AbstractBreadcrumbViewer.blend(c1.red, c2.red, ratio);
        int g = AbstractBreadcrumbViewer.blend(c1.green, c2.green, ratio);
        int b = AbstractBreadcrumbViewer.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    private static int blend(int v1, int v2, int ratio) {
        int b = (ratio * v1 + (100 - ratio) * v2) / 100;
        return Math.min(255, b);
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.fToolTipLabelProvider != null) {
            this.fToolTipLabelProvider.dispose();
            this.fToolTipLabelProvider = null;
        }
        if (this.fBreadcrumbItems != null) {
            for (AbstractBreadcrumbItem item : this.fBreadcrumbItems) {
                item.dispose();
            }
        }
        this.fSelectedItem = null;
        super.handleDispose(event);
    }

    protected Composite getContainer() {
        return this.fBreadcrumbContainer;
    }

    protected void initBreadcrumb() {
        this.createBreadcrumbDropDownProviders();
        this.createBreadcrumbInputProviders();
        this.createBreadcrumbSWTComponents(this.fTopContainer);
        this.createBreadcrumbViewerComponents(this.getComponentsParent(), 0);
        this.addBreadcrumbListeners();
        this.setContentProvider((IContentProvider)this.fInputContentProvider);
        this.setLabelProvider((IBaseLabelProvider)this.fInputLabelProvider);
        this.setToolTipLabelProvider((ILabelProvider)this.fInputTooltipProvider);
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        AbstractBreadcrumbItem item;
        AbstractBreadcrumbItem focusItem = null;
        int i = 0;
        int size = this.fBreadcrumbItems.size();
        while (i < size) {
            item = this.fBreadcrumbItems.get(i);
            if (item.hasFocus()) {
                focusItem = item;
            }
            item.setSelected(false);
            ++i;
        }
        if (l == null) {
            return;
        }
        for (Object element : l) {
            item = (AbstractBreadcrumbItem)this.doFindItem(element);
            if (item == null) continue;
            item.setSelected(true);
            this.fSelectedItem = item;
            if (item != focusItem) continue;
            item.setFocus(true);
        }
    }

    protected Widget doFindInputItem(Object element) {
        if (element == null) {
            return null;
        }
        if (element == this.getInput() || element.equals(this.getInput())) {
            return this.doFindItem(element);
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        if (element == null) {
            return null;
        }
        int i = 0;
        int size = this.fBreadcrumbItems.size();
        while (i < size) {
            AbstractBreadcrumbItem item = this.fBreadcrumbItems.get(i);
            if (item.getData() == element || element.equals(item.getData())) {
                return item;
            }
            ++i;
        }
        return null;
    }

    protected abstract void filterItem(AbstractBreadcrumbItem var1, Object var2);

    protected abstract int getWidthOfExtraWidgets();

    protected abstract Composite getComponentsParent();

    protected abstract AbstractBreadcrumbItem createItem();

    protected List<?> getDropDownElements() {
        return this.fDropdownElements;
    }

    public List<AbstractBreadcrumbItem> testGetBreadcrumbItems(int startingIndex) {
        return this.fBreadcrumbItems.subList(startingIndex, this.fBreadcrumbItems.size());
    }

    public BCInputLabelProvider testGetInputLabelProvider() {
        return this.fInputLabelProvider;
    }

    public BCInputContentProvider testGetInputContentProvider() {
        return this.fInputContentProvider;
    }

    public BCDropDownLabelProvider testGetDropdownLabelProvider() {
        return this.fDropDownLabelProvider;
    }

    public BCDropDownContentProvider testGetDropDownContentProvider() {
        return (BCDropDownContentProvider)this.fDropDownContentProvider;
    }

    public abstract void updateNonGUIPart(Class<?> var1, AbstractBreadcrumbConfiguration var2, boolean var3);

    public abstract void updateGuiPart(boolean var1, BreadcrumbInput var2);

    public abstract void setSelectOtherInstancesButtonEnable(boolean var1);

    public abstract void createBreadcrumbSWTComponents(Composite var1);

    public abstract void createBreadcrumbDropDownProviders();

    public abstract void createBreadcrumbInputProviders();

    public abstract void setBackgroundImageForErrorComposites(Image var1);

    public abstract void configureDropDownViewer(ColumnViewer var1, Object var2);

    public abstract void computeDropdownElements(Object var1);

    private class BCFontListener
    implements Listener {
        private Image gradientBackground;

        private BCFontListener() {
        }

        public void handleEvent(Event event) {
            Color backgroundColor = JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.editor.breadcrumb.backgroundColor");
            int height = AbstractBreadcrumbViewer.this.fBreadcrumbHostComposite.getClientArea().height;
            if (this.gradientBackground == null || this.gradientBackground.getBounds().height != height) {
                Image image = height == 0 ? null : AbstractBreadcrumbViewer.createGradientImage(height, event.display, backgroundColor);
                AbstractBreadcrumbViewer.this.fBreadcrumbHostComposite.setBackgroundImage(image);
                AbstractBreadcrumbViewer.this.setBackgroundImageForErrorComposites(image);
                this.gradientBackground = image;
            }
        }

        public void dispose() {
            if (this.gradientBackground == null) {
                return;
            }
            this.gradientBackground = null;
        }
    }
}

