/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.breadcrumb;

import java.util.Objects;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class BreadcrumbImageDescriptor
extends ImageDescriptor {
    private int height;
    private int width;
    private Color backgroundColor;
    private Display display;

    public BreadcrumbImageDescriptor(int height, int width, Color backgroundColor, Display display) {
        this.height = height;
        this.width = width;
        this.backgroundColor = backgroundColor;
        this.display = display;
    }

    public int hashCode() {
        return Objects.hash(this.backgroundColor, this.height, this.width);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BreadcrumbImageDescriptor other = (BreadcrumbImageDescriptor)((Object)obj);
        return Objects.equals(this.backgroundColor, other.backgroundColor) && this.height == other.height && this.width == other.width;
    }

    public ImageData getImageData() {
        Image image = new Image((Device)this.display, this.width, this.height);
        GC gc = new GC((Drawable)image);
        try {
            gc.setForeground(this.backgroundColor);
            gc.setBackground(this.backgroundColor);
            gc.fillGradientRectangle(0, 0, this.width, 10, true);
            gc.setBackground(this.backgroundColor);
            gc.fillRectangle(0, 9, this.width, this.height - 4);
        }
        finally {
            gc.dispose();
        }
        ImageData imageData = image.getImageData();
        image.dispose();
        return imageData;
    }
}

