/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.breadcrumb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.interpreter.DVTXRunBuildPhaseUtils;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.breadcrumb.IBreadcrumbSerializer;

public class BreadcrumbInput {
    public static final BreadcrumbInput CLEAR = new BreadcrumbInput();
    public static final BreadcrumbInput REMOVE_BREADCRUMB = new BreadcrumbInput();
    public static final BreadcrumbInput NO_ELAB_ELEM_IN_FILE = new BreadcrumbInput();
    public static final BreadcrumbInput NO_ELAB_ELEM_AT_CURSOR = new BreadcrumbInput();
    private List<BreadcrumbSegment> inputSegments;
    private Object serializedInput;
    private IBreadcrumbSerializer bcSerializator;
    private IProject project;

    private BreadcrumbInput() {
    }

    public BreadcrumbInput(IProject project, List<BreadcrumbSegment> inputSegments, IBreadcrumbSerializer bcSerializator) {
        this.bcSerializator = bcSerializator;
        this.project = project;
        this.reset(inputSegments);
    }

    public BreadcrumbInput(IProject project, BreadcrumbInput breadcrumbInput, IBreadcrumbSerializer bcSerializator) {
        this.bcSerializator = bcSerializator;
        this.project = project;
        this.reset(breadcrumbInput.inputSegments);
    }

    private void setSerializationObject() {
        if (this.inputSegments == null || this.inputSegments.isEmpty() || this.bcSerializator == null) {
            return;
        }
        this.serializedInput = this.bcSerializator.computeSerializationObject(this.inputSegments);
    }

    public List<BreadcrumbSegment> getInputSegments() {
        if (this.inputSegments == null) {
            return null;
        }
        if (this.bcSerializator != null && this.bcSerializator.isDirtyInput(this.inputSegments)) {
            this.inputSegments = this.bcSerializator.restoreBreadcrumbSegments(this.serializedInput, this.project);
            if (this.inputSegments == null) {
                this.serializedInput = null;
            }
        }
        return this.inputSegments;
    }

    public ElementPath getElementPath() {
        return this.getElementPath(false);
    }

    public ElementPath getElementPath(boolean stripRootSegment) {
        if (this.inputSegments == null) {
            return null;
        }
        ElementPath instancePath = ElementPath.EMPTY_PATH;
        for (BreadcrumbSegment segment : this.inputSegments) {
            String elementName;
            IRfBreadcrumbElement element = segment.getElement();
            if (element == null) {
                return null;
            }
            if (stripRootSegment && ElementPath.$ROOT_NAME_PATH.equals(element)) continue;
            String string = elementName = element instanceof IXXVMComponent ? BreadcrumbInput.getXXVMName((IXXVMComponent)element) : element.getName();
            if (elementName == null) {
                return null;
            }
            instancePath = ElementPath.join(instancePath, elementName);
        }
        return instancePath;
    }

    public IProject getProject() {
        return this.project;
    }

    public ElementPath getElementPathUpTo(IRfBreadcrumbElement upToElement) {
        if (upToElement instanceof ElementPath) {
            return (ElementPath)upToElement;
        }
        if (this.inputSegments == null || upToElement == null) {
            return null;
        }
        ElementPath instancePath = ElementPath.EMPTY_PATH;
        for (BreadcrumbSegment segment : this.inputSegments) {
            String name;
            IRfBreadcrumbElement element = segment.getElement();
            if (element == null) {
                return null;
            }
            String string = name = element instanceof IXXVMComponent ? BreadcrumbInput.getXXVMName((IXXVMComponent)element) : element.getName();
            if (name == null) {
                return null;
            }
            instancePath = ElementPath.join(instancePath, name);
            if (upToElement != element) continue;
            return instancePath;
        }
        return instancePath;
    }

    public static String getXXVMName(IXXVMComponent element) {
        IXXVMComponent parent = element.getParent();
        if (parent == null || DVTXRunBuildPhaseUtils.XVM_ROOT.contains(parent.getSVType())) {
            return element.getSVType();
        }
        return element.getName();
    }

    public List<BreadcrumbSegment> getSegmentsUpTo(IRfBreadcrumbElement upToElement) {
        if (this.inputSegments == null || upToElement == null) {
            return null;
        }
        ArrayList<BreadcrumbSegment> result = new ArrayList<BreadcrumbSegment>(5);
        for (BreadcrumbSegment segment : this.inputSegments) {
            IRfBreadcrumbElement predefined;
            IRfBreadcrumbElement element = segment.getElement();
            if (element == null) {
                return null;
            }
            result.add(segment);
            if (upToElement == element) {
                return result;
            }
            if (!(upToElement instanceof IRfVHBreadcrumbElement) || !(element instanceof IRfVHBreadcrumbElement) || (predefined = this.bcSerializator.getPredefinedElement((IRfVHBreadcrumbElement)upToElement, (IRfVHBreadcrumbElement)element)) == null) continue;
            return result;
        }
        return result;
    }

    public List<BreadcrumbSegment> getDesignSegmentsUpTo(IRfNamedElement upToElement) {
        if (this.inputSegments == null || upToElement == null) {
            return null;
        }
        IELMemory memory = RfMixedLangManager.getInstance().getELMemory(this.getProject());
        if (memory == null) {
            return Collections.emptyList();
        }
        ArrayList<BreadcrumbSegment> result = new ArrayList<BreadcrumbSegment>(5);
        for (BreadcrumbSegment segment : this.inputSegments) {
            IRfInstanceElement description;
            IRfBreadcrumbElement element = segment.getElement();
            if (!(element instanceof ElementPath)) {
                return Collections.emptyList();
            }
            ElementPath elToSearch = (ElementPath)element;
            if ((elToSearch = elToSearch.removeFirstSegment()).isEmpty()) {
                result.add(segment);
                continue;
            }
            ELInstance instance = memory.instanceFor(elToSearch);
            if (instance == null || (description = instance.getDescription()) == null) continue;
            result.add(segment);
            if (!(description instanceof DummyInstance ? !((DummyInstance)description).isGenerateInstance() && ((DummyInstance)description).design == upToElement : description == upToElement)) continue;
            return result;
        }
        return result;
    }

    public List<IRfBreadcrumbElement> getInputPathElements() {
        if (this.inputSegments == null) {
            return null;
        }
        ArrayList<IRfBreadcrumbElement> result = new ArrayList<IRfBreadcrumbElement>();
        for (BreadcrumbSegment segment : this.inputSegments) {
            IRfBreadcrumbElement element = segment.getElement();
            if (!(element instanceof ElementPath)) {
                result.add(element);
                continue;
            }
            String[] segments = ((ElementPath)element).getSegments();
            if (segments == null || ElementPath.$ROOT_NAME_PATH.equals(element)) continue;
            String[] strippedSegments = Arrays.copyOfRange(segments, 1, segments.length);
            result.add(ElementPath.create(strippedSegments));
        }
        return result;
    }

    public int indexOfSegment(IRfBreadcrumbElement segment) {
        if (this.inputSegments == null) {
            return -1;
        }
        int i = 0;
        while (i < this.inputSegments.size()) {
            BreadcrumbSegment iBreadcrumbSegment = this.inputSegments.get(i);
            if (iBreadcrumbSegment != null && segment.equals(iBreadcrumbSegment.getElement())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isRoot(IRfBreadcrumbElement segment, boolean inDD) {
        if (segment instanceof ElementPath) {
            if (inDD) {
                ElementPath elToSearch = (ElementPath)segment;
                return this.indexOfSegment(elToSearch = elToSearch.removeLastSegment()) == 0;
            }
            return this.indexOfSegment(segment) == 1;
        }
        return this.indexOfSegment(segment) == 0;
    }

    public boolean isEmpty() {
        return this.inputSegments == null || this.inputSegments.isEmpty();
    }

    public IRfBreadcrumbElement getLeafSegment() {
        if (this.inputSegments == null || this.inputSegments.isEmpty()) {
            return null;
        }
        return this.inputSegments.get(this.inputSegments.size() - 1).getElement();
    }

    public IRfBreadcrumbElement getSegment(int index) {
        if (this.inputSegments == null || index >= this.inputSegments.size() || index < 0) {
            return null;
        }
        return this.inputSegments.get(index).getElement();
    }

    public IRfDesignElement getLeafDesignElement() {
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(this.project);
        if (elManager == null) {
            return null;
        }
        IRfBreadcrumbElement leafSegment = this.getLeafSegment();
        if (!(leafSegment instanceof ElementPath)) {
            return null;
        }
        IRfNamedElement designElem = elManager.getMemory().bindingFor(((ElementPath)leafSegment).toElaborationForm(), false);
        if (!(designElem instanceof IRfDesignElement)) {
            return null;
        }
        return (IRfDesignElement)designElem;
    }

    public IRfBreadcrumbElement getRootElement() {
        if (this.inputSegments == null || this.inputSegments.isEmpty()) {
            return null;
        }
        return this.inputSegments.get(0).getElement();
    }

    public void reset(List<BreadcrumbSegment> newInputSegments) {
        if (newInputSegments == null) {
            return;
        }
        this.inputSegments = new ArrayList<BreadcrumbSegment>(newInputSegments);
        this.setSerializationObject();
    }

    public void append(IRfBreadcrumbElement hyperlinkScope) {
        if (this.inputSegments == null) {
            this.inputSegments = new ArrayList<BreadcrumbSegment>();
        }
        this.inputSegments.add(new BreadcrumbSegment(hyperlinkScope));
        this.setSerializationObject();
    }

    public BreadcrumbInput removeLastSegment() {
        if (this.inputSegments == null || this.inputSegments.isEmpty()) {
            return this;
        }
        this.inputSegments.remove(this.inputSegments.size() - 1);
        this.setSerializationObject();
        return this;
    }

    public BreadcrumbInput getParentInputExcludingGenerates() {
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(this.project);
        if (elManager == null) {
            return null;
        }
        ArrayList<BreadcrumbSegment> inputSegments = new ArrayList<BreadcrumbSegment>(this.inputSegments);
        if (inputSegments.size() < 2) {
            return null;
        }
        IRfBreadcrumbElement segmentDesign = null;
        int index = 0;
        IELMemory memory = elManager.getMemory();
        int i = inputSegments.size() - 2;
        while (i >= 0) {
            IRfBreadcrumbElement element = this.getSegment(i);
            if (!(element instanceof ElementPath)) {
                return null;
            }
            if (!memory.isGenerateBlock(((ElementPath)element).toElaborationForm())) {
                segmentDesign = element;
                index = i;
                break;
            }
            --i;
        }
        if (segmentDesign == null) {
            return null;
        }
        List<BreadcrumbSegment> newBreadcrumbSegments = inputSegments.subList(0, index + 1);
        return new BreadcrumbInput(this.project, newBreadcrumbSegments, this.bcSerializator);
    }

    public IBreadcrumbSerializer getBcSerializator() {
        return this.bcSerializator;
    }

    public String toString() {
        if (this == REMOVE_BREADCRUMB) {
            return "REMOVE_BREADCRUMB";
        }
        if (this == NO_ELAB_ELEM_AT_CURSOR) {
            return "NO_ELAB_ELEM_AT_CURSOR";
        }
        if (this == NO_ELAB_ELEM_IN_FILE) {
            return "NO_ELAB_ELEM_IN_FILE";
        }
        if (this == CLEAR) {
            return "CLEAR";
        }
        if (this.getElementPath() == null) {
            return "NO SEGMENTS";
        }
        return this.getElementPath().toString();
    }

    public boolean validate() {
        if (this.inputSegments == null || this.inputSegments.isEmpty()) {
            return false;
        }
        int i = this.inputSegments.size() - 1;
        while (i >= 1) {
            BreadcrumbSegment breadcrumbSegment = this.inputSegments.get(i);
            if (breadcrumbSegment == null) {
                return false;
            }
            IRfBreadcrumbElement bcElement = breadcrumbSegment.getElement();
            if (bcElement instanceof ElementPath) {
                return this.validateBCElementPath(bcElement);
            }
            if (!(bcElement instanceof IRfNamedElement)) {
                return false;
            }
            IRfScopeElement enclosingScope = null;
            if (bcElement instanceof IRfBlockElement && (((IRfBlockElement)bcElement).getKind() == IRfNamedElement.ElementKind.VLOG_GENERATE || ((IRfBlockElement)bcElement).getKind() == IRfNamedElement.ElementKind.VHDL_BLOCK)) {
                enclosingScope = bcElement.getEnclosingScope();
            } else if (bcElement instanceof IRfInstanceElement) {
                IRfScopeElement iRfScopeElement = enclosingScope = ((IRfInstanceElement)bcElement).isInstanceToBind() ? ((IRfInstanceElement)bcElement).getBindInstanceScope() : bcElement.getEnclosingScope();
            }
            if (!(enclosingScope instanceof IRfDesignElement)) {
                return false;
            }
            BreadcrumbSegment parentSegment = this.inputSegments.get(i - 1);
            IRfBreadcrumbElement parent = parentSegment.getElement();
            if (!(parent instanceof IRfNamedElement)) {
                return false;
            }
            IRfDesignElement designParent = DesignUtils.getDesign(DesignUtils.DesignRequest.of((IRfNamedElement)parent, this.getElementPathUpTo(parent), null, true, null));
            if (enclosingScope != designParent) {
                return false;
            }
            --i;
        }
        if (this.inputSegments.isEmpty()) {
            return true;
        }
        BreadcrumbSegment breadcrumbSegment = this.inputSegments.get(0);
        if (breadcrumbSegment == null) {
            return false;
        }
        IRfBreadcrumbElement bcElement = breadcrumbSegment.getElement();
        if (bcElement instanceof ElementPath) {
            return this.validateBCElementPath(bcElement);
        }
        IRfBreadcrumbElement breadcrumbElement = breadcrumbSegment.getElement();
        return breadcrumbElement instanceof IRfNamedElement;
    }

    private boolean validateBCElementPath(IRfBreadcrumbElement bcElement) {
        IELMemory elMemory = RfMixedLangManager.getInstance().getELMemory(this.project);
        if (elMemory == null) {
            return false;
        }
        ELInstance instance = elMemory.instanceFor(((ElementPath)bcElement).toElaborationForm());
        return instance != null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.bcSerializator == null ? 0 : this.bcSerializator.hashCode());
        List<BreadcrumbSegment> inputSegments = this.getInputSegments();
        result = 31 * result + (inputSegments == null ? 0 : inputSegments.hashCode());
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BreadcrumbInput other = (BreadcrumbInput)obj;
        if (this.bcSerializator == null ? other.bcSerializator != null : !this.bcSerializator.equals(other.bcSerializator)) {
            return false;
        }
        if (this.inputSegments == null ? other.inputSegments != null : !this.inputSegments.equals(other.inputSegments)) {
            return false;
        }
        return !(this.project == null ? other.project != null : !this.project.equals((Object)other.project));
    }

    public String testGetInstancePath() {
        ElementPath instancePath = this.getElementPath();
        if (instancePath == null || instancePath.isEmpty()) {
            return "";
        }
        return instancePath.toElaborationForm().toString();
    }
}

