/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.breadcrumb;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumMap;
import java.util.Map;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSerializerList;
import ro.amiq.dvt.ui.editor.breadcrumb.IBreadcrumbSerializer;

public class BreadcrumbSerializerRepo {
    private static Map<LanguageKind, BreadcrumbSerializerList> breadcrumbSerializerRepoMap = new EnumMap<LanguageKind, BreadcrumbSerializerList>(LanguageKind.class);

    public static void addSerializer(LanguageKind langKind, IBreadcrumbSerializer serializer) {
        BreadcrumbSerializerList list = breadcrumbSerializerRepoMap.get((Object)langKind);
        if (list == null) {
            list = new BreadcrumbSerializerList();
        }
        list.addSerializer(serializer);
        breadcrumbSerializerRepoMap.put(langKind, list);
    }

    public static IBreadcrumbSerializer getSerializer(LanguageKind langKind, Class<? extends IBreadcrumbSerializer> clazz) {
        BreadcrumbSerializerList breadcrumbSerializatorList = breadcrumbSerializerRepoMap.get((Object)langKind);
        if (breadcrumbSerializatorList == null) {
            return BreadcrumbSerializerRepo.createSerializerAndAddToRepo(langKind, clazz);
        }
        IBreadcrumbSerializer serializer = breadcrumbSerializatorList.getSerializer(clazz);
        if (serializer == null) {
            serializer = BreadcrumbSerializerRepo.createSerializerAndAddToRepo(langKind, clazz);
        }
        return serializer;
    }

    private static IBreadcrumbSerializer createSerializerAndAddToRepo(LanguageKind langKind, Class<? extends IBreadcrumbSerializer> clazz) {
        try {
            Constructor<? extends IBreadcrumbSerializer> ctor = clazz.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            IBreadcrumbSerializer serializer = ctor.newInstance(new Object[0]);
            BreadcrumbSerializerRepo.addSerializer(langKind, serializer);
            return serializer;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }
}

