/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.breadcrumb;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.IDVTNotificationsHost;
import ro.amiq.dvt.ui.actions.breadcrumb.BreadcrumbMode;
import ro.amiq.dvt.ui.actions.breadcrumb.BreadcrumbStateHandler;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.IHostEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.ThickBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;

public interface IDVTBreadcrumbHost
extends IDVTNotificationsHost,
IHostEditor {
    default public int getCursor() {
        return -1;
    }

    default public AbstractBreadcrumbUtils getBreadcrumbUtils(Class<?> breadcrumbType) {
        return null;
    }

    default public void updateBreadcrumb(Class<?> breadcrumbType, AbstractBreadcrumbConfiguration configuration) {
        try {
            if (!this.isValidLangForBreadcrumb(breadcrumbType)) {
                return;
            }
            if (breadcrumbType == DHBreadcrumbViewer.class && DesignPathManager.getInstance().isEligible(this)) {
                return;
            }
            AbstractBreadcrumbUtils breadcrumbUtils = this.getBreadcrumbUtils(breadcrumbType);
            if (breadcrumbUtils == null) {
                return;
            }
            AbstractBreadcrumbViewer breadcrumbViewer = this.getBreadcrumbViewer(breadcrumbType);
            int updateDelay = 0;
            boolean enabled = BreadcrumbStateHandler.isBreadcrumbEnabled();
            if (breadcrumbType == DHBreadcrumbViewer.class) {
                boolean bl = enabled = enabled && BreadcrumbMode.DESIGN.isEnabled();
                if (!enabled && this.hasBreadcrumb(breadcrumbType) && breadcrumbViewer != null) {
                    breadcrumbViewer.hideBreadcrumb();
                }
            }
            if (breadcrumbType == VHBreadcrumbViewer.class) {
                boolean bl = enabled = enabled && BreadcrumbMode.VERIFICATION.isEnabled();
                if (!enabled && this.hasBreadcrumb(breadcrumbType) && breadcrumbViewer != null) {
                    breadcrumbViewer.hideBreadcrumb();
                }
                if (!((VHBreadcrumbUtils)breadcrumbUtils).initializeVHBCModel(this.getProject())) {
                    if (!(breadcrumbViewer instanceof ThickBreadcrumbViewer)) {
                        this.createBreadcrumb(breadcrumbType, configuration);
                    } else {
                        ((ThickBreadcrumbViewer)breadcrumbViewer).changeReadOnlyState();
                    }
                    return;
                }
            }
            if (breadcrumbType == ScopeBreadcrumbViewer.class) {
                boolean bl = enabled = enabled && BreadcrumbMode.SCOPE.isEnabled();
                if (!enabled && this.hasBreadcrumb(breadcrumbType) && breadcrumbViewer != null) {
                    breadcrumbViewer.hideBreadcrumb();
                    return;
                }
                if (this.isCachedScopeBCValid(configuration)) {
                    return;
                }
                if (enabled) {
                    updateDelay = 300;
                }
            }
            if (breadcrumbType == FSBreadcrumbViewer.class) {
                boolean bl = enabled = enabled && BreadcrumbMode.FILESYSTEM.isEnabled();
                if (!enabled && this.hasBreadcrumb(breadcrumbType) && breadcrumbViewer != null) {
                    breadcrumbViewer.hideBreadcrumb();
                }
            }
            if (breadcrumbViewer == null || enabled && !this.hasBreadcrumb(breadcrumbType)) {
                this.createBreadcrumb(breadcrumbType, configuration);
            }
            if ((breadcrumbViewer = this.getBreadcrumbViewer(breadcrumbType)) == null) {
                return;
            }
            if (configuration != null) {
                configuration.setUpdateDelay(updateDelay);
            }
            breadcrumbViewer.updateNonGUIPart(breadcrumbType, configuration, enabled);
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
        }
    }

    default public boolean isCachedScopeBCValid(AbstractBreadcrumbConfiguration configuration) throws BadLocationException {
        if (!(this instanceof DVTEditor)) {
            return false;
        }
        if (!(configuration instanceof ScopeBreadcrumbConfiguration)) {
            return false;
        }
        if (((ScopeBreadcrumbConfiguration)configuration).shouldOverrideCache()) {
            return false;
        }
        AbstractBreadcrumbViewer breadcrumbViewer = this.getBreadcrumbViewer(ScopeBreadcrumbViewer.class);
        if (breadcrumbViewer == null || breadcrumbViewer.isDisposed()) {
            return false;
        }
        IDocument document = ((DVTEditor)this).getDocument();
        if (document == null) {
            return false;
        }
        int offset = ((ScopeBreadcrumbConfiguration)configuration).getConfigOffset();
        int line = document.getLineOfOffset(offset);
        if (((DVTEditor)this).getScopeBCLineCache() == line) {
            return true;
        }
        ((DVTEditor)this).setScopeBCLineCache(line);
        return false;
    }

    default public void updateBreadcrumbLabels(Class<?> breadcrumbType) {
        try {
            if (!this.isValidLangForBreadcrumb(breadcrumbType)) {
                return;
            }
            if (breadcrumbType == DHBreadcrumbViewer.class && !BreadcrumbMode.DESIGN.isEnabled()) {
                return;
            }
            if (breadcrumbType == VHBreadcrumbViewer.class && !BreadcrumbMode.VERIFICATION.isEnabled()) {
                return;
            }
            if (breadcrumbType == ScopeBreadcrumbViewer.class && !BreadcrumbMode.SCOPE.isEnabled()) {
                return;
            }
            AbstractBreadcrumbViewer breadcrumbViewer = this.getBreadcrumbViewer(breadcrumbType);
            if (breadcrumbViewer == null) {
                return;
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> breadcrumbViewer.refresh());
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
        }
    }

    default public boolean isValidLangForBreadcrumb(Class<?> breadcrumbType) {
        try {
            if (breadcrumbType == DHBreadcrumbViewer.class) {
                return EnumSet.of(LanguageKind.VLOG, LanguageKind.VHDL).contains((Object)this.getLanguageKind());
            }
            if (breadcrumbType == VHBreadcrumbViewer.class) {
                return EnumSet.of(LanguageKind.VLOG, LanguageKind.E).contains((Object)this.getLanguageKind());
            }
            if (breadcrumbType == ScopeBreadcrumbViewer.class) {
                return EnumSet.of(LanguageKind.VLOG, LanguageKind.VHDL, LanguageKind.E, LanguageKind.PSS, LanguageKind.SLN).contains((Object)this.getLanguageKind());
            }
            return breadcrumbType == FSBreadcrumbViewer.class;
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
            return false;
        }
    }

    default public boolean shouldHaveBreadcrumb() {
        return this.isValidLangForBreadcrumb(DHBreadcrumbViewer.class) || this.isValidLangForBreadcrumb(ScopeBreadcrumbViewer.class) || this.isValidLangForBreadcrumb(VHBreadcrumbViewer.class);
    }

    default public boolean hasBreadcrumb(Class<?> breadcrumbType) {
        try {
            return this.getBreadcrumbViewer(breadcrumbType) != null;
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
            return false;
        }
    }

    default public boolean hasBreadcrumbViewer(Class<?> ... breadcrumbTypes) {
        try {
            return this.getBreadcrumbViewers(breadcrumbTypes) != null;
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
            return false;
        }
    }

    default public void hideBreadcrumb(Class<?> breadcrumbType) {
        try {
            if (!this.isValidLangForBreadcrumb(breadcrumbType)) {
                return;
            }
            AbstractBreadcrumbViewer breadcrumbViewer = this.getBreadcrumbViewer(breadcrumbType);
            if (breadcrumbViewer == null || breadcrumbViewer.isDisposed()) {
                return;
            }
            breadcrumbViewer.hideBreadcrumb();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    default public List<AbstractBreadcrumbViewer> getBreadcrumbViewers(Class<?> ... breadcrumbTypes) {
        ArrayList<AbstractBreadcrumbViewer> breadcrumbs = new ArrayList<AbstractBreadcrumbViewer>();
        int i = 0;
        while (i < breadcrumbTypes.length) {
            AbstractBreadcrumbViewer breadcrumbViewer = this.getBreadcrumbViewer(breadcrumbTypes[i]);
            if (breadcrumbViewer != null) {
                breadcrumbs.add(breadcrumbViewer);
            }
            ++i;
        }
        return breadcrumbs.isEmpty() ? null : breadcrumbs;
    }

    default public List<AbstractBreadcrumbViewer> getBreadcrumbViewers() {
        ArrayList<AbstractBreadcrumbViewer> breadcrumbs = new ArrayList<AbstractBreadcrumbViewer>();
        AbstractBreadcrumbViewer breadcrumbViewer = this.getBreadcrumbViewer(DHBreadcrumbViewer.class);
        if (breadcrumbViewer != null) {
            breadcrumbs.add(breadcrumbViewer);
        }
        if ((breadcrumbViewer = this.getBreadcrumbViewer(VHBreadcrumbViewer.class)) != null) {
            breadcrumbs.add(breadcrumbViewer);
        }
        if ((breadcrumbViewer = this.getBreadcrumbViewer(ScopeBreadcrumbViewer.class)) != null) {
            breadcrumbs.add(breadcrumbViewer);
        }
        return breadcrumbs;
    }

    public LanguageKind getLanguageKind();

    public AbstractBreadcrumbViewer getBreadcrumbViewer(Class<?> var1);

    public void createBreadcrumb(Class<?> var1, AbstractBreadcrumbConfiguration var2);

    public BreadcrumbInput getBCCache(Class<?> var1);

    public void setBCCache(BreadcrumbInput var1, Class<?> var2);
}

