/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.breadcrumb;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.design.DBlockDiagram;
import ro.amiq.dvt.diagrams.design.DFlowDiagram;
import ro.amiq.dvt.diagrams.design.DSchematicDiagram;
import ro.amiq.dvt.diagrams.design.DTopPathDiagram;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorFactory;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorInput;
import ro.amiq.dvt.diagrams.editor.DiagramBreadcrumbUtils;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.draw.DCanvas;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.breadcrumb.SOIDialog;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTDHLabelProvider;
import ro.amiq.dvt.utils.ElementListSelectionDialog;
import ro.amiq.dvt.utils.FilteredList;
import ro.amiq.dvt.utils.StringMatcher;

public class SelectOtherDHInstanceDialog
extends SOIDialog {
    private static final String TITLE = "Select Instance Path";
    private static final String MESSAGE = "Select an instance path for the element under the cursor.";
    private IRfDesignElement cursorElement;
    private DVTDHLabelProvider dvtDHLabelProvider = new DVTDHLabelProvider();
    private IDVTBreadcrumbHost activeEditor;
    private final DVTBaseLabelProvider labelProvider = new DVTBaseLabelProvider(){

        @Override
        public String getText(Object path) {
            if (!(path instanceof ElementPath)) {
                return "";
            }
            return path.toString();
        }

        @Override
        public Image getImage(Object element) {
            if (!(element instanceof ElementPath)) {
                return null;
            }
            return SelectOtherDHInstanceDialog.this.dvtDHLabelProvider.getImage(TreePathUtils.computeTreePathFromBreadrumbElementPath((ElementPath)element, SelectOtherDHInstanceDialog.this.activeEditor.getProject()));
        }
    };

    public SelectOtherDHInstanceDialog(IDVTBreadcrumbHost editor, IRfDesignElement element) {
        this.cursorElement = element;
        this.dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.labelProvider){

            public void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText(SelectOtherDHInstanceDialog.TITLE);
            }

            @Override
            protected FilteredList createFilteredList(Composite parent) {
                FilteredList list = super.createFilteredList(parent);
                list.setFilterMatcher(new FilteredList.FilterMatcher(){
                    private StringMatcher localMatcher;

                    @Override
                    public void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
                        this.localMatcher = ViewsUtils.createCamelCaseOrRegexMatcher(pattern, ignoreCase, ignoreWildCards);
                    }

                    @Override
                    public boolean match(Object element) {
                        return ViewsUtils.matchCamelCaseOrRegex(this.localMatcher, fFilteredList.getLabelProvider().getText(element));
                    }
                });
                return list;
            }
        };
        this.dialog.setAutoResizeable(true);
        this.dialog.setTitle(TITLE);
        this.dialog.setMessage(MESSAGE);
        this.dialog.setMultipleSelection(false);
        this.dialog.setHelpAvailable(false);
        this.activeEditor = editor;
    }

    @Override
    public void open(int instanceIndex) {
        try {
            ELManager manager = RfMixedLangManager.getInstance().getELManager(this.activeEditor.getProject());
            if (manager == null) {
                return;
            }
            IELMemory memory = manager.getMemory();
            if (DesignPathManager.getInstance().isEligible(this.activeEditor)) {
                if (this.cursorElement == null) {
                    ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_UPDATE);
                    ObjectionManager.getInstance().clear(Objection.DESIGN_BC);
                    return;
                }
                List<ElementPath> paths = memory.getInstancePathsFor(this.cursorElement, Integer.MAX_VALUE);
                this.updatePath(null, instanceIndex, paths);
                return;
            }
            BreadcrumbInput breadcrumbInput = AbstractBreadcrumbUtils.getBreadcrumbInput(DHBreadcrumbViewer.class, this.activeEditor);
            if (breadcrumbInput == null) {
                return;
            }
            IRfDesignElement designElement = breadcrumbInput.getLeafDesignElement();
            if (designElement == null) {
                return;
            }
            List<ElementPath> instancePathsFor = memory.getInstancePathsFor(designElement, Integer.MAX_VALUE);
            this.updatePath(breadcrumbInput, instanceIndex, instancePathsFor);
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
        }
    }

    private void updatePath(BreadcrumbInput breadcrumbInput, int instanceIndex, List<ElementPath> paths) {
        if (paths == null || paths.isEmpty()) {
            ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_UPDATE);
            ObjectionManager.getInstance().clear(Objection.DESIGN_BC);
            return;
        }
        Object result = null;
        if (paths.size() > 1) {
            if (TestHelper.isTestMode()) {
                if (instanceIndex == -1) {
                    return;
                }
                result = paths.get(instanceIndex);
            } else {
                this.dialog.setElements(paths.toArray());
                if (this.dialog.open() == 0) {
                    result = this.dialog.getFirstResult();
                }
            }
        } else {
            result = paths.get(0);
        }
        if (!(result instanceof ElementPath)) {
            ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_UPDATE);
            ObjectionManager.getInstance().clear(Objection.DESIGN_BC);
            return;
        }
        if (DesignPathManager.getInstance().isEligible(this.activeEditor)) {
            DesignPathManager.getInstance().updateFor((DVTEditor)this.activeEditor, (ElementPath)result);
            return;
        }
        this.updateBCPath(breadcrumbInput, (ElementPath)result);
        this.dvtDHLabelProvider = null;
    }

    private void updateBCPath(final BreadcrumbInput breadcrumbInput, final ElementPath selectedInstance) {
        WorkspaceJob job = new WorkspaceJob(TITLE){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("", -1);
                IProject project = SelectOtherDHInstanceDialog.this.activeEditor.getProject();
                if (project == null) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                ELManager elManager = RfMixedLangManager.getInstance().getELManager(project);
                if (elManager == null) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                if (!(SelectOtherDHInstanceDialog.this.activeEditor instanceof DDiagramEditor) || breadcrumbInput == null) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                List<BreadcrumbSegment> breadcrumbSegments = DHBreadcrumbUtils.toBreadcrumbSegments(selectedInstance, true);
                breadcrumbInput.reset(breadcrumbSegments);
                DCanvas canvas = ((DDiagramEditor)SelectOtherDHInstanceDialog.this.activeEditor).getCanvas();
                if (canvas == null) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                ELInstance instanceFor = elManager.getMemory().instanceFor(selectedInstance.toElaborationForm());
                if (instanceFor == null) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                IRfInstanceElement instance = instanceFor.getDescription();
                if (instance == null) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                DDiagramEditorInput diagramInput = ((DDiagramEditor)SelectOtherDHInstanceDialog.this.activeEditor).getInput();
                if (diagramInput == null) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                DDiagram diagram = diagramInput.getDiagram();
                if (!(diagram instanceof DTopPathDiagram)) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                NLConfig config = new NLConfig(DDesignEditorFactory.getInstance().getDefaultNLConfiguration());
                config.setBreadcrumbInput(new BreadcrumbInput(project, breadcrumbSegments, DiagramBreadcrumbUtils.getInstance().getBreadcrumbSerializer()));
                if (diagram instanceof DBlockDiagram) {
                    canvas.getDisplay().syncExec(() -> DDesignEditorFactory.getInstance().newBlockDiagram(instance, config, breadcrumbInput.getElementPath()).openEditor());
                }
                if (diagram instanceof DFlowDiagram) {
                    canvas.getDisplay().syncExec(() -> DDesignEditorFactory.getInstance().newFlowDiagram(instance, config, breadcrumbInput.getElementPath()).openEditor());
                }
                if (diagram instanceof DSchematicDiagram) {
                    canvas.getDisplay().syncExec(() -> DDesignEditorFactory.getInstance().newSchematicDiagram(instance, config, breadcrumbInput.getElementPath()).openEditor());
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(false);
        job.setRule((ISchedulingRule)this.activeEditor.getProject());
        job.schedule(0L);
        try {
            job.join();
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.activeEditor.setBCCache(breadcrumbInput, DHBreadcrumbViewer.class);
        this.activeEditor.getBreadcrumbViewer(DHBreadcrumbViewer.class).updateNonGUIPart(DHBreadcrumbViewer.class, null, true);
    }
}

