/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.breadcrumb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.diagrams.ch.CHDiagram;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.draw.DCanvas;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.breadcrumb.SOIDialog;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbInstancePath;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbInstancePathsResult;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.ui.views.BasicElementWrapper;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHLabelProvider;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyView;
import ro.amiq.dvt.utils.ElementListSelectionDialog;
import ro.amiq.dvt.utils.FilteredList;
import ro.amiq.dvt.utils.StringMatcher;

public class SelectOtherVHInstanceDialog
extends SOIDialog {
    public static final String TITLE = "Select Breadcrumb Instance";
    private IDVTBreadcrumbHost activeEditor;
    private IRfVHBreadcrumbElement vhTop;
    private VHBreadcrumbUtils breadcrumbUtils;
    private final Comparator<VHBreadcrumbInstancePath> VH_TOP_COMPARATOR = (o1, o2) -> {
        boolean o1isVhTop = this.isVhViewTop((VHBreadcrumbInstancePath)o1);
        boolean o2isVhTop = this.isVhViewTop((VHBreadcrumbInstancePath)o2);
        if (o1isVhTop && o2isVhTop) {
            return 0;
        }
        if (o1isVhTop) {
            return -1;
        }
        if (o2isVhTop) {
            return 1;
        }
        return 0;
    };
    private final DVTBaseLabelProvider labelProvider = new DVTBaseLabelProvider(){

        @Override
        public String getText(Object element) {
            List<IRfVHBreadcrumbElement> path;
            if (!(element instanceof VHBreadcrumbInstancePath)) {
                return super.getText(element);
            }
            VHBreadcrumbInstancePath instancePath = (VHBreadcrumbInstancePath)element;
            IRfVHBreadcrumbElement top = instancePath.getTop();
            IVHLabelProvider vhLabelProvider = SelectOtherVHInstanceDialog.this.breadcrumbUtils.getVHLabelProvider();
            StringBuilder result = new StringBuilder();
            if (!(top instanceof CHUVMComponent) && !(top instanceof IXXVMComponent)) {
                result.append(vhLabelProvider.getText(new BasicElementWrapper(top)));
            }
            if (top instanceof IXXVMComponent) {
                result.append(((IXXVMComponent)top).getSVType());
            }
            if ((path = instancePath.getPath()) == null) {
                return result.toString();
            }
            for (IRfVHBreadcrumbElement bcElem : path) {
                result.append(".");
                if (bcElem instanceof IXXVMComponent) {
                    result.append(BreadcrumbInput.getXXVMName((IXXVMComponent)bcElem));
                    continue;
                }
                result.append(bcElem.getName());
            }
            if (top instanceof CHUVMComponent) {
                result.deleteCharAt(0);
            }
            if (SelectOtherVHInstanceDialog.this.isVhViewTop(instancePath)) {
                result.append(" [VH View top]");
            }
            return result.toString();
        }

        @Override
        public Image getImage(Object element) {
            IVHLabelProvider vhLabelProvider;
            if (!(element instanceof VHBreadcrumbInstancePath)) {
                return super.getImage(element);
            }
            VHBreadcrumbInstancePath instancePath = (VHBreadcrumbInstancePath)element;
            IRfVHBreadcrumbElement top = instancePath.getTop();
            if (top instanceof CHUVMComponent) {
                return SelectOtherVHInstanceDialog.this.breadcrumbUtils.getCHGDiagramImage((CHUVMComponent)top, true);
            }
            IVHLabelProvider iVHLabelProvider = vhLabelProvider = top instanceof IXXVMComponent ? SelectOtherVHInstanceDialog.this.breadcrumbUtils.getXxvmLabelProvider() : SelectOtherVHInstanceDialog.this.breadcrumbUtils.getVHLabelProvider();
            if (vhLabelProvider == null) {
                return null;
            }
            List<IRfVHBreadcrumbElement> path = instancePath.getPath();
            if (path.isEmpty()) {
                return vhLabelProvider.getImage(new BasicElementWrapper(instancePath.getTop()));
            }
            BasicElementWrapper elementWrapper = new BasicElementWrapper(path.get(0));
            return vhLabelProvider.getImage(elementWrapper);
        }
    };

    private boolean isVhViewTop(VHBreadcrumbInstancePath instancePath) {
        if (this.vhTop == null) {
            return false;
        }
        return this.vhTop.getNamedElement() == instancePath.getTop().getNamedElement();
    }

    public SelectOtherVHInstanceDialog(IDVTBreadcrumbHost editor) {
        this.breadcrumbUtils = (VHBreadcrumbUtils)editor.getBreadcrumbUtils(VHBreadcrumbViewer.class);
        if (!(editor instanceof CHDiagram)) {
            this.computeVHTop();
        }
        this.dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.labelProvider){

            public void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText(SelectOtherVHInstanceDialog.TITLE);
            }

            @Override
            protected FilteredList createFilteredList(Composite parent) {
                FilteredList list = super.createFilteredList(parent);
                list.setFilterMatcher(new FilteredList.FilterMatcher(){
                    private StringMatcher localMatcher;

                    @Override
                    public void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
                        this.localMatcher = ViewsUtils.createCamelCaseOrRegexMatcher(pattern, ignoreCase, ignoreWildCards);
                    }

                    @Override
                    public boolean match(Object element) {
                        return ViewsUtils.matchCamelCaseOrRegex(this.localMatcher, fFilteredList.getLabelProvider().getText(element));
                    }
                });
                return list;
            }
        };
        String message = "Select an instance to be displayed in the breadcrumb";
        this.dialog.setAutoResizeable(true);
        this.dialog.setTitle(TITLE);
        this.dialog.setMessage(message);
        this.dialog.setMultipleSelection(false);
        this.dialog.setHelpAvailable(false);
        this.activeEditor = editor;
    }

    private void computeVHTop() {
        IWorkbenchWindow activeWorkbenchWindow = Utils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        VerificationHierarchyView view = (VerificationHierarchyView)activePage.findView("ro.amiq.dvt.ui.views.VerificationHierarchyView");
        if (view == null) {
            return;
        }
        ArrayList roots = (ArrayList)view.getRoot();
        if (roots == null || roots.isEmpty()) {
            return;
        }
        Object rootWrapper = roots.get(0);
        if (!(rootWrapper instanceof IDVTElementWrapper)) {
            return;
        }
        this.vhTop = ((IDVTElementWrapper)rootWrapper).getRfElement(IRfVHBreadcrumbElement.class);
    }

    @Override
    public void open(final int instanceIndex) {
        try {
            Job computeInstances = new Job("Computing Other Instances..."){

                protected IStatus run(IProgressMonitor monitor) {
                    BreadcrumbInput breadcrumbInput = AbstractBreadcrumbUtils.getBreadcrumbInput(VHBreadcrumbViewer.class, SelectOtherVHInstanceDialog.this.activeEditor);
                    if (breadcrumbInput == null) {
                        return Status.CANCEL_STATUS;
                    }
                    IRfBreadcrumbElement leafElement = breadcrumbInput.getLeafSegment();
                    if (!(leafElement instanceof IRfVHBreadcrumbElement)) {
                        return Status.CANCEL_STATUS;
                    }
                    VHBreadcrumbInstancePathsResult computeInstancePathsResult = SelectOtherVHInstanceDialog.this.breadcrumbUtils.computeVHBreadcrumbInstancePaths(breadcrumbInput.getRootElement(), (IRfVHBreadcrumbElement)leafElement, Integer.MAX_VALUE, monitor);
                    if (computeInstancePathsResult == null || computeInstancePathsResult.instancePaths == null || computeInstancePathsResult.instancePaths.size() <= 1 || SelectOtherVHInstanceDialog.this.dialog == null) {
                        return Status.CANCEL_STATUS;
                    }
                    VHBreadcrumbInstancePath[] input = computeInstancePathsResult.instancePaths.toArray(new VHBreadcrumbInstancePath[computeInstancePathsResult.instancePaths.size()]);
                    Arrays.sort(input, SelectOtherVHInstanceDialog.this.VH_TOP_COMPARATOR);
                    Runnable runnable = () -> SelectOtherVHInstanceDialog.this.populateDialog(input, instanceIndex);
                    if (TestHelper.isTestMode()) {
                        Display.getDefault().syncExec(runnable);
                    } else {
                        Display.getDefault().asyncExec(runnable);
                    }
                    return Status.OK_STATUS;
                }
            };
            if (TestHelper.isTestMode()) {
                computeInstances.schedule(0L);
                computeInstances.join();
            } else {
                computeInstances.schedule();
            }
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void populateDialog(VHBreadcrumbInstancePath[] input, int instanceIndex) {
        try {
            Object result = null;
            if (TestHelper.isTestMode()) {
                if (instanceIndex == -1) {
                    return;
                }
                result = input[instanceIndex];
            } else {
                this.dialog.setElements(input);
                if (this.dialog.open() == 0) {
                    result = this.dialog.getFirstResult();
                }
            }
            if (!(result instanceof VHBreadcrumbInstancePath)) {
                return;
            }
            this.setBreadcrumb((VHBreadcrumbInstancePath)result);
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
        }
    }

    private void setBreadcrumb(final VHBreadcrumbInstancePath selectedInstance) {
        WorkspaceJob job = new WorkspaceJob("Selecting Other Verification Instance..."){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("", -1);
                if (!SelectOtherVHInstanceDialog.this.activeEditor.hasBreadcrumb(VHBreadcrumbViewer.class)) {
                    return Status.CANCEL_STATUS;
                }
                AbstractBreadcrumbViewer breadcrumbViewer = SelectOtherVHInstanceDialog.this.activeEditor.getBreadcrumbViewer(VHBreadcrumbViewer.class);
                if (!(breadcrumbViewer instanceof VHBreadcrumbViewer)) {
                    return Status.CANCEL_STATUS;
                }
                BreadcrumbInput input = breadcrumbViewer.getInput();
                if (input == null) {
                    return Status.CANCEL_STATUS;
                }
                IProject project = SelectOtherVHInstanceDialog.this.activeEditor.getProject();
                if (project == null) {
                    return Status.CANCEL_STATUS;
                }
                BreadcrumbInput newInput = VHBreadcrumbUtils.toBreadcrumbInput(project, selectedInstance, SelectOtherVHInstanceDialog.this.activeEditor.getBreadcrumbUtils(VHBreadcrumbViewer.class));
                List<BreadcrumbSegment> segments = newInput.getInputSegments();
                input.reset(segments);
                if (SelectOtherVHInstanceDialog.this.activeEditor instanceof DDiagramEditor) {
                    DCanvas canvas = ((DDiagramEditor)SelectOtherVHInstanceDialog.this.activeEditor).getCanvas();
                    if (canvas == null) {
                        return Status.CANCEL_STATUS;
                    }
                    IRfVHBreadcrumbElement instance = selectedInstance.getLeaf();
                    if (instance == null) {
                        return Status.CANCEL_STATUS;
                    }
                    canvas.getDisplay().syncExec(() -> SelectOtherVHInstanceDialog.this.breadcrumbUtils.openElement(SelectOtherVHInstanceDialog.this.activeEditor, project, instance, newInput));
                }
                ObjectionManager.getInstance().clear(Objection.VERIFICATION_BC);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(false);
        job.setRule((ISchedulingRule)this.activeEditor.getProject());
        job.schedule(0L);
        try {
            job.join();
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        AbstractBreadcrumbViewer breadcrumbViewer = this.activeEditor.getBreadcrumbViewer(VHBreadcrumbViewer.class);
        if (!(breadcrumbViewer instanceof VHBreadcrumbViewer)) {
            return;
        }
        this.activeEditor.setBCCache(breadcrumbViewer.getInput(), VHBreadcrumbViewer.class);
        ((VHBreadcrumbViewer)breadcrumbViewer).updateNonGUIPart(VHBreadcrumbViewer.class, null, true);
    }
}

