/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.breadcrumb;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItem;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItemDetails;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class SlimBreadcrumbItemDetails
extends AbstractBreadcrumbItemDetails {
    protected Label elementLabel;
    private MouseListener mouseListener;
    private MenuDetectListener menuListener;

    public SlimBreadcrumbItemDetails(AbstractBreadcrumbItem parent, Composite parentContainer) {
        super(parent, parentContainer);
        GridData data = new GridData(1, 0x1000000, false, false);
        this.detailsComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        this.detailsComposite.setLayout((Layout)layout);
        this.themeListener = e -> {
            if (e.getProperty().equals("ro.amiq.dvt.ui.editor.breadcrumb.backgroundColor")) {
                DVTColorUtil.INSTANCE.setBackground((Control)this.detailsComposite, DVTColorUtil.INSTANCE.getColor((RGB)e.getNewValue()));
                DVTColorUtil.INSTANCE.setBackground((Control)this.elementLabel, DVTColorUtil.INSTANCE.getColor((RGB)e.getNewValue()));
            }
        };
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.themeListener);
        Color backgroundColor = JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.editor.breadcrumb.backgroundColor");
        DVTColorUtil.INSTANCE.setBackground((Control)this.detailsComposite, backgroundColor);
        this.elementLabel = this.createElementLabel();
        this.detailsComposite.layout();
    }

    protected Label createElementLabel() {
        Label label = new Label(this.detailsComposite, 0);
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        label.setLayoutData((Object)gridData);
        this.mouseListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                AbstractBreadcrumbViewer viewer = SlimBreadcrumbItemDetails.this.item.getViewer();
                AbstractBreadcrumbItem grandParent = null;
                int index = viewer.getIndexOfItem(SlimBreadcrumbItemDetails.this.item);
                if (index <= 0) {
                    return;
                }
                grandParent = SlimBreadcrumbItemDetails.this.item.getViewer().getItem(index - 1);
                Shell shell = grandParent.getDropDownShell();
                if (shell != null || e.button != 1 || e.stateMask != 0) {
                    return;
                }
                if (shell == null && grandParent != null) {
                    grandParent.openDropDownMenu();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        label.addMouseListener(this.mouseListener);
        this.menuListener = e -> {
            AbstractBreadcrumbItem item = this.item;
            if (item == null) {
                return;
            }
            AbstractBreadcrumbViewer viewer = item.getViewer();
            viewer.selectItem(item, false);
            viewer.fireMenuDetect(e);
        };
        label.addMenuDetectListener(this.menuListener);
        return label;
    }

    @Override
    public void setForeground(Color color) {
        if (this.elementLabel == null) {
            return;
        }
        DVTColorUtil.INSTANCE.setForeground((Control)this.elementLabel, color);
    }

    @Override
    public void setBackground(Color color) {
        if (this.elementLabel == null) {
            return;
        }
        DVTColorUtil.INSTANCE.setBackground((Control)this.elementLabel, color);
    }

    @Override
    public void setFocus(boolean focus) {
        if (focus == this.hasFocus) {
            return;
        }
        this.hasFocus = focus;
        if (this.hasFocus) {
            this.detailsComposite.setFocus();
        }
    }

    @Override
    public void setTextVisible(boolean enabled) {
        if (this.isTextVisible == enabled || this.elementLabel == null) {
            return;
        }
        this.isTextVisible = enabled;
        GridData data = (GridData)this.elementLabel.getLayoutData();
        data.exclude = !enabled;
        this.elementLabel.setVisible(enabled);
        this.elementLabel.update();
    }

    @Override
    public int getWidth() {
        int result = 0;
        if (this.elementLabel != null && this.elementLabel.isVisible()) {
            result += this.elementLabel.computeSize((int)-1, (int)-1).x;
        }
        return result;
    }

    @Override
    public void setText(String text) {
        if (this.elementLabel == null) {
            return;
        }
        if (text == null) {
            return;
        }
        this.elementLabel.setText(text);
    }

    @Override
    public void setToolTip(String text) {
        if (this.elementLabel == null) {
            return;
        }
        this.elementLabel.setToolTipText(text);
    }

    @Override
    public boolean hasFocus() {
        return this.hasFocus;
    }

    @Override
    public void dispose() {
        if (this.elementLabel != null) {
            if (!this.elementLabel.isDisposed()) {
                if (this.mouseListener != null) {
                    this.elementLabel.removeMouseListener(this.mouseListener);
                }
                if (this.menuListener != null) {
                    this.elementLabel.removeMenuDetectListener(this.menuListener);
                }
            }
            this.elementLabel.dispose();
        }
        this.mouseListener = null;
        this.menuListener = null;
        this.elementLabel = null;
        super.dispose();
    }
}

