/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.breadcrumb;

import java.nio.file.FileSystems;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItem;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItemDropDown;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public abstract class SlimBreadcrumbItemDropdown
extends AbstractBreadcrumbItemDropDown {
    private static final String ARROW_CHARACTER = " " + FileSystems.getDefault().getSeparator() + " ";
    protected Label arrowLabel;
    private MouseListener mouseListener;

    protected SlimBreadcrumbItemDropdown(AbstractBreadcrumbItem parent, Composite composite) {
        super(parent, composite);
        this.arrowLabel = new Label(composite, 0);
        GridData gridData = new GridData(16384, 0x1000000, true, false);
        this.arrowLabel.setLayoutData((Object)gridData);
        this.mouseListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (SlimBreadcrumbItemDropdown.this.fParent == null || SlimBreadcrumbItemDropdown.this.fParent.isDisposed()) {
                    return;
                }
                Shell shell = SlimBreadcrumbItemDropdown.this.fParent.getDropDownShell();
                if (shell != null) {
                    return;
                }
                shell = SlimBreadcrumbItemDropdown.this.fParent.getViewer().getDropDownShell();
                if (shell != null && !shell.isDisposed()) {
                    shell.close();
                }
                SlimBreadcrumbItemDropdown.this.fParent.openDropDownMenu();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        this.fThemeListener = e -> {
            if (e.getProperty().equals("ro.amiq.dvt.ui.editor.breadcrumb.backgroundColor")) {
                DVTColorUtil.INSTANCE.setBackground((Control)this.arrowLabel, DVTColorUtil.INSTANCE.getColor((RGB)e.getNewValue()));
            }
        };
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.fThemeListener);
        Color backgroundColor = JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.editor.breadcrumb.backgroundColor");
        DVTColorUtil.INSTANCE.setBackground((Control)this.arrowLabel, backgroundColor);
        DVTColorUtil.INSTANCE.setForeground((Control)this.arrowLabel, null);
        this.arrowLabel.addMouseListener(this.mouseListener);
        this.arrowLabel.setText(ARROW_CHARACTER);
        composite.layout();
    }

    @Override
    protected Shell getShell() {
        if (this.fParentComposite == null) {
            return null;
        }
        return this.fParentComposite.getShell();
    }

    @Override
    protected boolean isDisposed() {
        if (this.arrowLabel == null) {
            return true;
        }
        return this.arrowLabel.isDisposed();
    }

    @Override
    public void dispose() {
        if (this.arrowLabel != null) {
            if (!this.arrowLabel.isDisposed()) {
                this.arrowLabel.removeMouseListener(this.mouseListener);
            }
            this.arrowLabel.dispose();
        }
        this.arrowLabel = null;
        this.mouseListener = null;
        super.dispose();
    }

    @Override
    public int getWidth() {
        int result = 0;
        if (this.arrowLabel != null && this.arrowLabel.isVisible()) {
            result += this.arrowLabel.computeSize((int)-1, (int)-1).x;
        }
        return result;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.arrowLabel == null) {
            return;
        }
        this.arrowLabel.setVisible(enabled);
        this.arrowLabel.update();
    }
}

