/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.breadcrumb;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbViewer;

public abstract class SlimBreadcrumbViewer
extends AbstractBreadcrumbViewer {
    protected SlimBreadcrumbViewer(IDVTBreadcrumbHost editor, Composite topContainer) {
        super(editor, topContainer);
    }

    @Override
    public void updateNonGUIPart(final Class<?> breadcrumbType, final AbstractBreadcrumbConfiguration configuration, final boolean enabled) {
        if (this.fUpdateJob != null) {
            this.fUpdateJob.cancel();
        }
        this.fUpdateJob = new Job("Computing " + this.fActiveEditor.getBreadcrumbUtils(breadcrumbType).getBCType() + "Breadcrumb Input for " + this.getActiveEditorName() + "..."){

            protected IStatus run(final IProgressMonitor monitor) {
                try {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (SlimBreadcrumbViewer.this.fActiveEditor == null) {
                        return Status.CANCEL_STATUS;
                    }
                    AbstractBreadcrumbUtils bcUtils = SlimBreadcrumbViewer.this.fActiveEditor.getBreadcrumbUtils(breadcrumbType);
                    if (bcUtils == null) {
                        return Status.CANCEL_STATUS;
                    }
                    SlimBreadcrumbViewer.this.fBreadcrumbInput = bcUtils.computeBreadcrumbInput(SlimBreadcrumbViewer.this.fActiveEditor, configuration, enabled);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    final BreadcrumbInput bcInput = SlimBreadcrumbViewer.this.fBreadcrumbInput;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (monitor.isCanceled()) {
                                    return;
                                }
                                try {
                                    SlimBreadcrumbViewer.this.updateGuiPart(enabled, bcInput);
                                }
                                catch (Throwable t) {
                                    DVTLogger.INSTANCE.logError(t);
                                }
                            }
                            finally {
                                this.clearObjection(breadcrumbType);
                            }
                        }

                        private void clearObjection(Class<?> breadcrumbType2) {
                            if (breadcrumbType2 == FSBreadcrumbViewer.class) {
                                ObjectionManager.getInstance().clear(Objection.FILESYSTEM_BC);
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
                catch (Throwable t) {
                    DVTLogger.INSTANCE.logError(t);
                    return Status.CANCEL_STATUS;
                }
            }
        };
        this.fUpdateJob.setSystem(true);
        this.fUpdateJob.schedule((long)(configuration == null ? 0 : configuration.getUpdateDelay()));
    }

    @Override
    public void updateGuiPart(boolean enabled, BreadcrumbInput bcInput) {
        if (this.fTopContainer == null || this.fTopContainer.isDisposed()) {
            return;
        }
        this.forceUpdate = false;
        if (enabled && this.isDisposed()) {
            this.initBreadcrumb();
        }
        if (this.fInputContentProvider != null) {
            this.fInputContentProvider.setBCInput(bcInput);
        }
        if (bcInput == null) {
            this.hideBreadcrumb();
            return;
        }
        if (BreadcrumbInput.REMOVE_BREADCRUMB == bcInput) {
            this.hideBreadcrumb();
            return;
        }
        if (!enabled) {
            return;
        }
        IRfBreadcrumbElement leafSegment = bcInput.getLeafSegment();
        if (leafSegment == null) {
            this.hideBreadcrumb();
            return;
        }
        if (this.isDisposed()) {
            return;
        }
        this.setInput(leafSegment);
        this.forceUpdate = true;
        this.fBreadcrumbHostComposite.layout();
        this.fBreadcrumbHostComposite.getParent().layout();
    }

    @Override
    public void createBreadcrumbSWTComponents(Composite topContainer) {
        this.fBreadcrumbHostComposite = new Composite(topContainer, 2048);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.fBreadcrumbHostComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(0, 0, 0, 0).margins(2, 1).spacing(0, 0).applyTo(this.fBreadcrumbHostComposite);
        this.fTopComposite = this.fBreadcrumbHostComposite;
        AbstractBreadcrumbUtils.orderBreadcrumbs(this.fTopContainer, this.fActiveEditor);
    }

    @Override
    protected Composite getComponentsParent() {
        return this.fBreadcrumbHostComposite;
    }

    @Override
    public void setSelectOtherInstancesButtonEnable(boolean enable) {
    }

    @Override
    public void setBackgroundImageForErrorComposites(Image image) {
    }
}

