/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.breadcrumb;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItem;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItemDetails;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.ThickBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.ThickBreadcrumbViewer;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class ThickBreadcrumbItemDetails
extends AbstractBreadcrumbItemDetails {
    private static final int TRAVERSE_UP = 8;
    private static final int TRAVERSE_DOWN = 16;
    private Label elementImage;
    private Composite imageComposite;
    private String elementText;
    private String elementTooltipText;
    private ToolBar toolBar;
    private ToolBarManager manager;
    private Action breadcrumbElementsAction;
    private PaintListener toolbarPaintListener;
    private PaintListener imagePaintListener;
    private MouseTrackListener mouseTrackListener;
    private AccessibleAdapter accessibleAdapter;
    private MouseListener widgetMouseListener;
    private MenuDetectListener widgetMenuListener;
    private TraverseListener widgetTraversalListener;
    private KeyListener widgetKeyListener;
    private FocusListener widgetTraversalFocusListener;
    private FocusListener widgetFocusListener;

    public ThickBreadcrumbItemDetails(AbstractBreadcrumbItem parent, Composite parentContainer) {
        super(parent, parentContainer);
        this.detailsComposite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        this.detailsComposite.setLayout((Layout)layout);
        this.imageComposite = new Composite(this.detailsComposite, 0);
        this.themeListener = e -> {
            if (e.getProperty().equals("ro.amiq.dvt.ui.editor.breadcrumb.backgroundColor")) {
                DVTColorUtil.INSTANCE.setBackground((Control)this.imageComposite, DVTColorUtil.INSTANCE.getColor((RGB)e.getNewValue()));
                DVTColorUtil.INSTANCE.setBackground((Control)this.toolBar, DVTColorUtil.INSTANCE.getColor((RGB)e.getNewValue()));
            }
        };
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.themeListener);
        Color backgroundColor = JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.editor.breadcrumb.backgroundColor");
        DVTColorUtil.INSTANCE.setBackground((Control)this.imageComposite, backgroundColor);
        this.imageComposite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        layout = new GridLayout(1, false);
        layout.marginHeight = 7;
        layout.marginWidth = 2;
        this.imageComposite.setLayout((Layout)layout);
        this.imagePaintListener = e -> {
            if (this.hasFocus && !this.isTextVisible()) {
                e.gc.drawFocus(e.x, e.y, e.width, e.height);
            }
        };
        this.imageComposite.addPaintListener(this.imagePaintListener);
        this.elementImage = new Label(this.imageComposite, 0);
        this.elementImage.setData("org.eclipse.e4.ui.css.disabled", (Object)true);
        GridData layoutData = new GridData(1, 0x1000000, false, false);
        this.elementImage.setLayoutData((Object)layoutData);
        this.toolBar = new ToolBar(this.detailsComposite, -1);
        GridData gridData = new GridData(0x1000008, 0x1000000, false, false);
        this.toolBar.setLayoutData((Object)gridData);
        this.manager = new ToolBarManager(this.toolBar);
        this.manager.setStyle(0x2000000);
        this.breadcrumbElementsAction = new Action("", 0){

            public void run() {
                ThickBreadcrumbItemDetails.this.updateToolbar(ThickBreadcrumbItemDetails.this.elementText, ThickBreadcrumbItemDetails.this.elementTooltipText);
            }
        };
        this.manager.add((IAction)this.breadcrumbElementsAction);
        this.manager.update(true);
        this.createToolbarSpecificListeners();
        this.toolBar.addPaintListener(this.toolbarPaintListener);
        this.toolBar.addMouseTrackListener(this.mouseTrackListener);
        this.toolBar.getAccessible().addAccessibleListener((AccessibleListener)this.accessibleAdapter);
        this.imageComposite.getAccessible().addAccessibleListener((AccessibleListener)this.accessibleAdapter);
        this.createWidgetListeners();
        this.installMouseListeners((Control)this.toolBar);
        this.installMouseListeners((Control)this.elementImage);
        this.installMouseListeners((Control)this.detailsComposite);
        this.installMouseListeners((Control)this.imageComposite);
        this.installNavigationListeners((Composite)this.toolBar);
        this.installFocusListener(this.detailsComposite);
        this.installFocusListener(this.imageComposite);
        this.installFocusListener((Composite)this.toolBar);
    }

    private void createToolbarSpecificListeners() {
        this.toolbarPaintListener = e -> {
            if (this.hasFocus && this.isTextVisible) {
                e.gc.drawFocus(e.x, e.y, e.width, e.height);
            }
        };
        this.mouseTrackListener = new MouseTrackListener(){
            Color colorOnEnter;

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                Color color = this.colorOnEnter;
                DVTColorUtil.INSTANCE.setForeground((Control)e.widget, color);
                ThickBreadcrumbItemDetails.this.setForeground(color);
            }

            public void mouseEnter(MouseEvent e) {
                this.colorOnEnter = DVTColorUtil.INSTANCE.getForeground((Control)e.widget);
                Color color = DVTColorUtil.INSTANCE.getColor(0, 0, 0);
                DVTColorUtil.INSTANCE.setForeground((Control)e.widget, color);
                ThickBreadcrumbItemDetails.this.setForeground(color);
            }
        };
        this.accessibleAdapter = new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ThickBreadcrumbItemDetails.this.elementText;
            }
        };
    }

    private void createWidgetListeners() {
        this.widgetMouseListener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                AbstractBreadcrumbViewer viewer = ThickBreadcrumbItemDetails.this.item.getViewer();
                int parentIndex = viewer.getIndexOfItem(ThickBreadcrumbItemDetails.this.item) - 1;
                Shell shell = null;
                if (parentIndex >= 0) {
                    AbstractBreadcrumbItem dropDownItem = viewer.getItem(parentIndex);
                    shell = dropDownItem.getDropDownShell();
                }
                viewer.selectItem(ThickBreadcrumbItemDetails.this.item, false);
                if (shell == null && e.button == 1 && e.stateMask == 0) {
                    ThickBreadcrumbItemDetails.this.item.getViewer().fireDoubleClick();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        };
        this.widgetMenuListener = e -> {
            AbstractBreadcrumbViewer viewer = this.item.getViewer();
            viewer.selectItem(this.item, false);
            this.item.getViewer().fireMenuDetect(e);
        };
        this.widgetTraversalListener = e -> {
            if (e == null || this.item == null || this.item.getViewer() == null) {
                return;
            }
            if (e.detail == 2) {
                this.item.getViewer().loseFocus();
                if (this.item.getViewer().fActiveEditor instanceof IEditorPart) {
                    ((IEditorPart)this.item.getViewer().fActiveEditor).setFocus();
                }
                e.doit = false;
                return;
            }
            if (e.detail != 16 && e.detail != 8) {
                e.doit = false;
                return;
            }
            int index = this.item.getViewer().getIndexOfItem(this.item);
            index = e.detail == 16 ? ++index : --index;
            if (index == 0) {
                AbstractBreadcrumbUtils utils = ((ThickBreadcrumbViewer)this.item.getViewer()).getUtils();
                if (!(utils instanceof ThickBreadcrumbUtils)) {
                    return;
                }
                AbstractBreadcrumbItem firstItem = this.item.getViewer().getItem(0);
                if (((ThickBreadcrumbUtils)utils).isDummyRootItem(firstItem)) {
                    return;
                }
            }
            if (index >= 0 && index < this.item.getViewer().getItemCount()) {
                this.item.getViewer().selectItem(this.item.getViewer().getItem(index), true);
            }
            e.doit = true;
        };
        this.widgetKeyListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e == null || ThickBreadcrumbItemDetails.this.item == null || ThickBreadcrumbItemDetails.this.item.getViewer() == null) {
                    return;
                }
                AbstractBreadcrumbViewer viewer = ThickBreadcrumbItemDetails.this.item.getViewer();
                switch (e.keyCode) {
                    case 0x1000004: {
                        this.openLowerLevelDropDown();
                        e.doit = false;
                        break;
                    }
                    case 0x1000002: {
                        this.openSameLevelDropDown();
                        e.doit = false;
                        break;
                    }
                    case 13: {
                        viewer.selectItem(ThickBreadcrumbItemDetails.this.item, true);
                        viewer.fireDoubleClick();
                        if (!(ThickBreadcrumbItemDetails.this.item.getViewer().fActiveEditor instanceof IEditorPart)) break;
                        ((IEditorPart)ThickBreadcrumbItemDetails.this.item.getViewer().fActiveEditor).setFocus();
                        break;
                    }
                    default: {
                        if (e.character != ' ') break;
                        if (!ThickBreadcrumbItemDetails.this.hasFocus) {
                            viewer.selectItem(ThickBreadcrumbItemDetails.this.item, true);
                        }
                        this.openSameLevelDropDown();
                        e.doit = false;
                    }
                }
            }

            private void openSameLevelDropDown() {
                AbstractBreadcrumbViewer viewer = ThickBreadcrumbItemDetails.this.item.getViewer();
                int index = viewer.getIndexOfItem(ThickBreadcrumbItemDetails.this.item);
                AbstractBreadcrumbItem parent = ThickBreadcrumbItemDetails.this.item.getViewer().getItem(index - 1);
                Shell shell = parent.getDropDownShell();
                if (shell == null) {
                    parent.openDropDownMenu();
                    shell = parent.getDropDownShell();
                }
                if (shell != null) {
                    shell.setFocus();
                }
            }

            private void openLowerLevelDropDown() {
                AbstractBreadcrumbViewer viewer = ThickBreadcrumbItemDetails.this.item.getViewer();
                ITreeContentProvider contentProvider = (ITreeContentProvider)viewer.getContentProvider();
                if (!contentProvider.hasChildren(ThickBreadcrumbItemDetails.this.item.getData())) {
                    return;
                }
                ThickBreadcrumbItemDetails.this.item.openDropDownMenu();
                if (ThickBreadcrumbItemDetails.this.item.getDropDownShell() != null) {
                    ThickBreadcrumbItemDetails.this.item.getDropDownShell().setFocus();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        };
        this.widgetTraversalFocusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!ThickBreadcrumbItemDetails.this.hasFocus) {
                    ThickBreadcrumbItemDetails.this.hasFocus = true;
                }
            }

            public void focusLost(FocusEvent e) {
                if (ThickBreadcrumbItemDetails.this.hasFocus) {
                    ThickBreadcrumbItemDetails.this.hasFocus = false;
                }
            }
        };
        this.widgetFocusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                ThickBreadcrumbItemDetails.this.item.getViewer().loseFocus();
            }

            public void focusGained(FocusEvent e) {
            }
        };
    }

    private void updateToolbar(String elementText, String tooltipText) {
        this.breadcrumbElementsAction.setImageDescriptor(null);
        this.breadcrumbElementsAction.setToolTipText(tooltipText);
        this.breadcrumbElementsAction.setText(elementText);
        this.manager.update(true);
    }

    @Override
    public void setToolTip(String text) {
        this.elementTooltipText = text;
        if (this.isTextVisible()) {
            this.updateToolbar(this.elementText, text);
            this.elementImage.setToolTipText(text);
        } else {
            this.updateToolbar(null, null);
            this.elementImage.setToolTipText(text);
        }
    }

    public void setImage(Image image) {
        if (this.elementImage == null || this.elementImage.isDisposed()) {
            return;
        }
        if (image != this.elementImage.getImage()) {
            this.elementImage.setImage(image);
        }
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (!text.equals(this.elementText)) {
            this.elementText = text;
        }
        this.updateToolbar(this.elementText, this.elementTooltipText);
    }

    @Override
    public void setTextVisible(boolean enabled) {
        if (this.isTextVisible == enabled) {
            return;
        }
        this.isTextVisible = enabled;
        GridData data = (GridData)this.toolBar.getLayoutData();
        data.exclude = !enabled;
        this.toolBar.setVisible(enabled);
        if (this.toolBar.isVisible()) {
            this.detailsComposite.setTabList(new Control[]{this.toolBar});
        } else {
            this.detailsComposite.setTabList(new Control[]{this.imageComposite});
        }
        if (this.hasFocus) {
            if (this.isTextVisible()) {
                this.toolBar.setFocus();
            } else {
                this.imageComposite.setFocus();
            }
        }
        this.updateToolbar(this.elementText, this.elementTooltipText);
    }

    @Override
    public void setFocus(boolean enabled) {
        if (enabled == this.hasFocus) {
            return;
        }
        this.hasFocus = enabled;
        if (this.hasFocus) {
            this.detailsComposite.setFocus();
            if (this.toolBar.isVisible()) {
                this.toolBar.setFocus();
            } else {
                this.imageComposite.setFocus();
            }
            this.toolBar.forceFocus();
        }
    }

    @Override
    public boolean hasFocus() {
        return this.hasFocus || this.toolBar != null && this.toolBar.isFocusControl();
    }

    private void installFocusListener(Composite composite) {
        composite.addFocusListener(this.widgetFocusListener);
    }

    private void removeFocusListener(Composite composite) {
        if (composite == null || composite.isDisposed()) {
            return;
        }
        if (this.widgetFocusListener != null) {
            composite.removeFocusListener(this.widgetFocusListener);
        }
    }

    private void installNavigationListeners(Composite composite) {
        composite.addTraverseListener(this.widgetTraversalListener);
        composite.addKeyListener(this.widgetKeyListener);
        composite.addFocusListener(this.widgetTraversalFocusListener);
    }

    private void removeNavigationListeners(Composite composite) {
        if (composite == null || composite.isDisposed()) {
            return;
        }
        if (this.widgetTraversalListener != null) {
            composite.removeTraverseListener(this.widgetTraversalListener);
        }
        if (this.widgetKeyListener != null) {
            composite.removeKeyListener(this.widgetKeyListener);
        }
        if (this.widgetTraversalFocusListener != null) {
            composite.removeFocusListener(this.widgetTraversalFocusListener);
        }
    }

    private void installMouseListeners(Control control) {
        control.addMouseListener(this.widgetMouseListener);
        control.addMenuDetectListener(this.widgetMenuListener);
    }

    private void removeMouseListeners(Control control) {
        if (control == null || control.isDisposed()) {
            return;
        }
        if (this.widgetMouseListener != null) {
            control.removeMouseListener(this.widgetMouseListener);
        }
        if (this.widgetMenuListener != null) {
            control.removeMenuDetectListener(this.widgetMenuListener);
        }
    }

    @Override
    public void setBackground(Color color) {
        if (this.manager == null) {
            return;
        }
        DVTColorUtil.INSTANCE.setBackground((Control)this.manager.getControl(), color);
    }

    @Override
    public void setForeground(Color color) {
        if (this.manager == null) {
            return;
        }
        if (this.item.isGrayedOut()) {
            DVTColorUtil.INSTANCE.setForeground((Control)this.manager.getControl(), DVTUiUtils.COLOR_GRAY);
        } else {
            DVTColorUtil.INSTANCE.setForeground((Control)this.manager.getControl(), color);
        }
    }

    @Override
    public int getWidth() {
        int result = 2;
        if (this.elementImage.getImage() != null) {
            result += this.elementImage.computeSize((int)-1, (int)-1).x;
        }
        if (this.toolBar.isVisible()) {
            result += this.toolBar.computeSize((int)-1, (int)-1).x;
        }
        return result;
    }

    @Override
    public void dispose() {
        this.removeMouseListeners((Control)this.toolBar);
        this.removeMouseListeners((Control)this.elementImage);
        this.removeMouseListeners((Control)this.detailsComposite);
        this.removeMouseListeners((Control)this.imageComposite);
        this.removeNavigationListeners((Composite)this.toolBar);
        this.removeFocusListener(this.detailsComposite);
        this.removeFocusListener(this.imageComposite);
        this.removeFocusListener((Composite)this.toolBar);
        if (this.elementImage != null) {
            this.elementImage.dispose();
        }
        if (this.imageComposite != null) {
            if (!this.imageComposite.isDisposed()) {
                if (this.accessibleAdapter != null) {
                    this.imageComposite.getAccessible().removeAccessibleListener((AccessibleListener)this.accessibleAdapter);
                }
                if (this.imagePaintListener != null) {
                    this.imageComposite.removePaintListener(this.imagePaintListener);
                }
            }
            this.imageComposite.dispose();
        }
        if (this.toolBar != null) {
            if (!this.toolBar.isDisposed()) {
                if (this.accessibleAdapter != null) {
                    this.toolBar.getAccessible().removeAccessibleListener((AccessibleListener)this.accessibleAdapter);
                }
                if (this.mouseTrackListener != null) {
                    this.toolBar.removeMouseTrackListener(this.mouseTrackListener);
                }
                if (this.toolbarPaintListener != null) {
                    this.toolBar.removePaintListener(this.toolbarPaintListener);
                }
            }
            this.toolBar.dispose();
        }
        if (this.manager != null) {
            this.manager.dispose();
        }
        this.toolBar = null;
        this.manager = null;
        this.elementImage = null;
        this.imageComposite = null;
        this.toolbarPaintListener = null;
        this.imagePaintListener = null;
        this.mouseTrackListener = null;
        this.accessibleAdapter = null;
        this.widgetMouseListener = null;
        this.widgetMenuListener = null;
        this.widgetTraversalListener = null;
        this.widgetKeyListener = null;
        this.widgetTraversalFocusListener = null;
        this.widgetFocusListener = null;
        super.dispose();
    }

    public Listener[] testGetListeners(int type) {
        return this.toolBar.getListeners(type);
    }
}

