/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.breadcrumb;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItem;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItemDropDown;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbMessages;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public abstract class ThickBreadcrumbItemDropdown
extends AbstractBreadcrumbItemDropDown {
    protected ToolBar fToolBar;
    protected Action fShowDropDownMenuAction;

    protected ThickBreadcrumbItemDropdown(AbstractBreadcrumbItem parent, Composite composite) {
        super(parent, composite);
        this.fToolBar = new ToolBar(composite, 0x800000);
        this.fToolBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        ToolBarManager manager = new ToolBarManager(this.fToolBar);
        this.fShowDropDownMenuAction = new Action(null, 0){

            public void run() {
                if (ThickBreadcrumbItemDropdown.this.fParent == null || ThickBreadcrumbItemDropdown.this.fParent.isDisposed()) {
                    return;
                }
                Shell shell = ThickBreadcrumbItemDropdown.this.fParent.getDropDownShell();
                if (shell != null) {
                    return;
                }
                shell = ThickBreadcrumbItemDropdown.this.fParent.getViewer().getDropDownShell();
                if (shell != null && !shell.isDisposed()) {
                    shell.close();
                }
                ThickBreadcrumbItemDropdown.this.fParent.openDropDownMenu();
            }
        };
        this.fShowDropDownMenuAction.setImageDescriptor((ImageDescriptor)new AccessibelArrowImage(this.isLTR()));
        this.fShowDropDownMenuAction.setToolTipText(BreadcrumbMessages.BreadcrumbItemDropDown_showDropDownMenu_action_toolTip);
        manager.add((IAction)this.fShowDropDownMenuAction);
        manager.update(true);
        if (IS_MAC_WORKAROUND) {
            manager.getControl().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    ThickBreadcrumbItemDropdown.this.fShowDropDownMenuAction.run();
                }
            });
        }
        this.fThemeListener = e -> {
            if (e.getProperty().equals("ro.amiq.dvt.ui.editor.breadcrumb.backgroundColor")) {
                DVTColorUtil.INSTANCE.setBackground((Control)this.fToolBar, DVTColorUtil.INSTANCE.getColor((RGB)e.getNewValue()));
            }
        };
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.fThemeListener);
        Color backgroundColor = JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.editor.breadcrumb.backgroundColor");
        DVTColorUtil.INSTANCE.setBackground((Control)this.fToolBar, backgroundColor);
    }

    @Override
    public int getWidth() {
        return this.fToolBar.computeSize((int)-1, (int)-1).x;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
        this.fToolBar.setVisible(enabled);
    }

    public void setActionEnabled(boolean enabled) {
        this.fShowDropDownMenuAction.setEnabled(enabled);
    }

    public void setToolTip(String arrowTooltip) {
        if (this.fShowDropDownMenuAction == null || arrowTooltip == null) {
            return;
        }
        this.fShowDropDownMenuAction.setToolTipText(arrowTooltip);
    }

    @Override
    public void dispose() {
        if (this.fToolBar != null) {
            this.fToolBar.dispose();
        }
        this.fToolBar = null;
        this.fShowDropDownMenuAction = null;
        super.dispose();
    }

    @Override
    protected Shell getShell() {
        if (this.fToolBar == null) {
            return null;
        }
        return this.fToolBar.getShell();
    }

    @Override
    protected boolean isDisposed() {
        if (this.fToolBar == null) {
            return true;
        }
        return this.fToolBar.isDisposed();
    }

    protected void refreshDropDownViewer(Composite composite) {
        composite.update();
        this.fDropDownViewer.refresh();
    }

    private final class AccessibelArrowImage
    extends CompositeImageDescriptor {
        private static final int ARROW_SIZE = 5;
        private final boolean fLTR;

        public AccessibelArrowImage(boolean ltr) {
            this.fLTR = ltr;
        }

        protected void drawCompositeImage(int width, int height) {
            int x;
            Display display = ThickBreadcrumbItemDropdown.this.fParentComposite.getDisplay();
            Image image = new Image((Device)display, 5, 10);
            GC gc = new GC((Drawable)image);
            Color foreground = DVTColorUtil.INSTANCE.getSystemColor(display, 24);
            Color background = DVTColorUtil.INSTANCE.getSystemColor(display, 25);
            Color triangle = DVTColorUtil.INSTANCE.blend(background, foreground, 0.8f);
            Color aliasing = DVTColorUtil.INSTANCE.blend(background, foreground, 0.7f);
            gc.setBackground(triangle);
            if (this.fLTR) {
                int[] nArray = new int[6];
                nArray[0] = this.mirror(0);
                nArray[2] = this.mirror(5);
                nArray[3] = 5;
                nArray[4] = this.mirror(0);
                nArray[5] = 10;
                gc.fillPolygon(nArray);
            } else {
                int[] nArray = new int[6];
                nArray[0] = 5;
                nArray[3] = 5;
                nArray[4] = 5;
                nArray[5] = 10;
                gc.fillPolygon(nArray);
            }
            gc.setForeground(aliasing);
            gc.drawLine(this.mirror(0), 1, this.mirror(4), 5);
            gc.drawLine(this.mirror(4), 5, this.mirror(0), 9);
            gc.dispose();
            ImageData imageData = image.getImageData();
            int y = 1;
            while (y < 5) {
                x = 0;
                while (x < y) {
                    imageData.setAlpha(this.mirror(x), y, 255);
                    ++x;
                }
                ++y;
            }
            y = 0;
            while (y < 5) {
                x = 0;
                while (x <= y) {
                    imageData.setAlpha(this.mirror(x), 10 - y - 1, 255);
                    ++x;
                }
                ++y;
            }
            int offset = this.fLTR ? 0 : -1;
            this.drawImage(imageData, width / 2 - 2 + offset, height / 2 - 5 - 1);
            image.dispose();
        }

        private int mirror(int x) {
            if (this.fLTR) {
                return x;
            }
            return 5 - x - 1;
        }

        protected Point getSize() {
            return new Point(10, 16);
        }
    }
}

