/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.breadcrumb;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItem;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.breadcrumb.SOIDialog;
import ro.amiq.dvt.ui.editor.breadcrumb.ThickBreadcrumbItem;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;

public abstract class ThickBreadcrumbViewer
extends AbstractBreadcrumbViewer {
    private boolean showNotifications = true;
    protected Button selectOtherInstanceButton;
    protected SOIDialog soiDialog;
    protected Composite fStackComposite;
    protected StackLayout fStackLayout;
    protected Composite fBreadcrumbViewerComposite;
    private TraverseListener fTraversalListener;

    protected ThickBreadcrumbViewer(IDVTBreadcrumbHost editor, Composite topContainer) {
        super(editor, topContainer);
    }

    public void setNotificationsVisibility(boolean visible) {
        this.showNotifications = visible;
    }

    public boolean getNotificationsVisibility() {
        return this.showNotifications;
    }

    public void changeReadOnlyState() {
        Display.getDefault().syncExec(() -> {
            if (this.isDisposed()) {
                return;
            }
            List<AbstractBreadcrumbItem> items = this.getItems();
            boolean enabledState = !this.isReadOnly();
            for (AbstractBreadcrumbItem item : items) {
                item.setEnabled(enabledState);
            }
            this.setSelectOtherInstancesButtonEnable(enabledState);
        });
    }

    @Override
    public void updateNonGUIPart(final Class<?> breadcrumbType, final AbstractBreadcrumbConfiguration configuration, final boolean enabled) {
        if (this.isReadOnly()) {
            if (this.fUpdateJob != null) {
                this.fUpdateJob.cancel();
                this.fUpdateJob = null;
            }
            this.changeReadOnlyState();
            return;
        }
        if (this.fUpdateJob != null) {
            this.fUpdateJob.cancel();
        }
        if (this.fActiveEditor == null) {
            return;
        }
        AbstractBreadcrumbUtils breadcrumbUtils = this.fActiveEditor.getBreadcrumbUtils(breadcrumbType);
        if (breadcrumbUtils == null) {
            return;
        }
        this.fUpdateJob = new Job("Computing " + breadcrumbUtils.getBCType() + "Breadcrumb Input for " + this.getActiveEditorName() + "..."){

            protected IStatus run(final IProgressMonitor monitor) {
                try {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (ThickBreadcrumbViewer.this.fActiveEditor == null) {
                        return Status.CANCEL_STATUS;
                    }
                    AbstractBreadcrumbUtils bcUtils = ThickBreadcrumbViewer.this.fActiveEditor.getBreadcrumbUtils(breadcrumbType);
                    if (bcUtils == null) {
                        return Status.CANCEL_STATUS;
                    }
                    ThickBreadcrumbViewer.this.fBreadcrumbInput = bcUtils.computeBreadcrumbInput(ThickBreadcrumbViewer.this.fActiveEditor, configuration, enabled);
                    ThickBreadcrumbViewer.this.setModelReady(true);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    final BreadcrumbInput bcInput = ThickBreadcrumbViewer.this.fBreadcrumbInput;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (monitor.isCanceled()) {
                                    return;
                                }
                                try {
                                    ThickBreadcrumbViewer.this.updateGuiPart(enabled, bcInput);
                                    ThickBreadcrumbViewer.this.changeReadOnlyState();
                                }
                                catch (Throwable t) {
                                    DVTLogger.INSTANCE.logError(t);
                                }
                            }
                            finally {
                                this.clearObjection(breadcrumbType);
                            }
                        }

                        private void clearObjection(Class<?> breadcrumbType2) {
                            if (breadcrumbType2 == DHBreadcrumbViewer.class) {
                                ObjectionManager.getInstance().clear(Objection.DESIGN_BC);
                                return;
                            }
                            if (breadcrumbType2 == VHBreadcrumbViewer.class) {
                                ObjectionManager.getInstance().clear(Objection.VERIFICATION_BC);
                                return;
                            }
                            if (breadcrumbType2 == ScopeBreadcrumbViewer.class) {
                                ObjectionManager.getInstance().clear(Objection.SCOPE_BC);
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
                catch (Throwable t) {
                    DVTLogger.INSTANCE.logError(t);
                    return Status.CANCEL_STATUS;
                }
            }
        };
        this.fUpdateJob.setSystem(true);
        this.fUpdateJob.schedule((long)(configuration == null ? 0 : configuration.getUpdateDelay()));
    }

    @Override
    public void updateGuiPart(boolean enabled, BreadcrumbInput bcInput) {
        if (this.fTopContainer == null || this.fTopContainer.isDisposed()) {
            return;
        }
        this.forceUpdate = false;
        if (enabled && this.isDisposed()) {
            this.initBreadcrumb();
        }
        if (enabled && !this.isDisposed() && this.setNoElabComposite(bcInput)) {
            this.fStackComposite.layout();
            this.fStackComposite.getParent().layout();
            return;
        }
        if (this.fInputContentProvider != null) {
            this.fInputContentProvider.setBCInput(bcInput);
        }
        this.updateStackComposite();
        if (bcInput == null) {
            this.hideBreadcrumb();
            return;
        }
        if (BreadcrumbInput.REMOVE_BREADCRUMB == bcInput) {
            this.hideBreadcrumb();
            return;
        }
        if (!enabled) {
            return;
        }
        IRfBreadcrumbElement leafSegment = bcInput.getLeafSegment();
        if (leafSegment == null) {
            this.hideBreadcrumb();
            return;
        }
        this.setInput(leafSegment);
        this.scheduleComputeOtherInstancesJob();
        this.forceUpdate = true;
        this.fBreadcrumbHostComposite.layout();
        this.fStackComposite.getParent().layout();
    }

    protected boolean setNoElabComposite(BreadcrumbInput bcInput) {
        return false;
    }

    @Override
    protected void internalRefresh(Object element) {
        if (this.isReadOnly()) {
            return;
        }
        super.internalRefresh(element);
    }

    public void updateStackComposite() {
        if (this.isDisposed()) {
            return;
        }
        this.fStackLayout.topControl = this.fBreadcrumbHostComposite;
        this.fStackComposite.layout();
    }

    @Override
    public void createBreadcrumbSWTComponents(Composite topContainer) {
        this.fStackComposite = new Composite(topContainer, 2048);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.fStackComposite);
        this.fTopComposite = this.fStackComposite;
        this.fStackLayout = new StackLayout();
        this.fStackComposite.setLayout((Layout)this.fStackLayout);
        this.fBreadcrumbHostComposite = new Composite(this.fStackComposite, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.fBreadcrumbHostComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(0, 0, 0, 0).margins(0, 0).spacing(0, 0).applyTo(this.fBreadcrumbHostComposite);
        this.fBreadcrumbViewerComposite = new Composite(this.fBreadcrumbHostComposite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.fBreadcrumbViewerComposite);
        GridLayoutFactory.fillDefaults().spacing(0, 0).margins(0, 0).extendedMargins(0, 0, 0, 0).applyTo(this.fBreadcrumbViewerComposite);
        AbstractBreadcrumbUtils.orderBreadcrumbs(this.fTopContainer, this.fActiveEditor);
    }

    @Override
    public void createListeners() {
        super.createListeners();
        this.fTraversalListener = e -> {
            boolean bl = e.doit = true;
        };
    }

    @Override
    protected void addBreadcrumbListeners() {
        super.addBreadcrumbListeners();
        if (this.fTraversalListener != null && this.fBreadcrumbContainer != null) {
            this.fBreadcrumbContainer.addTraverseListener(this.fTraversalListener);
        }
    }

    @Override
    protected Composite getComponentsParent() {
        return this.fBreadcrumbViewerComposite;
    }

    @Override
    public void dispose() {
        if (this.fTraversalListener != null && this.fBreadcrumbContainer != null && !this.fBreadcrumbContainer.isDisposed()) {
            this.fBreadcrumbContainer.removeTraverseListener(this.fTraversalListener);
        }
        if (this.fBreadcrumbViewerComposite != null) {
            this.fBreadcrumbViewerComposite.dispose();
        }
        if (this.selectOtherInstanceButton != null) {
            this.selectOtherInstanceButton.dispose();
        }
        if (this.fStackComposite != null) {
            this.fStackComposite.dispose();
        }
        this.fTraversalListener = null;
        this.selectOtherInstanceButton = null;
        this.fBreadcrumbViewerComposite = null;
        this.fStackComposite = null;
        this.fStackLayout = null;
        super.dispose();
    }

    public abstract void scheduleComputeOtherInstancesJob();

    protected abstract AbstractBreadcrumbUtils getUtils();

    public abstract void setModelReady(boolean var1);

    public abstract boolean isReadOnly();

    public StackLayout testGetBreadcrumbLayout() {
        return this.fStackLayout;
    }

    public Composite testGetBreadcrumbHostComposite() {
        return this.fStackComposite;
    }

    public String testGetMessageFromTopComposite() {
        Composite topControl = (Composite)this.fStackLayout.topControl;
        Control styledText = topControl.getChildren()[0];
        if (!(styledText instanceof Composite)) {
            return null;
        }
        Control control = ((Composite)styledText).getChildren()[0];
        if (control instanceof Link) {
            return ((Link)control).getText();
        }
        if (!(control instanceof Composite)) {
            return null;
        }
        StringBuilder breadcrumbPath = new StringBuilder();
        Control[] controlArray = ((Composite)control).getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            Control label = ((Composite)((Composite)((Composite)child).getChildren()[0]).getChildren()[0]).getChildren()[0];
            String[] split = label.getToolTipText().split(" ");
            breadcrumbPath.append(split[0]).append(".");
            ++n2;
        }
        breadcrumbPath.deleteCharAt(breadcrumbPath.lastIndexOf("."));
        return breadcrumbPath.toString();
    }

    public void testNotifySelectOtherInstance(int instanceIndex) {
        Event event = new Event();
        event.data = instanceIndex;
        this.selectOtherInstanceButton.notifyListeners(13, event);
    }

    public AbstractBreadcrumbItem testGetSelectedElement() {
        return this.fSelectedItem;
    }

    public void testTriggerTraverse(int type) {
        if (this.fSelectedItem == null) {
            return;
        }
        Listener[] listeners = ((ThickBreadcrumbItem)this.fSelectedItem).testGetListeners(31);
        Event untypedEvent = new Event();
        untypedEvent.widget = this.fBreadcrumbContainer;
        TraverseEvent e = new TraverseEvent(untypedEvent);
        e.detail = type;
        ((TraverseListener)((TypedListener)listeners[0]).getEventListener()).keyTraversed(e);
    }

    public void testTriggerKeyPress(int key) {
        if (this.fSelectedItem == null) {
            return;
        }
        Listener[] listeners = ((ThickBreadcrumbItem)this.fSelectedItem).testGetListeners(1);
        Event untypedEvent = new Event();
        untypedEvent.widget = this.fBreadcrumbContainer;
        KeyEvent e = new KeyEvent(untypedEvent);
        e.keyCode = key;
        ((KeyListener)((TypedListener)listeners[0]).getEventListener()).keyPressed(e);
    }

    public abstract Button testGetSelectOtherInstanceButton();

    public abstract MenuDetectListener testGetMenuDetectListener();
}

