/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.compare;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.LineBackgroundPainter;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.utils.DVTJobsUtils;

public abstract class DVTTextMergeViewer
extends TextMergeViewer {
    private static Map<CompareConfiguration, CompareConfigurationRegistry> fInstanceRegistry = new ConcurrentHashMap<CompareConfiguration, CompareConfigurationRegistry>();
    CompareConfiguration compareConfiguration;
    private Job highlightJob;

    protected DVTTextMergeViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
        this.compareConfiguration = configuration;
        for (Map.Entry<CompareConfiguration, CompareConfigurationRegistry> entry : fInstanceRegistry.entrySet()) {
            CompareConfiguration coCo = entry.getKey();
            CompareConfigurationRegistry coCoRegistry = entry.getValue();
            if (!coCoRegistry.textMergeViewer.getControl().isDisposed()) continue;
            coCoRegistry.disposeElements();
            fInstanceRegistry.remove(coCo);
        }
        fInstanceRegistry.put(configuration, new CompareConfigurationRegistry(this));
        this.highlightJob = new Job("Highlight in Compare Viewer"){

            protected IStatus run(IProgressMonitor monitor) {
                Region rightLimits;
                CompareConfigurationRegistry compareConfigurationRegistry = fInstanceRegistry.get(DVTTextMergeViewer.this.compareConfiguration);
                Region leftLimits = Utils.getEditorVisibleLimits((ITextViewer)compareConfigurationRegistry.leftTextViewer);
                if (leftLimits != null) {
                    Display.getDefault().asyncExec(() -> DVTHlUtils.invalidateVisibleTextPresentation((ITextViewer)compareConfigurationRegistry.leftTextViewer, leftLimits.getOffset(), leftLimits.getLength(), true));
                }
                if ((rightLimits = Utils.getEditorVisibleLimits((ITextViewer)compareConfigurationRegistry.rightTextViewer)) != null) {
                    Display.getDefault().asyncExec(() -> DVTHlUtils.invalidateVisibleTextPresentation((ITextViewer)compareConfigurationRegistry.rightTextViewer, rightLimits.getOffset(), rightLimits.getLength(), true));
                }
                return Status.OK_STATUS;
            }
        };
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (textViewer instanceof ISourceViewer) {
            DVTSourceViewerConfiguration configuration = this.createSourceViewerConfiguration();
            ((ISourceViewer)textViewer).configure((SourceViewerConfiguration)configuration);
            fInstanceRegistry.get(this.compareConfiguration).setSourceViewerConfiguration(configuration, textViewer);
        }
    }

    protected abstract DVTSourceViewerConfiguration createSourceViewerConfiguration();

    protected void setupDocument(IDocument document) {
        super.setupDocument(document);
        if (this.hasInactiveCodeHighlight()) {
            fInstanceRegistry.get(this.compareConfiguration).addDocument(document);
        }
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        super.updateContent(ancestor, left, right);
        if (this.hasInactiveCodeHighlight()) {
            this.addInactiveCodeBackgroundHighlight(left, right);
        }
        this.highlightJob.schedule(200L);
    }

    protected abstract boolean hasInactiveCodeHighlight();

    public void setInput(Object input) {
        if (this.inputExceedsLinesLimit(input)) {
            this.setInputVisibility(false);
            this.popLinesExceeded();
            return;
        }
        DVTJobsUtils.runWithBusyIndicator(() -> {
            try {
                this.setInputVisibility(true);
                DVTTextMergeViewer.super.setInput(input);
                this.handlePropertyChangeEvent(new PropertyChangeEvent(new Object(), "AbstractTextEditor.Color.Background", null, null));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
    }

    private void setInputVisibility(boolean visible) {
        Control control = super.getControl();
        if (control == null) {
            return;
        }
        Composite parent = control.getParent();
        if (parent == null) {
            return;
        }
        Control[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] != null) {
                children[i].setVisible(visible);
            }
            ++i;
        }
    }

    private void popLinesExceeded() {
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Compare Viewer", null, "Compare viewer disabled because at least one of the involved files contains more than " + this.getCompareViewerMaxLines() + " lines.", 2, new String[]{"OK"}, 0);
        dialog.open();
    }

    private boolean inputExceedsLinesLimit(Object input) {
        if (!(input instanceof ICompareInput)) {
            return false;
        }
        ITypedElement left = ((ICompareInput)input).getLeft();
        ITypedElement right = ((ICompareInput)input).getRight();
        return this.nodeExceedsLinesLimit(left) || this.nodeExceedsLinesLimit(right);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean nodeExceedsLinesLimit(ITypedElement nodeElement) {
        try {
            if (!(nodeElement instanceof IStreamContentAccessor)) {
                return false;
            }
            InputStream contentInputStream = null;
            contentInputStream = ((IStreamContentAccessor)nodeElement).getContents();
            if (contentInputStream == null) {
                return false;
            }
            BufferedReader contentReader = new BufferedReader(new InputStreamReader(contentInputStream));
            int noOfLines = 0;
            int threshold = this.getCompareViewerMaxLines();
            do {
                if (contentReader.readLine() != null) continue;
                contentReader.close();
                return false;
            } while (++noOfLines <= threshold);
            contentReader.close();
            return true;
        }
        catch (IOException | CoreException e) {
            DVTLogger.INSTANCE.logError(e);
            return false;
        }
    }

    protected abstract int getCompareViewerMaxLines();

    public static DVTTextMergeViewer get(CompareConfiguration compareConfiguration) {
        CompareConfigurationRegistry compareConfigurationRegistry = fInstanceRegistry.get(compareConfiguration);
        if (compareConfigurationRegistry == null) {
            return null;
        }
        return compareConfigurationRegistry.textMergeViewer;
    }

    protected void addInactiveCodeBackgroundHighlight(Object leftNode, Object rightNode) {
        Object input;
        IDocument document;
        CompareConfigurationRegistry compareConfigurationRegistry = fInstanceRegistry.get(this.compareConfiguration);
        LineBackgroundPainter leftLineBackgroundPainter = compareConfigurationRegistry.leftLineBackgroundPainter;
        LineBackgroundPainter rightLineBackgroundPainter = compareConfigurationRegistry.rightLineBackgroundPainter;
        boolean compareViewerMirrored = this.isCompareViewerMirrored();
        if (!compareViewerMirrored) {
            document = compareConfigurationRegistry.leftDocument;
            input = leftNode;
        } else {
            document = compareConfigurationRegistry.rightDocument;
            input = rightNode;
        }
        if (document == null || leftLineBackgroundPainter == null || rightLineBackgroundPainter == null || input == null) {
            return;
        }
        if (!(input instanceof IResourceProvider)) {
            return;
        }
        IResource resource = ((IResourceProvider)input).getResource();
        if (resource == null) {
            return;
        }
        IProject project = resource.getProject();
        if (project == null) {
            return;
        }
        IRfSingleLangProject rfProject = RfMixedLangManager.getInstance().getRfSingleLangProject(project, "ro.amiq.vlogdt.VlogNature", false);
        this.addInactiveCodePositions(rfProject, document, resource);
        try {
            if (!document.containsPositionCategory("__dvt_inactive_code_position")) {
                compareConfigurationRegistry.resetDocuments();
                return;
            }
            Position[] positions = document.getPositions("__dvt_inactive_code_position");
            if (!compareViewerMirrored) {
                leftLineBackgroundPainter.setHighlightPositions(Arrays.asList(positions), LineBackgroundPainter.LineBackgroundKind.INACTIVE);
                rightLineBackgroundPainter.setHighlightPositions(Collections.emptyList(), LineBackgroundPainter.LineBackgroundKind.INACTIVE);
            } else {
                rightLineBackgroundPainter.setHighlightPositions(Arrays.asList(positions), LineBackgroundPainter.LineBackgroundKind.INACTIVE);
                leftLineBackgroundPainter.setHighlightPositions(Collections.emptyList(), LineBackgroundPainter.LineBackgroundKind.INACTIVE);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        compareConfigurationRegistry.resetDocuments();
    }

    protected void addInactiveCodePositions(IRfSingleLangProject rfProject, IDocument document, IResource resource) {
    }

    private boolean isCompareViewerMirrored() {
        try {
            Method isMirroredMethod = CompareConfiguration.class.getDeclaredMethod("isMirrored", new Class[0]);
            return (Boolean)isMirroredMethod.invoke((Object)this.compareConfiguration, new Object[0]);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    protected abstract IPreferenceStore getPreferenceStore();

    protected class CompareConfigurationRegistry {
        IDocument ancestorDocument;
        IDocument leftDocument;
        IDocument rightDocument;
        DVTSourceViewerConfiguration ancestorSourceViewerConfiguration;
        DVTSourceViewerConfiguration leftSourceViewerConfiguration;
        DVTSourceViewerConfiguration rightSourceViewerConfiguration;
        TextViewer leftTextViewer;
        LineBackgroundPainter leftLineBackgroundPainter;
        TextViewer rightTextViewer;
        LineBackgroundPainter rightLineBackgroundPainter;
        IViewportListener scrollingViewportListener;
        DVTTextMergeViewer textMergeViewer;

        CompareConfigurationRegistry(DVTTextMergeViewer textMergeViewer) {
            this.textMergeViewer = textMergeViewer;
            this.scrollingViewportListener = verticalOffset -> {
                DVTTextMergeViewer.this.highlightJob.cancel();
                DVTTextMergeViewer.this.highlightJob.schedule(200L);
            };
        }

        private void addDocument(IDocument document) {
            if (this.leftDocument == null) {
                this.leftDocument = document;
            } else if (this.rightDocument == null) {
                this.rightDocument = document;
            } else if (this.ancestorDocument == null) {
                this.ancestorDocument = document;
            }
        }

        private void resetDocuments() {
            this.leftDocument = null;
            this.rightDocument = null;
            this.ancestorDocument = null;
        }

        private void setSourceViewerConfiguration(DVTSourceViewerConfiguration sourceViewerConfiguration, TextViewer textViewer) {
            if (this.ancestorSourceViewerConfiguration == null) {
                this.ancestorSourceViewerConfiguration = sourceViewerConfiguration;
            } else if (this.leftSourceViewerConfiguration == null) {
                this.leftSourceViewerConfiguration = sourceViewerConfiguration;
                this.configureTextViewer(textViewer, true);
            } else if (this.rightSourceViewerConfiguration == null) {
                this.rightSourceViewerConfiguration = sourceViewerConfiguration;
                this.configureTextViewer(textViewer, false);
            }
        }

        private void configureTextViewer(TextViewer textViewer, boolean left) {
            if (textViewer == null) {
                return;
            }
            if (left) {
                this.leftTextViewer = textViewer;
                this.leftLineBackgroundPainter = new LineBackgroundPainter((ITextViewer)textViewer, DVTTextMergeViewer.this.getPreferenceStore(), null);
                this.leftTextViewer.addPainter((IPainter)this.leftLineBackgroundPainter);
                this.leftTextViewer.addViewportListener(this.scrollingViewportListener);
            } else {
                this.rightTextViewer = textViewer;
                this.rightLineBackgroundPainter = new LineBackgroundPainter((ITextViewer)textViewer, DVTTextMergeViewer.this.getPreferenceStore(), null);
                this.rightTextViewer.addPainter((IPainter)this.rightLineBackgroundPainter);
                this.rightTextViewer.addViewportListener(this.scrollingViewportListener);
            }
        }

        private void disposeElements() {
            if (this.ancestorSourceViewerConfiguration != null) {
                this.ancestorSourceViewerConfiguration.dispose();
            }
            if (this.leftSourceViewerConfiguration != null) {
                this.leftSourceViewerConfiguration.dispose();
            }
            if (this.rightSourceViewerConfiguration != null) {
                this.rightSourceViewerConfiguration.dispose();
            }
            if (this.leftTextViewer != null) {
                this.leftTextViewer.removePainter((IPainter)this.leftLineBackgroundPainter);
                this.leftTextViewer.removeViewportListener(this.scrollingViewportListener);
            }
            if (this.rightTextViewer != null) {
                this.rightTextViewer.removePainter((IPainter)this.rightLineBackgroundPainter);
                this.rightTextViewer.removeViewportListener(this.scrollingViewportListener);
            }
            this.scrollingViewportListener = null;
        }
    }
}

