/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.contentasisst;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.contentasisst.DVTContentAssistProcessorManagerCommon;
import ro.amiq.dvt.ui.editor.contentasisst.NonUiProposalsJob;

public abstract class DVTContentAssistProcessorManager
implements DVTContentAssistProcessorManagerCommon,
ICompletionListener {
    private NonUiProposalsJob fProposalsJob;
    private IProgressMonitor fProgressMonitor;
    private int fCrtContentAssistPage = 0;
    private int fPrevOffset;
    private boolean fStarted;

    public void assistSessionEnded(ContentAssistEvent event) {
        this.fCrtContentAssistPage = 0;
        this.fPrevOffset = -1;
        this.fStarted = true;
    }

    public void assistSessionStarted(ContentAssistEvent event) {
        this.fPrevOffset = -1;
        this.fStarted = true;
    }

    public int getCrtContentAssistPage() {
        return this.fCrtContentAssistPage;
    }

    public int getPrevOffset() {
        return this.fPrevOffset;
    }

    public void setPrevOffset(int offset) {
        this.fPrevOffset = offset;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final ICompletionProposal[] computeCompletionProposals(final ITextViewer viewer, final int offset) {
        try {
            block14: {
                if (offset == this.fPrevOffset) {
                    this.fCrtContentAssistPage = (this.fCrtContentAssistPage + 1) % this.getNofProcessors();
                }
                if (this.fProposalsJob != null) {
                    this.fProposalsJob.cancel();
                }
                try {
                    if (!this.fStarted) {
                        IDocument document = viewer.getDocument();
                        char ch = document.getChar(Math.max(0, offset - 1));
                        int i = Math.max(0, offset - 2);
                        while (Character.isDigit(ch) && i >= 0) {
                            ch = document.getChar(i);
                            --i;
                        }
                        if (offset != this.fPrevOffset && !Character.isJavaIdentifierStart(ch)) {
                            return null;
                        }
                    }
                }
                catch (BadLocationException badLocationException) {}
                this.fStarted = false;
                this.fProposalsJob = new NonUiProposalsJob(this.getContentAssistant(), viewer, offset, this.getPreferenceStore()){

                    @Override
                    public ICompletionProposal[] getProposals(IProgressMonitor monitor) {
                        try {
                            DVTContentAssistProcessorManager.this.fProgressMonitor = monitor;
                            ICompletionProposal[] iCompletionProposalArray = DVTContentAssistProcessorManager.this.nonUiComputeCompletionProposals(viewer, offset);
                            return iCompletionProposalArray;
                        }
                        finally {
                            DVTContentAssistProcessorManager.this.fProgressMonitor = null;
                        }
                    }
                };
                if (!Boolean.parseBoolean(System.getenv("DVT_DISABLE_LAZY_PROPOSAL_DISPLAY"))) break block14;
                ICompletionProposal[] iCompletionProposalArray = this.fProposalsJob.getProposals((IProgressMonitor)new NullProgressMonitor());
                return iCompletionProposalArray;
            }
            this.fProposalsJob.schedule();
            ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[]{this.getBusyProposal(viewer, offset)};
            return iCompletionProposalArray;
        }
        catch (Exception exception) {
            ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[]{this.getNoProposal(viewer, offset)};
            return iCompletionProposalArray;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.fPrevOffset = offset;
        }
    }

    public final ICompletionProposal[] testComputeCompletionProposals(final ITextViewer viewer, final int offset) {
        try {
            if (this.fProposalsJob != null) {
                this.fProposalsJob.cancel();
            }
            this.fProposalsJob = new NonUiProposalsJob(this.getContentAssistant(), viewer, offset, this.getPreferenceStore()){

                @Override
                public ICompletionProposal[] getProposals(IProgressMonitor monitor) {
                    try {
                        DVTContentAssistProcessorManager.this.fProgressMonitor = monitor;
                        ICompletionProposal[] iCompletionProposalArray = DVTContentAssistProcessorManager.this.nonUiComputeCompletionProposals(viewer, offset);
                        return iCompletionProposalArray;
                    }
                    finally {
                        DVTContentAssistProcessorManager.this.fProgressMonitor = null;
                    }
                }
            };
            return this.fProposalsJob.getProposals((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {
            return new ICompletionProposal[]{this.getNoProposal(viewer, offset)};
        }
    }

    public abstract int getNofProcessors();

    public boolean isCanceled() {
        Job thisJob = Job.getJobManager().currentJob();
        if (thisJob == null) {
            return false;
        }
        if (thisJob != this.fProposalsJob) {
            return true;
        }
        if (this.fProgressMonitor == null) {
            return false;
        }
        return this.fProgressMonitor.isCanceled();
    }

    protected void nonUiSetStatusMessage(final String message) {
        Utils.getActiveShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DVTContentAssistProcessorManager.this.getContentAssistant().setStatusMessage(message);
            }
        });
    }

    @Override
    public ITextSelection nonUiGetSelection(final ITextViewer viewer) {
        final ITextSelection[] selection = new ITextSelection[1];
        Utils.getActiveShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                selection[0] = (ITextSelection)viewer.getSelectionProvider().getSelection();
            }
        });
        return selection[0];
    }

    protected abstract ICompletionProposal getBusyProposal(ITextViewer var1, int var2);

    protected abstract ContentAssistant getContentAssistant();

    protected abstract ICompletionProposal[] nonUiComputeCompletionProposals(ITextViewer var1, int var2);

    public void showContentAssistPage(int pageIndex) {
        this.fCrtContentAssistPage = pageIndex;
    }
}

