/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.contentasisst;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.swt.custom.StyleRange;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DvtContextInformationType;
import ro.amiq.dvt.ui.editor.contentasisst.DVTParameterListValidatorCommon;

public abstract class DVTParameterListValidator
extends DVTParameterListValidatorCommon
implements IContextInformationPresenter {
    protected ITextViewer viewer;
    protected int currentParameter;
    private static Pattern sdlByNameParameterPattern = Pattern.compile("\\s*(\\w+)\\s*:.*");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updatePresentation(int offset, TextPresentation presentation) {
        if (this.information == null) {
            return false;
        }
        IDocument document = this.viewer.getDocument();
        if (document == null) {
            return false;
        }
        int currParameter = -1;
        DvtContextInformationType informationType = this.information.getContextInformationType();
        try {
            currParameter = this.getParamNum(document, this.contextPosition, offset, ",", "", true, this.information.isSDLScenarioInvocation());
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
        if (this.currentParameter != -1 && currParameter == this.currentParameter) {
            return false;
        }
        presentation.clear();
        this.currentParameter = currParameter;
        String s = this.information.getInformationDisplayString();
        switch (informationType) {
            case ARGUMENTS_OR_ORDERED_PORT_CONNECTIONS: {
                int[] commas;
                int sdlCurrentParamIndex = -1;
                if (this.information.isSDLScenarioInvocation() && this.sdlCollectedParams != null) {
                    String sdlCurrentParam;
                    Matcher matcher;
                    boolean sdlByNameBeforeCurrentParameter = false;
                    List<String> sdlParamNames = this.information.getSdlParamNames();
                    int collectedParamIndex = 0;
                    while (collectedParamIndex < this.sdlCollectedParams.size()) {
                        String collectedParam;
                        Matcher matcher2;
                        if (collectedParamIndex < this.currentParameter && (matcher2 = sdlByNameParameterPattern.matcher(collectedParam = (String)this.sdlCollectedParams.get(collectedParamIndex))).matches()) {
                            String sdlByNameParamName = matcher2.group(1);
                            sdlByNameBeforeCurrentParameter = true;
                            if (sdlParamNames != null && collectedParamIndex < sdlParamNames.size() && sdlParamNames.get(collectedParamIndex) != null && sdlParamNames.get(collectedParamIndex).equals(sdlByNameParamName)) {
                                sdlByNameBeforeCurrentParameter = false;
                            }
                            if (sdlByNameBeforeCurrentParameter) break;
                        }
                        ++collectedParamIndex;
                    }
                    if (sdlParamNames != null && this.currentParameter < this.sdlCollectedParams.size() && (matcher = sdlByNameParameterPattern.matcher(sdlCurrentParam = (String)this.sdlCollectedParams.get(this.currentParameter))).matches()) {
                        String sdlByNameParamName = matcher.group(1);
                        int i = 0;
                        while (i < sdlParamNames.size()) {
                            if (sdlParamNames.get(i) != null && sdlParamNames.get(i).equals(sdlByNameParamName)) {
                                sdlCurrentParamIndex = i;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (sdlCurrentParamIndex == -1 && sdlByNameBeforeCurrentParameter) {
                        presentation.addStyleRange(new StyleRange(0, s.length(), null, null, 0));
                        return true;
                    }
                }
                if (sdlCurrentParamIndex != -1) {
                    this.currentParameter = sdlCurrentParamIndex;
                }
                if ((commas = this.computeCommaPositions(s)).length - 2 < this.currentParameter) {
                    presentation.addStyleRange(new StyleRange(0, s.length(), null, null, 0));
                    return true;
                }
                int start = commas[this.currentParameter] + 1;
                int end = commas[this.currentParameter + 1];
                if (start > 0) {
                    presentation.addStyleRange(new StyleRange(0, start, null, null, 0));
                }
                if (end > start) {
                    presentation.addStyleRange(new StyleRange(start, end - start, null, null, 1));
                }
                if (end >= s.length()) return true;
                presentation.addStyleRange(new StyleRange(end, s.length() - end, null, null, 0));
                return true;
            }
            case FORMAT_SPECIFIERS: {
                try {
                    Region formatSpecPositions = this.computeFormatSpecParamRegion(s, currParameter);
                    if (formatSpecPositions == null) {
                        return false;
                    }
                    int start = formatSpecPositions.getOffset();
                    int end = start + formatSpecPositions.getLength();
                    presentation.addStyleRange(new StyleRange(start, end - start, null, null, 1));
                    return true;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void install(IContextInformation info, ITextViewer viewer, int position) {
        super.install(info, viewer, position);
        this.viewer = viewer;
        this.currentParameter = -1;
    }

    @Override
    protected IDocument getDocument() {
        return this.viewer.getDocument();
    }

    public int testGetCurrentParameter() {
        return this.currentParameter;
    }
}

