/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.contentasisst;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.ui.editor.DVTProposalContextInformation;

public abstract class DVTParameterListValidatorCommon
implements IContextInformationValidator {
    protected int contextPosition;
    protected DVTProposalContextInformation information;
    protected List<String> sdlCollectedParams;

    public int getParamNum(IDocument document, int start, int end, String increments, String decrements, boolean considerNesting, boolean collectParams) throws BadLocationException {
        String currParamText = "";
        if (collectParams) {
            this.sdlCollectedParams = new ArrayList<String>();
        }
        Assert.isTrue(((increments.length() != 0 || decrements.length() != 0) && !increments.equals(decrements) ? 1 : 0) != 0);
        int nestingMode = 0;
        int nestingLevel = 0;
        int charCount = 0;
        int offset = start;
        block12: while (offset < end) {
            char curr = document.getChar(offset++);
            switch (curr) {
                case '/': {
                    char next;
                    if (offset < end) {
                        next = document.getChar(offset);
                        if (next == '*') {
                            offset = this.getVlogECommentEnd(document, offset + 1, end);
                            break;
                        }
                        if (next == '/') {
                            int nextLine = document.getLineOfOffset(offset) + 1;
                            if (nextLine == document.getNumberOfLines()) {
                                offset = end;
                                break;
                            }
                            offset = document.getLineOffset(nextLine);
                            break;
                        }
                        if (!collectParams) continue block12;
                        currParamText = String.valueOf(currParamText) + curr;
                        break;
                    }
                    if (!collectParams) continue block12;
                    currParamText = String.valueOf(currParamText) + curr;
                    break;
                }
                case '*': {
                    if (offset >= end) continue block12;
                    char next = document.getChar(offset);
                    if (next == '/') {
                        charCount = 0;
                        ++offset;
                        break;
                    }
                    if (!collectParams) continue block12;
                    currParamText = String.valueOf(currParamText) + curr;
                    break;
                }
                case '\"': {
                    offset = this.getStringEnd(document, offset, end, curr);
                    if (!collectParams) continue block12;
                    currParamText = String.valueOf(currParamText) + "\"\"";
                    break;
                }
                case '[': {
                    if (considerNesting) {
                        boolean isOptionalArgStart;
                        boolean bl = isOptionalArgStart = offset + 1 < end && document.getChar(offset + 1) != ',';
                        if (!isOptionalArgStart || nestingMode != 1 && nestingMode != 0) continue block12;
                        nestingMode = 1;
                        ++nestingLevel;
                        break;
                    }
                }
                case ']': {
                    if (considerNesting) {
                        if (nestingMode != true || --nestingLevel != 0) continue block12;
                        nestingMode = 0;
                        if (!collectParams) continue block12;
                        currParamText = String.valueOf(currParamText) + "[]";
                        break;
                    }
                }
                case '(': {
                    if (considerNesting) {
                        if (nestingMode == 4) {
                            nestingMode = 3;
                            nestingLevel = 1;
                        }
                        if (nestingMode != 3 && nestingMode != 0) continue block12;
                        nestingMode = 3;
                        ++nestingLevel;
                        break;
                    }
                }
                case ')': {
                    if (considerNesting) {
                        if (nestingMode != 3 || --nestingLevel != 0) continue block12;
                        nestingMode = 0;
                        if (!collectParams) continue block12;
                        currParamText = String.valueOf(currParamText) + "()";
                        break;
                    }
                }
                case '{': {
                    if (considerNesting) {
                        if (nestingMode == 4) {
                            nestingMode = 2;
                            nestingLevel = 1;
                        }
                        if (nestingMode != 2 && nestingMode != 0) continue block12;
                        nestingMode = 2;
                        ++nestingLevel;
                        break;
                    }
                }
                case '}': {
                    if (considerNesting) {
                        if (nestingMode != 2 || --nestingLevel != 0) continue block12;
                        nestingMode = 0;
                        if (!collectParams) continue block12;
                        currParamText = String.valueOf(currParamText) + "{}";
                        break;
                    }
                }
                case '-': {
                    char next;
                    if (this.information != null && "__vhdl_partitioning".equals(this.information.getPartition())) {
                        if (offset >= end || (next = document.getChar(offset)) != '-') continue block12;
                        offset = this.getVhdlCommentEnd(document, offset + 1, end);
                        break;
                    }
                    if (nestingLevel != 0) continue block12;
                    if (increments.indexOf(curr) >= 0) {
                        ++charCount;
                        if (collectParams) {
                            this.sdlCollectedParams.add(currParamText);
                            currParamText = "";
                        }
                    } else {
                        currParamText = String.valueOf(currParamText) + curr;
                    }
                    if (decrements.indexOf(curr) >= 0) {
                        --charCount;
                    }
                }
                default: {
                    if (nestingLevel != 0) continue block12;
                    if (increments.indexOf(curr) >= 0) {
                        ++charCount;
                        if (collectParams) {
                            this.sdlCollectedParams.add(currParamText);
                            currParamText = "";
                        }
                        currParamText = "";
                    } else {
                        currParamText = String.valueOf(currParamText) + curr;
                    }
                    if (decrements.indexOf(curr) < 0) continue block12;
                    --charCount;
                }
            }
        }
        if (collectParams) {
            this.sdlCollectedParams.add(currParamText);
        }
        return charCount;
    }

    private int getVlogECommentEnd(IDocument d, int pos, int end) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            if (curr != '*' || ++pos >= end || d.getChar(pos) != '/') continue;
            return pos + 1;
        }
        return end;
    }

    private int getVhdlCommentEnd(IDocument document, int offset, int end) throws BadLocationException {
        int commentEndOffset = -1;
        int nextLine = document.getLineOfOffset(offset) + 1;
        commentEndOffset = nextLine == document.getNumberOfLines() ? end : document.getLineOffset(nextLine);
        return commentEndOffset;
    }

    private int getStringEnd(IDocument d, int pos, int end, char ch) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            ++pos;
            if (curr == '\\') {
                ++pos;
                continue;
            }
            if (curr != ch) continue;
            return pos;
        }
        return end;
    }

    public int[] computeCommaPositions(String code) {
        int length = code.length();
        int pos = 0;
        int angleLevel = 0;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        positions.add(-1);
        while (pos < length && pos != -1) {
            char ch = code.charAt(pos);
            switch (ch) {
                case ',': {
                    if (angleLevel != 0) break;
                    positions.add(pos);
                    break;
                }
                case '<': {
                    ++angleLevel;
                    break;
                }
                case '>': {
                    --angleLevel;
                    break;
                }
                case '[': {
                    boolean isOptionalArgStart;
                    boolean bl = isOptionalArgStart = pos + 1 < length && code.charAt(pos + 1) != ',';
                    if (!isOptionalArgStart) break;
                    pos = code.indexOf(93, pos);
                    break;
                }
            }
            if (pos == -1) continue;
            ++pos;
        }
        positions.add(length);
        int[] fields = new int[positions.size()];
        int i = 0;
        while (i < fields.length) {
            fields[i] = (Integer)positions.get(i);
            ++i;
        }
        return fields;
    }

    /*
     * Unable to fully structure code
     */
    public Region computeFormatSpecParamRegion(String text, int currParamNum) throws Exception {
        count = 0;
        textArray = text.toCharArray();
        formatSpecifiersMatcher = MethodCallUtils.VLOG_FORMAT_SPECIFIER_PATTERN.matcher(text);
        while (formatSpecifiersMatcher.find()) {
            formatSpecifierString = formatSpecifiersMatcher.group("FORMATSPECGROUP");
            if (formatSpecifierString == null || formatSpecifierString.isEmpty() || !MethodCallUtils.VLOG_VALID_FORMAT_SPECIFIERS_WITH_ARGUMENTS.contains(formatSpecifier = formatSpecifierString.substring(formatSpecifierString.length() - 1))) continue;
            if (count != currParamNum) {
                ++count;
                continue;
            }
            endOffset = formatSpecifiersMatcher.end("FORMATSPECGROUP") - 1;
            startOffset = endOffset;
            if (startOffset < textArray.length) ** GOTO lbl16
            return null;
            while (textArray[startOffset] != '%') {
                --startOffset;
lbl16:
                // 2 sources

                if (startOffset >= 0) continue;
            }
            if (startOffset < 0 || endOffset < 0) {
                return null;
            }
            return new Region(startOffset, endOffset - startOffset + 1);
        }
        return null;
    }

    public void install(IContextInformation info, ITextViewer viewer, int position) {
        this.contextPosition = position;
        if (info instanceof DVTProposalContextInformation) {
            this.information = (DVTProposalContextInformation)info;
            this.contextPosition = this.information.getContextInformationPosition();
        }
    }

    protected abstract IDocument getDocument();
}

