/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.contentasisst;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.VlogBitVector;

public class DVTPositionalTooltipsUtils {
    public static List<String> computeElabParamValues(DVTEditor editor, ELManager manager, IRfNamedElement element, List<? extends IRfNamedElement> parameters) {
        if (manager == null || parameters == null) {
            return null;
        }
        IELMemory memory = manager.getMemory();
        if (memory == null) {
            return null;
        }
        BreadcrumbInput breadcrumbInput = AbstractBreadcrumbUtils.getBreadcrumbInput(DHBreadcrumbViewer.class, editor);
        if (breadcrumbInput == null) {
            return null;
        }
        BreadcrumbInput appendInstanceToBreadcrumbInput = DHBreadcrumbUtils.appendInstanceToBreadcrumbInput(editor, breadcrumbInput, memory, element);
        if (appendInstanceToBreadcrumbInput == null) {
            return null;
        }
        ElementPath elementPath = appendInstanceToBreadcrumbInput.getElementPath(true);
        if (elementPath == null) {
            return null;
        }
        ELParamValues paramValuesFor = memory.paramValuesFor(elementPath);
        if (paramValuesFor == null) {
            return null;
        }
        ArrayList<String> params = new ArrayList<String>();
        for (IRfNamedElement iRfNamedElement : parameters) {
            String paramValueString = DVTPositionalTooltipsUtils.getParamValueString(iRfNamedElement, manager, elementPath, paramValuesFor, true);
            if (paramValuesFor == null) {
                return null;
            }
            params.add(paramValueString);
        }
        return params;
    }

    public static String getParamValueString(IRfNamedElement param, ELManager manager, ElementPath elementPath, ELParamValues elParamValues, boolean useNiceStringCharLimit) {
        ELParamValuesHidEvaluator evaluator = elParamValues.getHidEvaluator(manager);
        BitVectorContext paramContext = ELUtils.makeEvaluatorContext(evaluator, param, elementPath, manager);
        String paramName = param.getName();
        IELParamValue value = elParamValues.getValueDirectly(paramName);
        if (value == null) {
            return null;
        }
        int paramRadix = PrefConst.getParamRadix();
        if (TestHelper.isTestMode()) {
            VlogBitVector vlogNumber;
            VlogBitVector vlogBitVector = vlogNumber = value instanceof ELParamValues.ParamValueNumber && ((ELParamValues.ParamValueNumber)value).getDVTNumber() instanceof VlogBitVector ? (VlogBitVector)((ELParamValues.ParamValueNumber)value).getDVTNumber() : null;
            if (vlogNumber != null && vlogNumber.isString()) {
                return vlogNumber.stringValue(false);
            }
            String baseTwoNumber = value instanceof ELParamValues.ParamValueNumber ? ((ELParamValues.ParamValueNumber)value).toStringRadix(2) : null;
            return String.valueOf(value.toNiceString(paramContext, paramRadix, useNiceStringCharLimit, false)) + (baseTwoNumber != null ? " (" + baseTwoNumber + ")" : "");
        }
        return value.toNiceString(paramContext, paramRadix, useNiceStringCharLimit, false);
    }

    public static String computeSignature(IRfFieldElement parameter, String value) {
        String defaultValue;
        StringBuilder builder = new StringBuilder();
        if (parameter.isTypeParameter()) {
            builder.append("type ");
        }
        builder.append(parameter.getName());
        if (value != null) {
            builder.append("=" + value);
        }
        if ((defaultValue = parameter.getInitialValue(false)) != null) {
            builder.append(" (dflt " + defaultValue + ")");
        }
        return builder.toString();
    }
}

