/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.contentasisst;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.templates.TemplateProposal;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.contentasisst.IDVTCompletionProposal;

public abstract class NonUiProposalsJob
extends Job {
    public static final String DVT_DISABLE_LAZY_PROPOSAL_DISPLAY = "DVT_DISABLE_LAZY_PROPOSAL_DISPLAY";
    private ContentAssistant fContentAssistant;
    private IDocument fDocument;
    private ITextViewer fViewer;
    private int fOffset;
    private IPreferenceStore fPrefStore;

    public NonUiProposalsJob(ContentAssistant contentAssistant, ITextViewer viewer, int offset, IPreferenceStore prefStore) {
        super("Compute autocomplete proposals");
        this.fContentAssistant = contentAssistant;
        this.fViewer = viewer;
        this.fOffset = offset;
        this.fDocument = viewer.getDocument();
        this.fPrefStore = prefStore;
        this.setSystem(true);
        this.setUser(false);
    }

    protected final IStatus run(IProgressMonitor monitor) {
        ICompletionProposal[] proposals = null;
        try {
            proposals = this.getProposals(monitor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        final ICompletionProposal[] finalProposals = proposals;
        Utils.getActiveShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Method m;
                    Field fProposalPopupField = ContentAssistant.class.getDeclaredField("fProposalPopup");
                    fProposalPopupField.setAccessible(true);
                    Object fProposalPopup = fProposalPopupField.get(NonUiProposalsJob.this.fContentAssistant);
                    if (fProposalPopup == null) {
                        return;
                    }
                    if (this.doAutoInsert()) {
                        Method m2 = fProposalPopup.getClass().getDeclaredMethod("hide", new Class[0]);
                        m2.setAccessible(true);
                        m2.invoke(fProposalPopup, new Object[0]);
                        return;
                    }
                    if (EclipseUtils.isAtLeastEclipse47()) {
                        m = fProposalPopup.getClass().getDeclaredMethod("setProposals", List.class, Boolean.TYPE);
                        m.setAccessible(true);
                        m.invoke(fProposalPopup, finalProposals == null ? Collections.emptyList() : Arrays.asList(finalProposals), false);
                    } else {
                        m = fProposalPopup.getClass().getDeclaredMethod("setProposals", ICompletionProposal[].class, Boolean.TYPE);
                        m.setAccessible(true);
                        m.invoke(fProposalPopup, finalProposals, false);
                    }
                    m = fProposalPopup.getClass().getDeclaredMethod("displayProposals", new Class[0]);
                    m.setAccessible(true);
                    m.invoke(fProposalPopup, new Object[0]);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }

            private boolean doAutoInsert() {
                if (finalProposals == null) {
                    return false;
                }
                if (finalProposals.length != 1) {
                    return false;
                }
                if (finalProposals[0] instanceof IDVTCompletionProposal && ((IDVTCompletionProposal)finalProposals[0]).isNoProposal()) {
                    return false;
                }
                if (!NonUiProposalsJob.this.fPrefStore.getBoolean("ca.auto_insert_single")) {
                    return false;
                }
                if (finalProposals[0] instanceof TemplateProposal) {
                    if (finalProposals[0] instanceof ICompletionProposalExtension4 && !((ICompletionProposalExtension4)finalProposals[0]).isAutoInsertable()) {
                        return false;
                    }
                    ((TemplateProposal)finalProposals[0]).apply(NonUiProposalsJob.this.fViewer, '\u0000', 0, NonUiProposalsJob.this.fOffset);
                } else {
                    finalProposals[0].apply(NonUiProposalsJob.this.fDocument);
                }
                return true;
            }
        });
        return Status.OK_STATUS;
    }

    public abstract ICompletionProposal[] getProposals(IProgressMonitor var1);
}

