/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.dhbreadcrumb;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.breadcrumb.BCDropDownContentProvider;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.StringMatcher;

public class DHBCDropDownContentProvider
extends BCDropDownContentProvider
implements ITreeContentProvider {
    private String prefix;
    private DHBreadcrumbViewer breadcrumbViewer;

    public DHBCDropDownContentProvider(DHBreadcrumbViewer viewer) {
        this.breadcrumbViewer = viewer;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object bcElement) {
        IELMemory memory;
        block9: {
            ELManager elManager;
            block8: {
                IDVTBreadcrumbHost editor;
                block7: {
                    block6: {
                        try {
                            editor = this.breadcrumbViewer.getEditor();
                            if (editor != null) break block6;
                            return false;
                        }
                        catch (Throwable t) {
                            DVTLogger.INSTANCE.logError(t);
                            return false;
                        }
                    }
                    if (bcElement instanceof ElementPath) break block7;
                    return false;
                }
                IProject project = editor.getProject();
                elManager = RfMixedLangManager.getInstance().getELManager(project);
                if (elManager != null) break block8;
                return false;
            }
            memory = elManager.getMemory();
            if (memory.isGenerateBlock((ElementPath)bcElement)) break block9;
            return false;
        }
        return !ELUtils.getChildInstances(memory, ((ElementPath)bcElement).toElaborationForm(), 1).isEmpty();
    }

    public Object[] getElements(Object inputElement) {
        List<ELInstance> children;
        ArrayList<ElementPath> result;
        block10: {
            IProject project;
            block9: {
                block8: {
                    IDVTBreadcrumbHost editor;
                    block7: {
                        result = new ArrayList<ElementPath>();
                        editor = this.breadcrumbViewer.getEditor();
                        if (editor != null) break block7;
                        return null;
                    }
                    project = editor.getProject();
                    if (project != null) break block8;
                    return null;
                }
                if (inputElement instanceof ElementPath) break block9;
                return null;
            }
            children = DHBreadcrumbUtils.getChildInstances((ElementPath)inputElement, project, Integer.MAX_VALUE);
            if (!children.isEmpty()) break block10;
            return null;
        }
        try {
            StringMatcher localMatcher = ViewsUtils.createCamelCaseOrRegexMatcher(this.getPrefix(), true, false);
            for (ELInstance child : children) {
                if (child == null) continue;
                ElementPath hierarchyPath = child.getHierarchyPath();
                String childText = this.breadcrumbViewer.getDropDownLabelProvider().getText(hierarchyPath);
                if (!ViewsUtils.matchCamelCaseOrRegex(localMatcher, childText)) continue;
                result.add(hierarchyPath);
            }
            return result.toArray();
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
            return result.toArray();
        }
    }

    public Object[] getChildren(Object bcElement) {
        ElementPath bcPath;
        IProject project;
        block11: {
            ELManager elManager;
            block10: {
                block9: {
                    IDVTBreadcrumbHost editor;
                    block8: {
                        block7: {
                            try {
                                editor = this.breadcrumbViewer.getEditor();
                                if (editor != null) break block7;
                                return null;
                            }
                            catch (Throwable t) {
                                DVTLogger.INSTANCE.logError(t);
                                return null;
                            }
                        }
                        elManager = RfMixedLangManager.getInstance().getELManager(editor.getProject());
                        if (elManager != null) break block8;
                        return null;
                    }
                    project = editor.getProject();
                    if (project != null) break block9;
                    return null;
                }
                if (bcElement instanceof ElementPath) break block10;
                return null;
            }
            bcPath = (ElementPath)bcElement;
            if (elManager.getMemory().isGenerateBlock(bcPath)) break block11;
            return null;
        }
        return DHBreadcrumbUtils.getChildrenPaths(project, bcPath, Integer.MAX_VALUE).toArray();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

