/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.dhbreadcrumb;

import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItem;
import ro.amiq.dvt.ui.editor.breadcrumb.BCDropDownContentProvider;
import ro.amiq.dvt.ui.editor.breadcrumb.BCDropDownTreeViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.ThickBreadcrumbItemDropdown;

public class DHBreadcrumbItemDropDown
extends ThickBreadcrumbItemDropdown {
    public DHBreadcrumbItemDropDown(AbstractBreadcrumbItem parent, Composite composite) {
        super(parent, composite);
    }

    @Override
    protected void internalShowMenu() {
        Composite menuComposite = this.createMenuComposite();
        this.fDropDownViewer = new BCDropDownTreeViewer(this, menuComposite, 268436228);
        this.fDropDownViewer.setUseHashlookup(true);
        Tree tree = (Tree)this.fDropDownViewer.getControl();
        this.setDropDownViewerData((Composite)tree);
        this.addListenersAndFilter((Composite)tree);
        this.addSpecificListeners(tree);
        int index = this.fParent.getViewer().getIndexOfItem(this.fParent);
        if (index < this.fParent.getViewer().getItemCount() - 1) {
            TreeItem[] items;
            AbstractBreadcrumbItem childItem = this.fParent.getViewer().getItem(index + 1);
            Object child = childItem.getData();
            this.fDropDownViewer.setSelection((ISelection)new StructuredSelection(child), true);
            TreeItem[] treeItemArray = items = tree.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (this.getInstanceName((Item)item).equals(((IRfBreadcrumbElement)child).getName())) {
                    tree.setSelection(item);
                }
                ++n2;
            }
            TreeItem[] selection = tree.getSelection();
            if (selection.length > 0) {
                tree.setTopItem(selection[0]);
            }
        }
        this.fShell.setVisible(true);
        this.installCloser(this.fShell);
    }

    private void addSpecificListeners(final Tree tree) {
        tree.addMouseMoveListener(new MouseMoveListener(){
            TreeItem fLastItem;

            public void mouseMove(MouseEvent e) {
                if (tree.equals(e.getSource())) {
                    TreeItem o = tree.getItem(new Point(e.x, e.y));
                    if (o != null && !o.equals(this.fLastItem) || this.fLastItem != null && o == null) {
                        tree.setCursor(null);
                    }
                    if (o instanceof TreeItem) {
                        Rectangle clientArea = tree.getClientArea();
                        TreeItem currentItem = o;
                        if (!o.equals(this.fLastItem)) {
                            this.fLastItem = o;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        } else if (e.y - clientArea.y < tree.getItemHeight() / 4) {
                            if (currentItem.getParentItem() == null) {
                                int index = tree.indexOf(o);
                                if (index < 1) {
                                    return;
                                }
                                this.fLastItem = tree.getItem(index - 1);
                                tree.setSelection(new TreeItem[]{this.fLastItem});
                            } else {
                                Point p = tree.toDisplay(e.x, e.y);
                                Item item = DHBreadcrumbItemDropDown.this.fDropDownViewer.scrollUp(p.x, p.y);
                                if (item instanceof TreeItem) {
                                    this.fLastItem = (TreeItem)item;
                                    tree.setSelection(new TreeItem[]{this.fLastItem});
                                }
                            }
                        } else if (clientArea.y + clientArea.height - e.y < tree.getItemHeight() / 4) {
                            if (currentItem.getParentItem() == null) {
                                int index = tree.indexOf(o);
                                if (index >= tree.getItemCount() - 1) {
                                    return;
                                }
                                this.fLastItem = tree.getItem(index + 1);
                                tree.setSelection(new TreeItem[]{this.fLastItem});
                            } else {
                                Point p = tree.toDisplay(e.x, e.y);
                                Item item = DHBreadcrumbItemDropDown.this.fDropDownViewer.scrollDown(p.x, p.y);
                                if (item instanceof TreeItem) {
                                    this.fLastItem = (TreeItem)item;
                                    tree.setSelection(new TreeItem[]{this.fLastItem});
                                }
                            }
                        }
                    } else if (o == null) {
                        this.fLastItem = null;
                    }
                }
            }
        });
        ((TreeViewer)this.fDropDownViewer).addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                tree.setRedraw(false);
                DHBreadcrumbItemDropDown.this.fShell.getDisplay().asyncExec(() -> {
                    if (DHBreadcrumbItemDropDown.this.fShell.isDisposed()) {
                        return;
                    }
                    try {
                        DHBreadcrumbItemDropDown.this.resizeShell(DHBreadcrumbItemDropDown.this.fShell);
                    }
                    finally {
                        tree.setRedraw(true);
                    }
                });
            }
        });
    }

    @Override
    public void setDropDownViewerData(Composite dropDownViewer) {
        super.setDropDownViewerData(dropDownViewer);
        Object input = this.fParent.getData();
        if (input == null) {
            return;
        }
        this.fDropDownViewer.setInput(input);
        this.updateDropDownViewer("");
        this.setShellBounds(this.fShell);
    }

    @Override
    public Composite getDropDownViewerComposite() {
        if (!(this.fDropDownViewer instanceof TreeViewer)) {
            return null;
        }
        return ((TreeViewer)this.fDropDownViewer).getTree();
    }

    @Override
    public void setShellBounds(Shell shell) {
        Rectangle rect = this.fParentComposite.getBounds();
        Rectangle toolbarBounds = this.fToolBar.getBounds();
        shell.pack();
        Point size = shell.getSize();
        int height = Math.max(Math.min(size.y, this.getMaxHeight()), 200);
        int width = Math.max(Math.min(size.x, 500), 250);
        int imageBoundsX = 0;
        if (((TreeViewer)this.fDropDownViewer).getTree().getItemCount() > 0) {
            TreeItem item = ((TreeViewer)this.fDropDownViewer).getTree().getItem(0);
            imageBoundsX = item.getImageBounds((int)0).x;
        }
        Rectangle trim = this.fShell.computeTrim(0, 0, width, height);
        int x = toolbarBounds.x + toolbarBounds.width + 2 + trim.x - imageBoundsX;
        if (!this.isLTR()) {
            x += width;
        }
        Point pt = new Point(x, rect.y + rect.height);
        pt = this.fParentComposite.toDisplay(pt);
        Rectangle monitor = DHBreadcrumbItemDropDown.getClosestMonitor(shell.getDisplay(), pt).getClientArea();
        int overlap = pt.x + width - (monitor.x + monitor.width);
        if (overlap > 0) {
            pt.x -= overlap;
        }
        if (pt.x < monitor.x) {
            pt.x = monitor.x;
        }
        shell.setLocation(pt);
        shell.setSize(width, height);
    }

    @Override
    protected void refreshDropDownViewer(Composite composite) {
        super.refreshDropDownViewer(composite);
        ((TreeViewer)this.fDropDownViewer).expandToLevel(1);
    }

    @Override
    public void updateDropDownViewer(String text) {
        if (this.fDropDownViewer == null) {
            return;
        }
        IContentProvider contentProvider = this.fDropDownViewer.getContentProvider();
        if (!(contentProvider instanceof BCDropDownContentProvider)) {
            return;
        }
        ((BCDropDownContentProvider)contentProvider).setPrefix(text);
        Tree tree = ((TreeViewer)this.fDropDownViewer).getTree();
        if (tree == null) {
            return;
        }
        this.refreshDropDownViewer((Composite)tree);
        if (tree.getItemCount() == 0) {
            return;
        }
        TreeItem item = tree.getItem(0);
        if (item == null) {
            return;
        }
        Object data = item.getData();
        if (!(data instanceof ElementPath)) {
            return;
        }
        tree.setSelection(item);
    }

    @Override
    public void addTableListeners(Table table) {
    }

    @Override
    protected void clearObjection() {
        ObjectionManager.getInstance().clear(Objection.DESIGN_BC);
    }
}

