/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.dhbreadcrumb;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.SimpleDVTNotification;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbTextHost;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbUtilsCommon;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;

public abstract class DHBreadcrumbUtils
extends DHBreadcrumbUtilsCommon {
    private static final String BC_NOTIFICATION_MULTIPLE_INSTANCES = "BC_NOTIFICATION_MULTIPLE_INSTANCES";
    private static final String BC_NOTIFICATION_MULTIPLE_DESIGN_ELEMENTS = "BC_NOTIFICATION_MULTIPLE_DESIGN_ELEMENTS";
    private static final String SHOW_NOTIF_JOB = "Show Breadcrumb Notification";

    @Override
    protected BreadcrumbInput computeTextEditorBreadcrumbInput(IDVTBreadcrumbTextHost activeEditor, DHBreadcrumbConfiguration configuration, boolean enabled) {
        AbstractBreadcrumbViewer breadcrumbViewer;
        if (configuration == null || activeEditor == null) {
            return null;
        }
        BreadcrumbInput currentRegionInput = this.computeCurrentRegionInput(activeEditor, configuration);
        if (currentRegionInput == null) {
            return null;
        }
        if (currentRegionInput == BreadcrumbInput.NO_ELAB_ELEM_AT_CURSOR || currentRegionInput == BreadcrumbInput.NO_ELAB_ELEM_IN_FILE) {
            return currentRegionInput;
        }
        if (!configuration.isForceUpdate()) {
            this.computeAndShowMultipleInstancesNotification(currentRegionInput.getElementPath(), activeEditor, enabled);
        }
        if (!((breadcrumbViewer = activeEditor.getBreadcrumbViewer(DHBreadcrumbViewer.class)) instanceof DHBreadcrumbViewer)) {
            return currentRegionInput;
        }
        ((DHBreadcrumbViewer)breadcrumbViewer).setNotificationsVisibility(false);
        return currentRegionInput;
    }

    private void computeAndShowMultipleInstancesNotification(final ElementPath bcPath, final IDVTBreadcrumbHost activeEditor, boolean enabled) {
        if (!enabled) {
            return;
        }
        IProject project = activeEditor.getProject();
        if (project == null) {
            return;
        }
        ELManager manager = RfMixedLangManager.getInstance().getELManager(project);
        if (manager == null) {
            return;
        }
        AbstractBreadcrumbViewer breadcrumbViewer = activeEditor.getBreadcrumbViewer(DHBreadcrumbViewer.class);
        if (!(breadcrumbViewer instanceof DHBreadcrumbViewer)) {
            return;
        }
        if (!((DHBreadcrumbViewer)breadcrumbViewer).getNotificationsVisibility()) {
            return;
        }
        final IELMemory memory = manager.getMemory();
        Job showNotifJob = new Job(SHOW_NOTIF_JOB){

            protected IStatus run(IProgressMonitor monitor) {
                IRfNamedElement binding = memory.bindingFor(bcPath.toElaborationForm(), false);
                if (!(binding instanceof IRfDesignElement)) {
                    return Status.OK_STATUS;
                }
                boolean hasMultipleInstances = memory.hasInstancesFor(binding, false, 2);
                if (!hasMultipleInstances) {
                    return Status.OK_STATUS;
                }
                Display.getDefault().syncExec(() -> {
                    new SimpleDVTNotification(activeEditor, 256, DHBreadcrumbUtils.BC_NOTIFICATION_MULTIPLE_INSTANCES).setText("There are multiple instances of " + DHBreadcrumbUtils.this.getCurrentDesignElementName((IRfDesignElement)binding) + " in the Design Hierarchy. Use 'Select Instance' button to change.").setShowPreferenceKey("show.breadcrumb.notifications").create();
                    ObjectionManager.getInstance().clear(Objection.DESIGN_BC_NOTIFICATION);
                });
                return Status.OK_STATUS;
            }
        };
        showNotifJob.setSystem(true);
        showNotifJob.schedule();
    }

    @Override
    protected void showNotifications(IDVTBreadcrumbHost activeEditor, boolean hasMultipleDesignElements, IRfDesignElement currentDesignElement, boolean hasMultipleInstances, boolean enabled) {
        if (!enabled) {
            return;
        }
        AbstractBreadcrumbViewer breadcrumbViewer = activeEditor.getBreadcrumbViewer(DHBreadcrumbViewer.class);
        if (!(breadcrumbViewer instanceof DHBreadcrumbViewer)) {
            return;
        }
        if (!((DHBreadcrumbViewer)breadcrumbViewer).getNotificationsVisibility()) {
            return;
        }
        if (hasMultipleDesignElements) {
            Display.getDefault().asyncExec(() -> {
                boolean bl = new SimpleDVTNotification(activeEditor, 256, BC_NOTIFICATION_MULTIPLE_DESIGN_ELEMENTS).setText("There are several design elements (module, entity, ...) declared in this file. Showing breadcrumb for " + this.getCurrentDesignElementName(currentDesignElement)).setShowPreferenceKey("show.breadcrumb.notifications").create();
            });
        }
        if (hasMultipleInstances) {
            Display.getDefault().asyncExec(() -> {
                boolean bl = new SimpleDVTNotification(activeEditor, 256, BC_NOTIFICATION_MULTIPLE_INSTANCES).setText("There are multiple instances of " + this.getCurrentDesignElementName(currentDesignElement) + " in the Design Hierarchy. Use 'Select Instance' button to change.").setShowPreferenceKey("show.breadcrumb.notifications").create();
            });
        }
        ((DHBreadcrumbViewer)breadcrumbViewer).setNotificationsVisibility(false);
    }

    private String getCurrentDesignElementName(IRfDesignElement currentDesignElement) {
        StringBuilder result = new StringBuilder(currentDesignElement.getKindName());
        result.append(" '").append(currentDesignElement.getName()).append("'");
        if (currentDesignElement.getKind() != IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
            return result.toString();
        }
        IRfDesignElement entity = ((IRfBlockElement)currentDesignElement).getEntity();
        if (entity == null) {
            return result.toString();
        }
        result.append(" of '").append(entity.getName()).append("'");
        return result.toString();
    }

    public static void updateBreadcrumbLabels() {
        try {
            IWorkbenchWindow window = DVTUiUtils.getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            for (IEditorReference editorReference : Utils.getCurrentlyOpenEditorReferences()) {
                IWorkbenchPart editor = editorReference.getPart(false);
                if (!(editor instanceof DVTEditor) || !window.getActivePage().isPartVisible(editor)) continue;
                ((DVTEditor)editor).updateBreadcrumbLabels(DHBreadcrumbViewer.class);
            }
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    public static DVTPFInfo getPFInfo(DHBreadcrumbViewer breadcrumbViewer, ElementPath element) {
        if (element == null || element.isEmpty()) {
            return null;
        }
        BreadcrumbInput input = breadcrumbViewer.getInput();
        if (input == null || input.isEmpty()) {
            return null;
        }
        ElementPath path = input.getElementPathUpTo(element);
        if (path == null) {
            return null;
        }
        RfMixedLangProject rfProject = RfMixedLangManager.getInstance().getRfMixedLangProject(input.getProject(), false);
        if (rfProject == null) {
            return null;
        }
        DVTPFModel pfModel = rfProject.getPFModel();
        if (pfModel == null) {
            return null;
        }
        return pfModel.getPDInfoForInstance(path.toElaborationForm());
    }

    @Override
    public void inhibitDPMUpdate(DVTEditor activeEditor, boolean inhibit) {
        try {
            if (!inhibit) {
                return;
            }
            IEditorInput editorInput = activeEditor.getEditorInput();
            if (editorInput == null) {
                return;
            }
            IResource file = (IResource)editorInput.getAdapter(IResource.class);
            if (!(file instanceof IFile)) {
                return;
            }
            ((IFile)file).setSessionProperty(IDVTConstants.INHIBIT_DPM_UPDATE_QN, new Object());
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

