/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.dhbreadcrumb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.design.DTopPathDiagram;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorInput;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.RfProjectState;
import ro.amiq.dvt.model.reflection.RootDesignElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTStartupConstants;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.actions.breadcrumb.BreadcrumbMode;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItem;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.breadcrumb.IBreadcrumbSerializer;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbTextHost;
import ro.amiq.dvt.ui.editor.breadcrumb.ThickBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProviderCommon;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;

public abstract class DHBreadcrumbUtilsCommon
extends ThickBreadcrumbUtils {
    public static final int DH_WRAPPER_CHILDREN_LEVEL = 1;

    @Override
    public BreadcrumbInput computeBreadcrumbInput(IDVTBreadcrumbHost activeEditor, AbstractBreadcrumbConfiguration configuration, boolean enabled) {
        block10: {
            block9: {
                block8: {
                    block7: {
                        try {
                            if (this.shouldRemoveBreadcrumb(activeEditor)) {
                                activeEditor.setBCCache(null, DHBreadcrumbViewer.class);
                                return BreadcrumbInput.REMOVE_BREADCRUMB;
                            }
                            if (DesignPathManager.getInstance().isEligible(activeEditor)) break block7;
                            return null;
                        }
                        catch (Throwable e) {
                            DVTLogger.INSTANCE.logError(e);
                            return null;
                        }
                    }
                    RfMixedLangProject rfProject = RfMixedLangManager.getInstance().getRfMixedLangProject(activeEditor.getProject(), false);
                    if (rfProject.isBuildDone() || rfProject.isState(RfProjectState.RESTORED) || DVTStartupConstants.isLSRunning.get()) break block8;
                    return null;
                }
                if (!this.shouldInhibitDesignBreadcrumb(activeEditor)) break block9;
                return null;
            }
            if (configuration instanceof DHBreadcrumbConfiguration) break block10;
            return null;
        }
        return this.computeTextEditorBreadcrumbInput((DVTEditor)activeEditor, (DHBreadcrumbConfiguration)configuration, enabled);
    }

    protected BreadcrumbInput computeCurrentRegionInput(IDVTBreadcrumbTextHost bcHost, AbstractBreadcrumbConfiguration config) {
        if (!(config instanceof DHBreadcrumbConfiguration)) {
            return null;
        }
        BreadcrumbInput bcInput = this.toBreadcrumbInput(DesignPathManager.getInstance().getPathFor(bcHost, ((DHBreadcrumbConfiguration)config).getCursor(), true, true), bcHost);
        if (bcInput == null) {
            return DesignPathManager.getInstance().hasElaboratedDesignElements(bcHost) ? BreadcrumbInput.NO_ELAB_ELEM_AT_CURSOR : BreadcrumbInput.NO_ELAB_ELEM_IN_FILE;
        }
        return bcInput;
    }

    public BreadcrumbInput toBreadcrumbInput(ElementPath elementPath, IDVTBreadcrumbHost bcHost) {
        if (elementPath == null || bcHost == null) {
            return null;
        }
        IProject project = bcHost.getProject();
        if (project == null) {
            return null;
        }
        return new BreadcrumbInput(project, DHBreadcrumbUtilsCommon.toBreadcrumbSegments(elementPath, true), this.getBreadcrumbSerializer());
    }

    public static List<BreadcrumbSegment> toBreadcrumbSegments(ElementPath path, boolean reverseOrder) {
        if (path == null || path.isEmpty()) {
            return Collections.emptyList();
        }
        ElementPath elementPath = path.toElaborationForm();
        LinkedList<BreadcrumbSegment> bcSegments = new LinkedList<BreadcrumbSegment>();
        while (!elementPath.isEmpty()) {
            BreadcrumbSegment segment = new BreadcrumbSegment(ElementPath.join(ElementPath.$ROOT_NAME_PATH, Arrays.asList(elementPath.getSegments())));
            if (reverseOrder) {
                bcSegments.addFirst(segment);
            } else {
                bcSegments.add(segment);
            }
            elementPath = elementPath.removeLastSegment();
        }
        BreadcrumbSegment dummySegment = new BreadcrumbSegment(ElementPath.$ROOT_NAME_PATH);
        if (reverseOrder) {
            bcSegments.addFirst(dummySegment);
        } else {
            bcSegments.add(dummySegment);
        }
        return bcSegments;
    }

    public static List<BreadcrumbSegment> computeBCSegmentsForInstance(IDVTBreadcrumbHost dvtEditor, BreadcrumbInput breadcrumbInput, IELMemory memory, IRfNamedElement instanceToAppend) {
        BreadcrumbInput bcInput = DHBreadcrumbUtilsCommon.appendInstanceToBreadcrumbInput(dvtEditor, breadcrumbInput, memory, instanceToAppend);
        return bcInput != null ? bcInput.getInputSegments() : null;
    }

    public static BreadcrumbInput appendInstanceToBreadcrumbInput(IDVTBreadcrumbHost dvtEditor, BreadcrumbInput breadcrumbInput, IELMemory memory, IRfNamedElement instanceToAppend) {
        boolean isBoundInstance;
        AbstractBreadcrumbUtils breadcrumbUtils = dvtEditor.getBreadcrumbUtils(DHBreadcrumbViewer.class);
        IRfBreadcrumbElement elemInBc = DHBreadcrumbUtilsCommon.getElemInBc(breadcrumbInput, instanceToAppend, breadcrumbUtils);
        if (elemInBc != null) {
            List<BreadcrumbSegment> segmentsUpTo = breadcrumbInput.getSegmentsUpTo(elemInBc);
            return new BreadcrumbInput(instanceToAppend.getRfProject().getProject(), segmentsUpTo, breadcrumbUtils.getBreadcrumbSerializer());
        }
        if (instanceToAppend == null) {
            return null;
        }
        boolean bl = isBoundInstance = instanceToAppend instanceof IRfInstanceElement && ((IRfInstanceElement)instanceToAppend).isInstanceToBind();
        if (memory == null && isBoundInstance) {
            return null;
        }
        if (isBoundInstance) {
            List<BreadcrumbSegment> bcSegmentsForBoundInstance = DHBreadcrumbUtilsCommon.computeBCSegmentsForBoundInstance((IRfInstanceElement)instanceToAppend, memory);
            return new BreadcrumbInput(instanceToAppend.getRfProject().getProject(), bcSegmentsForBoundInstance, breadcrumbUtils.getBreadcrumbSerializer());
        }
        IRfScopeElement instanceScope = instanceToAppend.getEnclosingScope();
        if (instanceScope == null) {
            return null;
        }
        if (instanceScope instanceof IRfLibraryElement) {
            ArrayList<BreadcrumbSegment> bcSegments = new ArrayList<BreadcrumbSegment>(1);
            bcSegments.add(new BreadcrumbSegment(instanceToAppend));
            return new BreadcrumbInput(instanceToAppend.getRfProject().getProject(), bcSegments, breadcrumbUtils.getBreadcrumbSerializer());
        }
        IRfDesignElement bcLeafDesign = breadcrumbInput.getLeafDesignElement();
        if (bcLeafDesign == null) {
            return null;
        }
        IRfDefElement bcScope = bcLeafDesign.getDeclaration();
        if (bcScope == null) {
            return null;
        }
        int bcScopeStartOffset = bcScope.getStartOffset();
        int bcScopeEndOffset = bcScope.getEndOffset();
        if (bcScopeStartOffset < 0 || bcScopeEndOffset < 0) {
            return null;
        }
        int designScopeStartOffset = -1;
        int designScopeEndOffset = -1;
        if (instanceScope instanceof IRfNamedElement) {
            designScopeStartOffset = ((IRfNamedElement)instanceScope).getDeclaration().getStartOffset();
            designScopeEndOffset = ((IRfNamedElement)instanceScope).getDeclaration().getEndOffset();
        } else if (instanceScope instanceof IRfDefElement) {
            designScopeStartOffset = ((IRfDefElement)((Object)instanceScope)).getStartOffset();
            designScopeEndOffset = ((IRfDefElement)((Object)instanceScope)).getEndOffset();
        }
        if (designScopeStartOffset < 0 || designScopeEndOffset < 0) {
            return null;
        }
        if (designScopeStartOffset >= bcScopeStartOffset && designScopeEndOffset <= bcScopeEndOffset) {
            return DHBreadcrumbUtilsCommon.appendToBCInput(breadcrumbInput, instanceToAppend, memory, breadcrumbUtils.getBreadcrumbSerializer());
        }
        return null;
    }

    private static BreadcrumbInput appendToBCInput(BreadcrumbInput breadcrumbInput, IRfScopeElement hyperlinkScope, IELMemory memory, IBreadcrumbSerializer bcSerializer) {
        if (!(hyperlinkScope instanceof IRfInstanceElement)) {
            return null;
        }
        IRfBreadcrumbElement leafElem = breadcrumbInput.getLeafSegment();
        if (!(leafElem instanceof ElementPath)) {
            return null;
        }
        ElementPath currentBCPath = ((ElementPath)leafElem).toElaborationForm();
        if (currentBCPath.isEmpty()) {
            return null;
        }
        ElementPath newBCPath = IDesignPathProviderCommon.getPathPrefixedBy(memory, currentBCPath, (IRfInstanceElement)hyperlinkScope, false);
        if (newBCPath == null) {
            return null;
        }
        return new BreadcrumbInput(breadcrumbInput.getProject(), DHBreadcrumbUtilsCommon.toBreadcrumbSegments(newBCPath, true), bcSerializer);
    }

    private static List<BreadcrumbSegment> computeBCSegmentsForBoundInstance(IRfInstanceElement boundInstance, IELMemory memory) {
        if (!boundInstance.isInstanceToBind()) {
            return Collections.emptyList();
        }
        List<ELInstance> instancesFor = memory.getInstancesFor(boundInstance, 1);
        if (instancesFor.isEmpty()) {
            return Collections.emptyList();
        }
        return DHBreadcrumbUtilsCommon.toBreadcrumbSegments(instancesFor.get(0).getHierarchyPath(), true);
    }

    protected static List<ElementPath> getChildrenPaths(IProject project, ElementPath parent, int limit) {
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(project);
        if (elManager == null) {
            return Collections.emptyList();
        }
        if (parent == null || parent.isEmpty()) {
            return Collections.emptyList();
        }
        if (ElementPath.$ROOT_NAME_PATH.equals(parent)) {
            return DHBreadcrumbUtilsCommon.getTopPaths(elManager);
        }
        ElementPath elToBeSearched = parent.toElaborationForm();
        Map<ElementPath, ELInstance> subTree = elManager.getMemory().subtreeOf(elToBeSearched, false);
        if (subTree == null) {
            return Collections.emptyList();
        }
        ArrayList<ElementPath> children = new ArrayList<ElementPath>();
        for (ElementPath candidate : subTree.keySet()) {
            if (candidate.length() == elToBeSearched.length() + 1) {
                children.add(ElementPath.join(ElementPath.$ROOT_NAME_PATH, Arrays.asList(candidate.getSegments())));
            }
            if (children.size() < limit) continue;
            return children;
        }
        return children;
    }

    public static List<ElementPath> getTopPaths(ELManager manager) {
        RootDesignElement root = manager.getRoot();
        if (root == null) {
            return Collections.emptyList();
        }
        Collection<? extends IRfInstanceElement> topList = root.getLocalInstances();
        if (topList == null || topList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ElementPath> children = new ArrayList<ElementPath>();
        for (IRfInstanceElement iRfInstanceElement : topList) {
            children.add(ElementPath.join(ElementPath.$ROOT_NAME_PATH, iRfInstanceElement.getName()));
        }
        return children;
    }

    public static boolean hasMultipleTops(IProject project) {
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(project);
        if (elManager == null) {
            return false;
        }
        RootDesignElement root = elManager.getRoot();
        if (root == null) {
            return false;
        }
        Collection<? extends IRfInstanceElement> tops = root.getLocalInstances();
        if (tops == null || tops.isEmpty()) {
            return false;
        }
        return tops.size() > 1;
    }

    public static IRfNamedElement getDestinationElement(IProject project, Object clickedElement, boolean onlyDesign) {
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(project);
        if (elManager == null) {
            return null;
        }
        if (!(clickedElement instanceof ElementPath)) {
            return null;
        }
        ElementPath instanceElPath = ((ElementPath)clickedElement).toElaborationForm();
        ELInstance instanceFor = elManager.getMemory().instanceFor(instanceElPath);
        if (instanceFor == null) {
            return null;
        }
        IRfInstanceElement description = instanceFor.getDescription();
        if (!onlyDesign) {
            return description;
        }
        IRfNamedElement design = instanceFor.getBinding(false);
        if (design == null || design.getDeclaration() == null) {
            return description;
        }
        return design;
    }

    public static List<BreadcrumbSegment> getSegmentsFromPath(TreePath path, boolean includeSelf) {
        if (path == null || !(path.getElement() instanceof IRfBreadcrumbElement)) {
            return Collections.emptyList();
        }
        List<ElementPath> elements = TreePathUtils.getELElementsFromPath(path, includeSelf);
        ArrayList<BreadcrumbSegment> segments = new ArrayList<BreadcrumbSegment>();
        for (ElementPath element : elements) {
            segments.add(new BreadcrumbSegment(element));
        }
        return segments;
    }

    public static IRfBreadcrumbElement getElemInBc(BreadcrumbInput breadcrumbInput, IRfNamedElement namedElement, AbstractBreadcrumbUtils breadcrumbUtils) {
        if (!(breadcrumbUtils instanceof DHBreadcrumbUtils)) {
            return null;
        }
        IRfNamedElement elementDesign = namedElement instanceof IRfInstanceElement ? DesignUtils.getDesign(DesignUtils.DesignRequest.of(namedElement)) : namedElement;
        IProject project = breadcrumbInput.getProject();
        List<BreadcrumbSegment> inputSegments = breadcrumbInput.getInputSegments();
        for (BreadcrumbSegment segment : inputSegments) {
            if (!DHBreadcrumbUtilsCommon.isElemInBc(elementDesign, segment.getDesignElement(project), (DHBreadcrumbUtils)breadcrumbUtils)) continue;
            return segment.getElement();
        }
        return null;
    }

    private static boolean isElemInBc(IRfNamedElement elem, IRfNamedElement elemDesign, DHBreadcrumbUtils breadcrumbUtils) {
        elemDesign = breadcrumbUtils.resolveToEntity(elemDesign);
        return (elem = breadcrumbUtils.resolveToEntity(elem)) == elemDesign;
    }

    public IRfNamedElement resolveToEntity(IRfNamedElement elem) {
        return elem;
    }

    public IRfNamedElement resolveToArchitecture(IRfNamedElement elem) {
        return elem;
    }

    protected boolean shouldRemoveBreadcrumb(IDVTBreadcrumbHost activeEditor) {
        if (!(activeEditor instanceof DDiagramEditor)) {
            return false;
        }
        DDiagramEditor diagramEditor = (DDiagramEditor)activeEditor;
        DDiagramEditorInput diagramEditorInput = diagramEditor.getInput();
        if (diagramEditorInput == null) {
            return false;
        }
        DDiagram diagram = diagramEditorInput.getDiagram();
        return !(diagram instanceof DTopPathDiagram);
    }

    @Override
    public boolean validateScopeForBreadcrumb(IRfBreadcrumbElement elem) {
        return false;
    }

    public ElementPath computeOpenHyperlinkInput(DVTEditor activeEditor, IRfScopeElement scope, int offset) {
        if (!DesignPathManager.getInstance().isEligible(activeEditor)) {
            return null;
        }
        if (scope instanceof IRfDefElement && activeEditor.getDesignPathProvider().isInstanceDef((IRfDefElement)((Object)scope))) {
            scope = ((IRfDefElement)((Object)scope)).getNamedElement();
        }
        ElementPath pathAtCursor = null;
        pathAtCursor = scope instanceof IRfInstanceElement ? DesignPathManager.getInstance().getPathFor(activeEditor, offset, (IRfNamedElement)scope, null, true, TestHelper.isTestMode()) : DesignPathManager.getInstance().getPathFor(activeEditor, offset, true, TestHelper.isTestMode());
        ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_UPDATE);
        return pathAtCursor;
    }

    @Override
    public boolean isDummyRootItem(AbstractBreadcrumbItem item) {
        if (item == null) {
            return false;
        }
        return item.getData() == ElementPath.$ROOT_NAME_PATH;
    }

    @Override
    public String getBCType() {
        return BreadcrumbMode.DESIGN.getName();
    }

    public static List<ELInstance> getChildInstances(ElementPath inputElement, IProject project, int limit) {
        if (inputElement == null) {
            return Collections.emptyList();
        }
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(project);
        if (elManager == null) {
            return Collections.emptyList();
        }
        if (ElementPath.$ROOT_NAME_PATH.equals(inputElement)) {
            return DHBreadcrumbUtilsCommon.getTopInstances(elManager, limit);
        }
        return ELUtils.getChildInstances(elManager.getMemory(), inputElement.toElaborationForm(), limit);
    }

    private static List<ELInstance> getTopInstances(ELManager elManager, int limit) {
        if (elManager == null) {
            return Collections.emptyList();
        }
        List<ElementPath> topElementPaths = DHBreadcrumbUtilsCommon.getTopPaths(elManager);
        if (topElementPaths == null || topElementPaths.isEmpty()) {
            return Collections.emptyList();
        }
        IELMemory memory = elManager.getMemory();
        if (memory == null) {
            return Collections.emptyList();
        }
        ArrayList<ELInstance> childInstanceList = new ArrayList<ELInstance>();
        for (ElementPath topElementPath : topElementPaths) {
            ELInstance instance = memory.instanceFor(topElementPath.toElaborationForm());
            if (instance == null) continue;
            childInstanceList.add(instance);
            if (childInstanceList.size() != limit) continue;
            return childInstanceList;
        }
        return childInstanceList;
    }

    protected abstract BreadcrumbInput computeTextEditorBreadcrumbInput(IDVTBreadcrumbTextHost var1, DHBreadcrumbConfiguration var2, boolean var3);

    protected abstract void showNotifications(IDVTBreadcrumbHost var1, boolean var2, IRfDesignElement var3, boolean var4, boolean var5);

    protected abstract boolean shouldInhibitDesignBreadcrumb(IDVTBreadcrumbHost var1);

    public abstract void inhibitDPMUpdate(DVTEditor var1, boolean var2);
}

