/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.dhbreadcrumb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.design.DBlockDiagram;
import ro.amiq.dvt.diagrams.design.DFlowDiagram;
import ro.amiq.dvt.diagrams.design.DSchematicDiagram;
import ro.amiq.dvt.diagrams.design.DTopPathDiagram;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorFactory;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorInput;
import ro.amiq.dvt.diagrams.editor.DiagramBreadcrumbUtils;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.views.DVTQuickViewersUtil;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.actions.IMenuCommandDelegate;
import ro.amiq.dvt.ui.actions.MenuCommandDelegatesManager;
import ro.amiq.dvt.ui.actions.breadcrumb.BreadcrumbMode;
import ro.amiq.dvt.ui.actions.breadcrumb.BreadcrumbStateHandler;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItem;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.breadcrumb.DHBreadcrumbItem;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.breadcrumb.SelectOtherDHInstanceDialog;
import ro.amiq.dvt.ui.editor.breadcrumb.ThickBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBCDropDownContentProvider;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBCDropDownLabelProvider;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBCInputContentProvider;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBCInputLabelProvider;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBCToolTipProvider;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbUtilsCommon;
import ro.amiq.dvt.ui.editor.pathmanager.DPMNotification;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManagerCommon;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathListener;
import ro.amiq.dvt.ui.editor.pathmanager.VisitedRegionWrapper;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.Utils;

public class DHBreadcrumbViewer
extends ThickBreadcrumbViewer
implements IDesignPathListener {
    private static final String OPEN_INSTANCE = "Open Instance";
    private static final String SHOW_DIAGRAM = "Show Diagram";
    private static final String COPY_HIERARCHY_PATH = "Copy Hierarchy Path";
    private static final String REVEAL_IN_DESIGN_HIERARCHY = "Reveal in Design Hierarchy";
    private static final String NO_ELAB_ELEM_IN_FILE = "No elaborated design elements in this file";
    private static final String NO_ELAB_ELEM_AT_CURSOR = "No elaborated design element at cursor";
    public static final String ID = "ro.amiq.dvt.ui.editor.breadcrumb.DHBreadcrumbViewer";
    private static boolean isReadOnly;
    private Composite noElabElemInFileComposite;
    private Composite noElabElemAtCursorComposite;
    private static final String SOI_TOOLTIP_TEXT = "Select Instance Path";
    private int editorCursor;
    private IRfDesignElement designElementAtCursor;
    private VisitedRegionWrapper lastVisitedRegion;
    private SelectionListener copyHierarchyPathListener;

    public DHBreadcrumbViewer(IDVTBreadcrumbHost editor, Composite topContainer) {
        super(editor, topContainer);
        this.lastVisitedRegion = new VisitedRegionWrapper(editor);
    }

    @Override
    public boolean isReadOnly() {
        return isReadOnly;
    }

    public static void setReadOnly(boolean readOnlyState) {
        isReadOnly = readOnlyState;
    }

    @Override
    public void setModelReady(boolean isModelReady) {
        DHBreadcrumbViewer.setReadOnly(!isModelReady);
    }

    @Override
    public void createBreadcrumbSWTComponents(Composite topContainer) {
        super.createBreadcrumbSWTComponents(topContainer);
        this.noElabElemInFileComposite = new Composite(this.fStackComposite, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.noElabElemInFileComposite);
        GridLayoutFactory.fillDefaults().applyTo(this.noElabElemInFileComposite);
        Label noElabElemInFileMessage = new Label(this.noElabElemInFileComposite, 0x1000000);
        noElabElemInFileMessage.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 1, 1));
        noElabElemInFileMessage.setText(NO_ELAB_ELEM_IN_FILE);
        this.noElabElemAtCursorComposite = new Composite(this.fStackComposite, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.noElabElemAtCursorComposite);
        GridLayoutFactory.fillDefaults().applyTo(this.noElabElemAtCursorComposite);
        Label noElabElemAtCursorMessage = new Label(this.noElabElemAtCursorComposite, 0x1000000);
        noElabElemAtCursorMessage.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 1, 1));
        noElabElemAtCursorMessage.setText(NO_ELAB_ELEM_AT_CURSOR);
        this.selectOtherInstanceButton = new Button(this.fBreadcrumbHostComposite, 8);
        this.selectOtherInstanceButton.setToolTipText(SOI_TOOLTIP_TEXT);
        this.selectOtherInstanceButton.setImage(DVTImages.imageCache.getImage(DVTImages.DESIGN_HIERARCHY));
        this.selectOtherInstanceButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.selectOtherInstanceButton.setEnabled(false);
        this.selectOtherInstanceButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int instanceIndex = e.data instanceof Integer ? (Integer)e.data : -1;
                IWorkbench workbench = PlatformUI.getWorkbench();
                Display d = workbench.getDisplay();
                Runnable runnable = () -> new SelectOtherDHInstanceDialog(DHBreadcrumbViewer.this.fActiveEditor, DHBreadcrumbViewer.this.designElementAtCursor).open(instanceIndex);
                if (instanceIndex != -1 && TestHelper.isTestMode()) {
                    d.syncExec(runnable);
                } else {
                    d.asyncExec(runnable);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    @Override
    public void createListeners() {
        super.createListeners();
        this.createElementClickListener();
        this.createContextMenuListener();
        this.createOpenFromDropDownListener();
    }

    private void createOpenFromDropDownListener() {
        this.fOpenFromDropDownListener = e -> {
            try {
                Object eventSource = e.getSource();
                if (!(eventSource instanceof DHBreadcrumbViewer)) {
                    return;
                }
                ISelection selection = e.getSelection();
                if (!(selection instanceof StructuredSelection)) {
                    return;
                }
                DHBreadcrumbViewer breadcrumbViewer = (DHBreadcrumbViewer)eventSource;
                IDVTBreadcrumbHost editor = breadcrumbViewer.getEditor();
                if (editor == null) {
                    return;
                }
                Object selectedElement = ((StructuredSelection)selection).getFirstElement();
                if (!(selectedElement instanceof ElementPath)) {
                    return;
                }
                ElementPath currentPath = (ElementPath)selectedElement;
                IProject project = this.getProject();
                if (project == null) {
                    return;
                }
                if (editor instanceof DVTEditor) {
                    IRfNamedElement destinationElement = DHBreadcrumbUtilsCommon.getDestinationElement(project, selectedElement, true);
                    if (destinationElement == null) {
                        return;
                    }
                    IRfDefElement declaration = destinationElement.getDeclaration();
                    if (declaration == null) {
                        return;
                    }
                    IRfFileDef defFile = declaration.getDefFile();
                    if (defFile == null) {
                        return;
                    }
                    IResource file = (IResource)defFile.getAdapter(IResource.class);
                    if (file == null) {
                        return;
                    }
                    file.setSessionProperty(IDVTConstants.INHIBIT_DPM_UPDATE_QN, new Object());
                    DVTRfUtils.goToDeclaration(destinationElement, true);
                    DesignPathManager.getInstance().updateFor((DVTEditor)DVTFileUtils.getInstance().getActiveEditor(), currentPath);
                } else if (editor instanceof DDiagramEditor) {
                    ELManager elManager = RfMixedLangManager.getInstance().getELManager(project);
                    if (elManager == null || elManager.getMemory() == null || elManager.getMemory().isGenerateBlock(currentPath)) {
                        return;
                    }
                    IRfNamedElement destinationElement = DHBreadcrumbUtilsCommon.getDestinationElement(project, selectedElement, false);
                    if (destinationElement == null) {
                        return;
                    }
                    DDiagramEditorInput input = ((DDiagramEditor)editor).getInput();
                    if (input == null) {
                        return;
                    }
                    DDiagram diagram = input.getDiagram();
                    if (!(diagram instanceof DTopPathDiagram)) {
                        return;
                    }
                    BreadcrumbInput breadcrumbInput = DiagramBreadcrumbUtils.getInstance().toBreadcrumbInput(currentPath, editor);
                    if (breadcrumbInput == null) {
                        return;
                    }
                    NLConfig config = new NLConfig(DDesignEditorFactory.getInstance().getDefaultNLConfiguration());
                    config.setBreadcrumbInput(breadcrumbInput);
                    NLConfig oldConfig = ((DTopPathDiagram)diagram).getConfig();
                    if (oldConfig != null) {
                        config.setFilterSet(oldConfig.getFilterSet());
                        config.setDiagramShowPortWidth(oldConfig.getDiagramShowPortWidth());
                    }
                    if (diagram instanceof DBlockDiagram) {
                        DDesignEditorFactory.getInstance().newBlockDiagram(destinationElement, config, currentPath).openEditor();
                    }
                    if (diagram instanceof DFlowDiagram) {
                        DDesignEditorFactory.getInstance().newFlowDiagram(destinationElement, config, currentPath).openEditor();
                    }
                    if (diagram instanceof DSchematicDiagram) {
                        DDesignEditorFactory.getInstance().newSchematicDiagram(destinationElement, config, currentPath).openEditor();
                    }
                }
            }
            catch (Exception e1) {
                DVTLogger.INSTANCE.logError((Throwable)e1);
            }
        };
    }

    private void createContextMenuListener() {
        this.fContextMenuListener = e -> {
            ISelection selection = this.getSelection();
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (!(element instanceof ElementPath)) {
                return;
            }
            Menu contextMenu = new Menu((Control)this.getContainer());
            ElementPath breadcrumbElement = (ElementPath)element;
            this.addContextMenuActions(contextMenu, breadcrumbElement, false);
            contextMenu.setLocation(e.x, e.y);
            contextMenu.setVisible(true);
        };
    }

    private void createElementClickListener() {
        this.fElementClickListener = e -> {
            block38: {
                try {
                    Object eventSource = e.getSource();
                    if (!(eventSource instanceof DHBreadcrumbViewer)) {
                        return;
                    }
                    ELManager elManager = RfMixedLangManager.getInstance().getELManager(this.getProject());
                    if (elManager == null) {
                        return;
                    }
                    DHBreadcrumbViewer breadcrumbViewer = (DHBreadcrumbViewer)eventSource;
                    IDVTBreadcrumbHost editor = breadcrumbViewer.getEditor();
                    Object selectionElement = ((IStructuredSelection)e.getSelection()).getFirstElement();
                    if (!(selectionElement instanceof ElementPath)) {
                        return;
                    }
                    ElementPath elementPath = (ElementPath)selectionElement;
                    if (editor instanceof DDiagramEditor && elManager.getMemory().isGenerateBlock(elementPath)) {
                        return;
                    }
                    if (this.fBreadcrumbInput == null) {
                        return;
                    }
                    int indexOfSelectedElement = this.fBreadcrumbInput.indexOfSegment(elementPath);
                    if (indexOfSelectedElement < 0) {
                        return;
                    }
                    List<BreadcrumbSegment> inputSegments = this.fBreadcrumbInput.getInputSegments();
                    if (inputSegments == null) {
                        return;
                    }
                    List<BreadcrumbSegment> subList = inputSegments.subList(0, indexOfSelectedElement + 1);
                    ElementPath currentPath = elementPath;
                    IProject project = this.fActiveEditor.getProject();
                    if (project == null) {
                        return;
                    }
                    if (editor instanceof DVTEditor) {
                        IRfNamedElement destinationElement = DHBreadcrumbUtilsCommon.getDestinationElement(project, elementPath, true);
                        if (destinationElement == null) {
                            return;
                        }
                        IRfDefElement declaration = destinationElement.getDeclaration();
                        if (declaration == null) {
                            return;
                        }
                        IRfFileDef defFile = declaration.getDefFile();
                        if (defFile == null) {
                            return;
                        }
                        IResource file = (IResource)defFile.getAdapter(IResource.class);
                        file.setSessionProperty(IDVTConstants.INHIBIT_DPM_UPDATE_QN, new Object());
                        DVTRfUtils.goToDeclaration(destinationElement, true);
                        DesignPathManager.getInstance().updateFor((DVTEditor)DVTFileUtils.getInstance().getActiveEditor(), currentPath);
                        break block38;
                    }
                    if (!(editor instanceof DDiagramEditor)) break block38;
                    DDiagramEditorInput input = ((DDiagramEditor)editor).getInput();
                    if (input == null) {
                        return;
                    }
                    IRfNamedElement destinationElement = DHBreadcrumbUtilsCommon.getDestinationElement(project, elementPath, false);
                    if (destinationElement == null || destinationElement.getDeclaration() == null) {
                        return;
                    }
                    DDiagram diagram = input.getDiagram();
                    if (!(diagram instanceof DTopPathDiagram)) {
                        return;
                    }
                    try {
                        NLConfig config = new NLConfig(DDesignEditorFactory.getInstance().getDefaultNLConfiguration());
                        config.setBreadcrumbInput(new BreadcrumbInput(editor.getProject(), subList, DiagramBreadcrumbUtils.getInstance().getBreadcrumbSerializer()));
                        NLConfig oldConfig = ((DTopPathDiagram)diagram).getConfig();
                        if (oldConfig != null) {
                            config.setFilterSet(oldConfig.getFilterSet());
                            config.setDiagramShowPortWidth(oldConfig.getDiagramShowPortWidth());
                        }
                        currentPath = currentPath.toElaborationForm();
                        if (diagram instanceof DBlockDiagram) {
                            DDesignEditorFactory.getInstance().newBlockDiagram(destinationElement, config, currentPath).openEditor();
                        }
                        if (diagram instanceof DFlowDiagram) {
                            DDesignEditorFactory.getInstance().newFlowDiagram(destinationElement, config, currentPath).openEditor();
                        }
                        if (diagram instanceof DSchematicDiagram) {
                            DDesignEditorFactory.getInstance().newSchematicDiagram(destinationElement, config, currentPath).openEditor();
                        }
                    }
                    catch (Exception e1) {
                        DVTLogger.INSTANCE.logError((Throwable)e1);
                    }
                }
                finally {
                    ObjectionManager.getInstance().clear(Objection.DESIGN_BC_CLICK_ELEMENT);
                }
            }
        };
    }

    private void addContextMenuActions(Menu contextMenu, ElementPath breadcrumbElement, boolean inDD) {
        this.addOpenInstanceMenuItem(breadcrumbElement, contextMenu, inDD);
        this.addShowDiagramMenuItem(breadcrumbElement, contextMenu, inDD);
        this.addShowInDesignHierarchyMenuItem(breadcrumbElement, contextMenu);
        if (contextMenu.getItemCount() != 0) {
            new MenuItem(contextMenu, 2);
        }
        this.addCopyHierarcyPathMenuItem(breadcrumbElement, contextMenu, inDD);
    }

    private void addCopyHierarcyPathMenuItem(final ElementPath bcElement, Menu contextMenu, final boolean inDD) {
        MenuItem mi = new MenuItem(contextMenu, 0);
        mi.setText(COPY_HIERARCHY_PATH);
        this.copyHierarchyPathListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ElementPath elToSearch = bcElement;
                String lineDelimiter = DVTDocumentCommon.getLineDelimiterByProject(DHBreadcrumbViewer.this.getEditor().getProject());
                ElementPath path = DHBreadcrumbViewer.this.fBreadcrumbInput.getElementPathUpTo(bcElement);
                path = path.toElaborationForm();
                String pathDelim = DVTPlugin.getDefault().getPreferenceStore().getString("copyHierarchyPathSegmentSeparator");
                String fullPath = String.valueOf(path.toString(pathDelim)) + lineDelimiter;
                Utils.copyToClipboard(fullPath.trim(), 3);
                if (inDD) {
                    if (!elToSearch.startsWith(ElementPath.$ROOT_NAME_PATH)) {
                        LinkedList<String> segments = new LinkedList<String>();
                        Collections.addAll(segments, elToSearch.getSegments());
                        segments.add(0, ElementPath.$ROOT_NAME_PATH.firstSegment());
                        elToSearch = ElementPath.create(segments);
                    }
                    ElementPath elementPath = elToSearch.removeLastSegment();
                    int itemToCloseIndex = DHBreadcrumbViewer.this.fBreadcrumbInput.indexOfSegment(elementPath);
                    if (!DHBreadcrumbUtilsCommon.hasMultipleTops(DHBreadcrumbViewer.this.getProject())) {
                        --itemToCloseIndex;
                    }
                    DHBreadcrumbViewer.this.getItem(itemToCloseIndex).closeDropDownMenu();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        mi.addSelectionListener(this.copyHierarchyPathListener);
    }

    private void addOpenInstanceMenuItem(final ElementPath element, Menu contextMenu, final boolean inDD) {
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(this.getProject());
        if (elManager == null) {
            return;
        }
        if (this.fBreadcrumbInput.isRoot(element, inDD)) {
            return;
        }
        ELInstance instanceFor = elManager.getMemory().instanceFor(element.toElaborationForm());
        if (instanceFor == null) {
            return;
        }
        final IRfInstanceElement targetElement = instanceFor.getDescription();
        if (targetElement == null) {
            return;
        }
        MenuItem mi = new MenuItem(contextMenu, 0);
        mi.setText(OPEN_INSTANCE);
        mi.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    this.setBreadcrumbDataBeforeOpenInstance();
                    DVTRfUtils.goToDeclaration(targetElement, true);
                    if (!(DHBreadcrumbViewer.this.fActiveEditor instanceof DVTEditor)) {
                        return;
                    }
                    ElementPath newElementPath = element.removeLastSegment();
                    DesignPathManager.getInstance().updateFor((DVTEditor)DVTFileUtils.getInstance().getActiveEditor(), newElementPath);
                }
                catch (Exception t) {
                    DVTLogger.INSTANCE.logError((Throwable)t);
                }
            }

            private void setBreadcrumbDataBeforeOpenInstance() {
                try {
                    IRfDefElement targetDefElement = targetElement.getDeclaration();
                    if (targetDefElement == null) {
                        return;
                    }
                    Object targetFile = targetDefElement.getDefFile().getAdapter(IResource.class);
                    if (!(targetFile instanceof IFile)) {
                        return;
                    }
                    int indexOfClickedElement = DHBreadcrumbViewer.this.fBreadcrumbInput.indexOfSegment(element);
                    if (indexOfClickedElement == -1) {
                        ElementPath elToSearch = element.removeLastSegment();
                        if (!elToSearch.startsWith(ElementPath.$ROOT_NAME_PATH)) {
                            LinkedList<String> segments = new LinkedList<String>();
                            Collections.addAll(segments, elToSearch.getSegments());
                            segments.add(0, ElementPath.$ROOT_NAME_PATH.firstSegment());
                            elToSearch = ElementPath.create(segments);
                        }
                        indexOfClickedElement = DHBreadcrumbViewer.this.fBreadcrumbInput.indexOfSegment(elToSearch) + 1;
                    }
                    IFile file = (IFile)targetFile;
                    if (inDD) {
                        int itemToCloseIndex = indexOfClickedElement - 1;
                        if (!DHBreadcrumbUtilsCommon.hasMultipleTops(DHBreadcrumbViewer.this.getProject())) {
                            --itemToCloseIndex;
                        }
                        DHBreadcrumbViewer.this.getItem(itemToCloseIndex).closeDropDownMenu();
                    }
                    if (DesignPathManager.getInstance().isEligible(DHBreadcrumbViewer.this.fActiveEditor)) {
                        file.setSessionProperty(IDVTConstants.INHIBIT_DPM_UPDATE_QN, new Object());
                    }
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void addShowInDesignHierarchyMenuItem(final ElementPath bcElement, Menu contextMenu) {
        MenuItem mi = new MenuItem(contextMenu, 0);
        mi.setText(REVEAL_IN_DESIGN_HIERARCHY);
        mi.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ElementPath path = DHBreadcrumbViewer.this.fBreadcrumbInput.getElementPathUpTo(bcElement).toElaborationForm();
                TreePath top = TreePathUtils.computeTreePathFromBreadrumbElementPath(path, DHBreadcrumbViewer.this.fActiveEditor.getProject());
                DVTQuickViewersUtil.revealInDesignHierarchyView(top);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void addShowDiagramMenuItem(ElementPath element, Menu contextMenu, boolean fromDD) {
        IRfInstanceElement designElem;
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(this.getProject());
        if (elManager == null) {
            return;
        }
        if (fromDD) {
            return;
        }
        ElementPath elaborationForm = element.toElaborationForm();
        IELMemory memory = elManager.getMemory();
        ELInstance instanceFor = memory.instanceFor(elaborationForm);
        if (instanceFor == null) {
            return;
        }
        if (memory.isGenerateBlock(elaborationForm)) {
            return;
        }
        IRfInstanceElement namedElem = instanceFor.getDescription();
        IRfNamedElement iRfNamedElement = designElem = namedElem instanceof DummyInstance ? ((DummyInstance)namedElem).design : namedElem;
        if (designElem == null) {
            return;
        }
        final IRfInstanceElement targetElement = designElem;
        MenuItem mi = new MenuItem(contextMenu, 0);
        mi.setText(SHOW_DIAGRAM);
        mi.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DVTTreeElementWrapper wrapper = new DVTTreeElementWrapper(targetElement);
                IMenuCommandDelegate delegate = MenuCommandDelegatesManager.getCommandDelegate(wrapper);
                if (delegate == null) {
                    return;
                }
                delegate.showDiagram(wrapper, DHBreadcrumbViewer.ID);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    @Override
    public void configureDropDownViewer(ColumnViewer viewer, Object input) {
        if (!(viewer instanceof TreeViewer)) {
            return;
        }
        ((TreeViewer)viewer).getTree().addMenuDetectListener(e -> {
            ISelection selection = viewer.getSelection();
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            Object selectedElem = ((IStructuredSelection)selection).getFirstElement();
            if (!(selectedElem instanceof ElementPath)) {
                return;
            }
            Menu contextMenu = new Menu((Control)this.fBreadcrumbHostComposite);
            this.addContextMenuActions(contextMenu, (ElementPath)selectedElem, true);
            contextMenu.setLocation(e.x, e.y);
            contextMenu.setVisible(true);
        });
        viewer.setContentProvider(this.fDropDownContentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)this.fDropDownLabelProvider);
    }

    @Override
    public void computeDropdownElements(Object inputElement) {
        if (!(this.fDropDownContentProvider instanceof DHBCDropDownContentProvider)) {
            return;
        }
        if (!(inputElement instanceof ElementPath)) {
            return;
        }
        Object[] ddElements = ((DHBCDropDownContentProvider)this.fDropDownContentProvider).getElements(inputElement);
        if (ddElements == null) {
            return;
        }
        this.fDropdownElements = Arrays.asList(ddElements);
    }

    @Override
    protected int getWidthOfExtraWidgets() {
        return this.selectOtherInstanceButton.getBounds().width;
    }

    @Override
    public void createBreadcrumbDropDownProviders() {
        this.fDropDownContentProvider = new DHBCDropDownContentProvider(this);
        this.fDropDownLabelProvider = new DHBCDropDownLabelProvider(this.getEditor());
    }

    @Override
    public void createBreadcrumbInputProviders() {
        this.fInputContentProvider = new DHBCInputContentProvider(this);
        this.fInputLabelProvider = new DHBCInputLabelProvider(this);
        this.fInputTooltipProvider = new DHBCToolTipProvider(this);
    }

    @Override
    public void setBackgroundImageForErrorComposites(Image image) {
        this.noElabElemInFileComposite.setBackgroundImage(image);
        this.noElabElemAtCursorComposite.setBackgroundImage(image);
    }

    @Override
    public void scheduleComputeOtherInstancesJob() {
        Job computeInstances = new Job("Design Breadcrumb: Computing Other Instances for " + this.getActiveEditorName() + "..."){

            protected IStatus run(IProgressMonitor monitor) {
                boolean isEnabled = this.isSOIEnabled();
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                    if (DHBreadcrumbViewer.this.selectOtherInstanceButton == null || DHBreadcrumbViewer.this.selectOtherInstanceButton.isDisposed()) {
                        ObjectionManager.getInstance().clear(Objection.DESIGN_BC_SOI);
                        return;
                    }
                    DHBreadcrumbViewer.this.selectOtherInstanceButton.setEnabled(isEnabled);
                    DHBreadcrumbViewer.this.selectOtherInstanceButton.setToolTipText(DHBreadcrumbViewer.SOI_TOOLTIP_TEXT);
                    DHBreadcrumbViewer.this.fBreadcrumbHostComposite.layout();
                    DHBreadcrumbViewer.this.fStackComposite.getParent().layout();
                    ObjectionManager.getInstance().clear(Objection.DESIGN_BC_SOI);
                });
                return Status.OK_STATUS;
            }

            private boolean isSOIEnabled() {
                if (DHBreadcrumbViewer.this.fBreadcrumbInput == null) {
                    return false;
                }
                IRfDesignElement leafDesignElement = DHBreadcrumbViewer.this.fBreadcrumbInput.getLeafDesignElement();
                IRfBreadcrumbElement leafSegment = DHBreadcrumbViewer.this.fBreadcrumbInput.getLeafSegment();
                if (!(leafSegment instanceof ElementPath)) {
                    return false;
                }
                ELManager manager = RfMixedLangManager.getInstance().getELManager(DHBreadcrumbViewer.this.getProject());
                if (manager == null) {
                    return false;
                }
                IELMemory memory = manager.getMemory();
                AbstractBreadcrumbUtils breadcrumbUtils = DHBreadcrumbViewer.this.fActiveEditor.getBreadcrumbUtils(DHBreadcrumbViewer.class);
                if (!(breadcrumbUtils instanceof DHBreadcrumbUtils)) {
                    return false;
                }
                if (!DesignPathManager.getInstance().isEligible(DHBreadcrumbViewer.this.fActiveEditor) || DHBreadcrumbViewer.this.editorCursor < 0) {
                    return memory.hasInstancesFor(((DHBreadcrumbUtils)breadcrumbUtils).resolveToArchitecture(leafDesignElement), false, 2);
                }
                DVTEditor editor = (DVTEditor)DHBreadcrumbViewer.this.fActiveEditor;
                ElementPath pathAtCursor = DesignPathManager.getInstance().getPathFor(editor, DHBreadcrumbViewer.this.editorCursor, false, true);
                IRfNamedElement elementAtCursor = DesignPathManager.getInstance().getElementFor(editor, DHBreadcrumbViewer.this.editorCursor, true);
                if (!(elementAtCursor instanceof IRfDesignElement)) {
                    return false;
                }
                DHBreadcrumbViewer.this.designElementAtCursor = (IRfDesignElement)elementAtCursor;
                boolean isElaboratedPath = pathAtCursor != null && pathAtCursor != DesignPathManagerCommon.FROZEN_MANAGER_EL_PATH;
                return memory.hasInstancesFor(DHBreadcrumbViewer.this.designElementAtCursor, IRfNamedElement.ElementKind.VHDL_ENTITY.equals((Object)DHBreadcrumbViewer.this.designElementAtCursor.getKind()), isElaboratedPath ? 2 : 1);
            }
        };
        computeInstances.setSystem(true);
        computeInstances.schedule();
    }

    @Override
    protected AbstractBreadcrumbItem createItem() {
        return new DHBreadcrumbItem(this, this.getContainer());
    }

    @Override
    protected void filterItem(AbstractBreadcrumbItem item, Object element) {
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(this.getProject());
        if (elManager == null) {
            return;
        }
        if (!(element instanceof ElementPath)) {
            return;
        }
        if (ElementPath.$ROOT_NAME_PATH.equals(element)) {
            item.setShowText(false);
        }
        if (!(this.fActiveEditor instanceof DDiagramEditor)) {
            return;
        }
        if (elManager.getMemory().isGenerateBlock((ElementPath)element)) {
            item.setGrayedOut(true);
        } else {
            item.setGrayedOut(false);
        }
    }

    @Override
    public void setSelectOtherInstancesButtonEnable(boolean isReadOnly) {
        if (this.selectOtherInstanceButton == null || this.selectOtherInstanceButton.isDisposed()) {
            return;
        }
        this.selectOtherInstanceButton.setEnabled(isReadOnly);
    }

    @Override
    public void designPathNotification(DPMNotification notification) {
        try {
            boolean enabled;
            if (notification == null) {
                return;
            }
            this.editorCursor = this.getEditorCursor();
            if (this.editorCursor == -1) {
                return;
            }
            boolean bl = enabled = BreadcrumbStateHandler.isBreadcrumbEnabled() && BreadcrumbMode.DESIGN.isEnabled();
            if (!enabled) {
                Display.getDefault().asyncExec(() -> this.hideBreadcrumb());
            }
            if (notification.getKind() != null) {
                boolean forceUpdate = this.isReadOnly() || notification.getKind() == DPMNotification.DPMNotificationKind.FORCE_UPDATE;
                this.updateNonGUIPart(DHBreadcrumbViewer.class, new DHBreadcrumbConfiguration(forceUpdate, this.editorCursor), enabled);
                this.lastVisitedRegion.updateLastVisitedRegion(this.editorCursor);
                return;
            }
            if (this.lastVisitedRegion.isInsideLastRegion(this.editorCursor)) {
                ObjectionManager.getInstance().clear(Objection.DESIGN_BC);
                return;
            }
            this.updateNonGUIPart(DHBreadcrumbViewer.class, new DHBreadcrumbConfiguration(false, this.editorCursor), enabled);
            this.lastVisitedRegion.updateLastVisitedRegion(this.editorCursor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public DVTEditor getDVTEditor() {
        return this.fActiveEditor instanceof DVTEditor ? (DVTEditor)this.fActiveEditor : null;
    }

    private int getEditorCursor() {
        ArrayList cursorWrapper = new ArrayList();
        Display.getDefault().syncExec(() -> {
            if (this.fActiveEditor == null) {
                cursorWrapper.add(-1);
                return;
            }
            cursorWrapper.add(this.fActiveEditor.getCursor());
        });
        return (Integer)cursorWrapper.get(0);
    }

    @Override
    public void updateNonGUIPart(Class<?> breadcrumbType, AbstractBreadcrumbConfiguration configuration, boolean enabled) {
        if (!DesignPathManager.getInstance().isEligible(this.fActiveEditor)) {
            super.updateNonGUIPart(breadcrumbType, configuration, enabled);
            return;
        }
        try {
            AbstractBreadcrumbUtils bcUtils = this.fActiveEditor.getBreadcrumbUtils(breadcrumbType);
            if (bcUtils == null) {
                return;
            }
            this.fBreadcrumbInput = bcUtils.computeBreadcrumbInput(this.fActiveEditor, configuration, enabled);
            this.setModelReady(true);
            BreadcrumbInput bcInput = this.fBreadcrumbInput;
            Display.getDefault().syncExec(() -> {
                try {
                    try {
                        this.updateGuiPart(enabled, bcInput);
                        this.changeReadOnlyState();
                    }
                    catch (Throwable t) {
                        DVTLogger.INSTANCE.logError(t);
                        ObjectionManager.getInstance().clear(Objection.DESIGN_BC);
                    }
                }
                finally {
                    ObjectionManager.getInstance().clear(Objection.DESIGN_BC);
                }
            });
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
        }
    }

    @Override
    protected boolean setNoElabComposite(BreadcrumbInput bcInput) {
        if (BreadcrumbInput.NO_ELAB_ELEM_IN_FILE == bcInput) {
            this.fStackLayout.topControl = this.noElabElemInFileComposite;
            return true;
        }
        if (BreadcrumbInput.NO_ELAB_ELEM_AT_CURSOR == bcInput) {
            this.fStackLayout.topControl = this.noElabElemAtCursorComposite;
            return true;
        }
        return false;
    }

    @Override
    protected AbstractBreadcrumbUtils getUtils() {
        if (this.fActiveEditor == null) {
            return null;
        }
        return this.fActiveEditor.getBreadcrumbUtils(DHBreadcrumbViewer.class);
    }

    public boolean testIsEnabledSelectOtherInstanceButton() {
        return !this.selectOtherInstanceButton.isDisposed() && this.selectOtherInstanceButton.isEnabled() && this.selectOtherInstanceButton.isVisible();
    }

    public BreadcrumbInput testGetBreadcrumbInput() {
        return this.fBreadcrumbInput;
    }

    public IDoubleClickListener testGetElementClickListener() {
        return this.fElementClickListener;
    }

    public IOpenListener testGetClickFromDropDownListener() {
        return this.fOpenFromDropDownListener;
    }

    @Override
    public Button testGetSelectOtherInstanceButton() {
        return this.selectOtherInstanceButton;
    }

    @Override
    public MenuDetectListener testGetMenuDetectListener() {
        return this.fContextMenuListener;
    }

    public SelectionListener testGetCopyHierarchyPathListener() {
        return this.copyHierarchyPathListener;
    }
}

